
<!--- This file is automatically generated by make gen-cli-docs; changes should be made in the go CLI command code (under cmd/kops) -->

## kops rolling-update cluster

Rolling update a cluster.

### Synopsis

This command updates a kubernetes cluster to match the cloud and kops specifications.

To perform a rolling update, you need to update the cloud resources first with the command
`kops update cluster`.

If rolling-update does not report that the cluster needs to be rolled, you can force the cluster to be
rolled with the force flag.  Rolling update drains and validates the cluster by default.  A cluster is
deemed validated when all required nodes are running and all pods in the kube-system namespace are operational.
When a node is deleted, rolling-update sleeps the interval for the node type, and then tries for the same period
of time for the cluster to be validated.  For instance, setting --master-interval=3m causes rolling-update
to wait for 3 minutes after a master is rolled, and another 3 minutes for the cluster to stabilize and pass
validation.

Note: terraform users will need to run all of the following commands from the same directory
`kops update cluster --target=terraform` then `terraform plan` then
`terraform apply` prior to running `kops rolling-update cluster`.

```
kops rolling-update cluster [flags]
```

### Examples

```
  # Preview a rolling-update.
  kops rolling-update cluster
  
  # Roll the currently selected kops cluster with defaults.
  # Nodes will be drained and the cluster will be validated between node replacement.
  kops rolling-update cluster --yes
  
  # Roll the k8s-cluster.example.com kops cluster,
  # do not fail if the cluster does not validate,
  # wait 8 min to create new node, and wait at least
  # 8 min to validate the cluster.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --fail-on-validate-error="false" \
  --master-interval=8m \
  --node-interval=8m
  
  # Roll the k8s-cluster.example.com kops cluster,
  # do not validate the cluster because of the cloudonly flag.
  # Force the entire cluster to roll, even if rolling update
  # reports that the cluster does not need to be rolled.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --cloudonly \
  --force
  
  # Roll the k8s-cluster.example.com kops cluster,
  # only roll the node instancegroup,
  # use the new drain and validate functionality.
  kops rolling-update cluster k8s-cluster.example.com --yes \
  --fail-on-validate-error="false" \
  --node-interval 8m \
  --instance-group nodes
```

### Options

```
      --bastion-interval duration      Time to wait between restarting bastions (default 15s)
      --cloudonly                      Perform rolling update without confirming progress with k8s
      --fail-on-drain-error            The rolling-update will fail if draining a node fails. (default true)
      --fail-on-validate-error         The rolling-update will fail if the cluster fails to validate. (default true)
      --force                          Force rolling update, even if no changes
  -h, --help                           help for cluster
      --instance-group strings         List of instance groups to update (defaults to all if not specified)
      --instance-group-roles strings   If specified, only instance groups of the specified role will be updated (e.g. Master,Node,Bastion)
  -i, --interactive                    Prompt to continue after each instance is updated
      --master-interval duration       Time to wait between restarting masters (default 15s)
      --node-interval duration         Time to wait between restarting nodes (default 15s)
      --post-drain-delay duration      Time to wait after draining each node (default 5s)
      --validation-timeout duration    Maximum time to wait for a cluster to validate (default 15m0s)
  -y, --yes                            Perform rolling update immediately, without --yes rolling-update executes a dry-run
```

### Options inherited from parent commands

```
      --alsologtostderr                  log to standard error as well as files
      --config string                    yaml config file (default is $HOME/.kops.yaml)
      --log_backtrace_at traceLocation   when logging hits line file:N, emit a stack trace (default :0)
      --log_dir string                   If non-empty, write log files in this directory
      --log_file string                  If non-empty, use this log file
      --log_file_max_size uint           Defines the maximum size a log file can grow to. Unit is megabytes. If the value is 0, the maximum file size is unlimited. (default 1800)
      --logtostderr                      log to standard error instead of files (default true)
      --name string                      Name of cluster. Overrides KOPS_CLUSTER_NAME environment variable
      --skip_headers                     If true, avoid header prefixes in the log messages
      --skip_log_headers                 If true, avoid headers when opening log files
      --state string                     Location of state storage (kops 'config' file). Overrides KOPS_STATE_STORE environment variable
      --stderrthreshold severity         logs at or above this threshold go to stderr (default 2)
  -v, --v Level                          number for the log level verbosity
      --vmodule moduleSpec               comma-separated list of pattern=N settings for file-filtered logging
```

### SEE ALSO

* [kops rolling-update](kops_rolling-update.md)	 - Rolling update a cluster.

