# Bot Framework SDK Pipelines List
Below is a list of pipelines and their .yml files for building and publishing the SDK products. They are grouped by project, builds/releases, product, and build name. This shows the builds as of 2/20/2020. Some may have changed since. For the most up-to-date representation, please use the links below.

For an overview, see the [Bot Framework SDK Product Pipelines Overview](BotFrameworkSdkPipelinesOverview.md) document.

### Project: [SDK_Public](https://fuselabs.visualstudio.com/SDK_Public/_build?treeState=XGRvdG5ldCRcd2VjaGF0JFxjbGk%3D&view=folders)
  * [builds](https://fuselabs.visualstudio.com/SDK_Public/_build?treeState=XGRvdG5ldCRcd2VjaGF0JFxjbGk%3D&view=folders)
    * cli
      * botframework-cli
        * botframework-cli.yml
      * botframework-cli-mac
        * botframework-cli-mac.yml
    * dotnet
      * BotBuilder-DotNet-CI-PR-(MacLinux)-yaml
        * botbuilder-dotnet-ci-mac.yml
      * BotBuilder-DotNet-CI-PR-yaml
        * botbuilder-dotnet-ci.yml
          * ci-build-steps.yml
          * ci-test-steps.yml
          * ci-api-validation-steps.yml
          * ci-post-to-github-steps.yml
    * wechat
      * BotFramework-WeChat-DotNet-CI-PR
        * botframework-wechat-dotnet.yml
      * BotFramework-WeChat-DotNet-Daily
        * botframework-wechat-dotnet-daily.yml
          * dotnet-build-steps.yml
          * dotnet-sign-steps.yml
      * BotFramework-WeChat-JS
        * botframework-wechat-js.yml
  * [releases](https://fuselabs.visualstudio.com/SDK_Public/_release?_a=releases&view=all&path=%5C)
    * cli
      * [[PROD]]Push-Botframework-CLI-to-npmjs
      * Push-Botframework-CLI-to-MyGet-daily
    * wechat
      * Push-BotFramework-WeChat-to-MyGet
      * Push-BotFramework-WeChat-JS-to-MyGet
### Project: [SDK_v4](https://fuselabs.visualstudio.com/SDK_v4/_build?view=folders)
  * [builds](https://fuselabs.visualstudio.com/SDK_v4/_build?view=folders)
    * AI
      * BotBuilder-AI-JS-generator-next-daily
      * BotBuilder-AI-JS-libs-next-daily
      * BotBuilder-AI-JS-SkillsCli-next-daily
      * BotBuilder-DotNet-AI-Signed-4.6-daily-paused
      * BotBuilder-DotNet-AI-Signed-future-daily-paused
      * BotBuilder-DotNet-AI-Signed-master
      * BotBuilder-DotNet-AI-Signed-next
      * BotBuilder-NetCoreTemplate-VASkills-daily
    * DotNet
      * BotBuilder-DotNet-oauthcardsso
      * BotBuilder-DotNet-Signed-yaml
        * botbuilder-dotnet-sign.yml
          * ci-build-steps.yml
          * sign-steps.yml
          * functional-test-setup-steps.yml
      * FunctionalTests
        * Botbuilder-DotNet-Facebook-Functional-Tests-yaml
          * botbuilder-dotnet-ci-facebook-test.yml
            * ci-build-steps.yml
        * BotBuilder-DotNet-Functional-Tests-Linux-yaml
          * botbuilder-dotnet-functional-test-linux.yml
            * ci-build-steps.yml
        * BotBuilder-DotNet-Functional-Tests-Windows-yaml
          * botbuilder-dotnet-functional-test-windows.yml
            * ci-build-steps.yml
        * BotBuilder-Dotnet-Slack-Functional-Tests-yaml
          * botbuilder-dotnet-ci-slacktest.yml
            * ci-build-steps.yml
        * BotBuilder-DotNet-Webex-Functional-Test-yaml
          * botbuilder-dotnet-ci-webex-test.yml
            * ci-build-steps.yml
      * LegacyVersions
        * BotBuilder-DotNet-4.0-CI-PR
        * BotBuilder-DotNet-4.1-CI-PR
        * BotBuilder-DotNet-4.2-CI-PR
        * BotBuilder-DotNet-4.5-CI-PR
        * BotBuilder-DotNet-4.5-Signed
        * BotBuilder-DotNet-4.7-Signed
    * Java
      * BotBuilder-Java-4.0-CI-PR
      * BotBuilder-Java-4.0-daily
    * JS
      * BotBuilder-JS-4.6-CI
      * BotBuilder-JS-4.6-daily
      * BotBuilder-JS-master-CI
      * BotBuilder-JS-master-daily
      * FunctionalTests
	       * Run-JS-Functional-Tests-BrowserBot-yaml
          * browser-tests-build-ci.yml
        * Run-JS-Functional-Tests-Linux
        * Run-JS-Functional-Tests-Linux-Gov
        * Run-JS-Functional-Tests-Windows
        * Run-JS-Functional-Tests-Windows-Gov
    * Python
      * microsoft.botbuilder-python
        * azure-pipelines.yml
      * Python-CI-PR
        * ci-pr-pipeline.yml
      * Run-Python-Functional-Tests-Linux
      * SDK_v4-Python-CI-PR
      * SDK_v4-Python-daily-build
    * Samples
      * BotBuilder-Generator-JS-daily
      * BotBuilder-Generators-DotNet-daily
      * BotBuilder-Samples-DotNet-CI-PR
      * BotBuilder-Samples-JS-ESLint
      * BotBuilder-Samples-Python-zip
      * Handoff Daily Build
    * SkillBots
	     * DotNetDotNetSkillBotFunctionalTest
        * dotnetHost2dotnetSkill.yml
      * DotNetJsSkillBotFunctionalTest
        * dotnetHost2JavascriptSkill.yml 
      * DotNetPySkillBotFunctionalTest
        * dotnetHost2PythonSkill.yml 
      * JsDotNetSkillBotFunctionalTest
        * javascriptHost2DotnetSkill.yml 
      * JsJsSkillBotFunctionalTest
        * javascriptHost2JavascriptSkill.yml
      * JsPySkillBotFunctionalTest
        * javascriptHost2PythonSkill.yml 
      * PyDotNetSkillBotFunctionalTest
        * pythonHost2DotnetSkill.yml
      * PyJsSkillBotFunctionalTest
        * pythonHost2JavascriptSkill.yml 
      * PythonPythonSkillBotFunctionalTest
        * pythonHost2PythonSkill.yml
    * Tools
      * BotBuilder-Tools-DotNet-CI-PR
      * BotBuilder-Tools-DotNet-Sign-daily
      * Botbuilder-tools-js-CI-PR
      * Botbuilder-tools-js-daily
    * V3
      * BotBuilder-v3-Azure
      * BotBuilder-v3-Cognitive-Services-daily
      * BotBuilder-v3-DotNet-master
      * BotBuilder-v3-JS-Azure-daily
      * BotBuilder-v3-JS-CI
      * BotBuilder-v3-JS-daily
    * VSIX
      * Skill-Template-VSIX
    * VSIX
      * Virtual-Assistant-Template-VSIX
    * VSIX
      * VSIX-From-botbuilder-samples-repo
  * [releases](https://fuselabs.visualstudio.com/SDK_v4/_release?_a=releases&view=all&path=%5C)
    * AI
      * [[PROD]] Push-BotBuilder-DotNet-AI-Signed-to-Nuget.org
      * [[PROD]] Push-BotBuilder-JS-Libs-AI-master-to-NPM
      * [[PROD]] Push-BotBuilder-JS-SkillsCli-AI-master-to-NPM
      * [[PROD]] Push-BotBuilder-JS-VAGenerator-AI-master-to-NPM
      * Push-BotBuilder-DotNet-AI-Signed-to-MyGet-daily
      * Push-BotBuilder-JS-AI-Libs-master-to-MyGet-daily
      * Push-BotBuilder-JS-AI-SkillsCli-master-to-MyGet-daily
      * Push-BotBuilder-JS-AI-VAGenerator-master-to-MyGet-daily
      * Push-BotBuilder-NetCoreTemplates-AI-Signed-to-MyGet-daily
    * CLI
      * [[PROD]]Push-Botframework-CLI-to-npmjs
      * Push-Botframework-CLI-to-MyGet-daily
    * DotNet
      * [[PROD]]Push-BotBuilder-DotNet-4.7-Signed-to-Nuget
      * [[PROD]]Push-BotBuilder-DotNet-Signed-to-Nuget-from-yaml
      * FunctionalTests
        * [deprecated]DotNet-Functional-Tests-Linux-from-yaml
        * [deprecated]DotNet-Functional-Tests-Windows-from-yaml
        * DotNet-Functional-Tests-Linux-from-signed-yaml
        * DotNet-Functional-Tests-Windows-from-signed-yaml
        * DotNet-Functional-Tests-Windows-from-yaml-New
        * DotNet-Slack-Tests-Windows-from-signed-yaml
      * Push-BotBuilder-DotNet-4.7-Signed-to-MyGet
      * Push-BotBuilder-DotNet-oauthcardsso-to-MyGet-daily
      * Push-BotBuilder-DotNet-Signed-to-MyGet-from-yaml
    * Java
      * Push-BotBuilder-Java-to-MyGet
      * Push-BotBuilder-Java-to-MyGet-Scratch
    * JS
      * [[PROD]]Push-BotBuilder-JS-4.6-to-npmjs
      * [[PROD]]Push-BotBuilder-JS-master-to-npmjs
      * Push-BotBuilder-JS-4.6-to-MyGet-daily
      * Push-BotBuilder-JS-master-to-MyGet-daily
      * Push-BotBuilder-JS-Preview-to-MyGet-Manual
    * Python
      * [[PROD]]Push-BotBuilder-Python-to-PyPI
      * Push-BotBuilder-Python-master-to-AzureArtifacts-daily
    * Samples
      * [[PROD]]Push-BotBuilder-Generator-JS-to-npmjs
      * [[PROD]]Push-BotBuilder-Generators-DotNet-to-Nuget
      * [[PROD]]Push-Samples-DotNet-to-Nuget
      * [[PROD]]Push-Samples-Python-to-Github
      * Push-BotBuilder-Generator-JS-to-MyGet-daily
      * Push-BotBuilder-Generators-DotNet-to-MyGet-daily
      * Push-Handoff-DotNet-Signed-to-MyGet-daily
      * Push-Samples-DotNet-to-MyGet-daily
    * Tools
      * [[PROD]]Push-Tools-DotNet-Sign-to-Nuget
      * [[PROD]]Push-Tools-JS-to-npmjs
      * Push-Tools-DotNet-Sign-to-MyGet-daily
      * Push-Tools-JS-to-MyGet-daily
    * V3
      * [[PROD]]Push-BotBuilder-v3-DotNet-Master-to-Nuget
      * [[PROD]]Push-BotBuilder-v3-JS-daily-to-npmjs
      * Push-BB-v3-Cognitive-Services-to-MyGet-daily
      * Push-BB-v3-Cognitive-Services-to-MyGet-Scratch
      * Push-BotBuilder-v3-DotNet-Master-to-MyGet
      * Push-BotBuilder-v3-JS-to-MyGet-daily
    * VSIX
      * Push-BotBuilder-Samples-VSIX-to-MyGet-AI
    * VSIX
      * Push-BotBuilder-Samples-VSIX-to-MyGet-Scratch
    * WeChat
      * Push-BotFramework-WeChat-to-MyGet
