# August 2020 (version 4.10.0) 

Welcome to the August 2020 release of the Bot Framework SDK. We are introducing some exciting [Additional New Features](#Additional-New-SDK-Features) with [Updates and Enhancements](#Other-Updates-and-Enhancements). This milestone we focused on all-up quality and engineering debt, broken down across the following pillars: 

- [Documentation](#Documentation) Includes improvements to existing documentation and net new documentation centered on recurring issues and developer pain points.

- [Customer Supportability](#Customer-Supportability) Improvements focused on developers seeking assistance using the Bot Framework, tools and SDKs.

- [Customer Ask](#Customer-Ask) Implemented enhancements and feature requests from the developer community and 3rd parties using the Bot Framework SDK and tools.

- [Code Quality](#Code-Quality) Enforcement of code styling and format rules, increased testing code coverage, and functional tests.

- [Team Agility](#Team-Agility) Improved validation of SDK code and integration with supporting libraries and environments. Continuous integarion and build pipleline improvements.

**Insiders**: Want to try new features as soon as possible? You can download the nightly Insiders build [[C#](https://github.com/microsoft/botbuilder-dotnet/blob/master/UsingMyGet.md)] [[JS](https://github.com/microsoft/botbuilder-js/blob/master/UsingMyGet.md)] [[Python](https://github.com/microsoft/botbuilder-python/blob/master/UsingTestPyPI.md)] [[CLI](https://github.com/Microsoft/botframework-cli#nightly-builds)] and try the latest updates as soon as they are available. And for the latest Bot Framework news, updates, and content, follow us on Twitter @msbotframework!

## Documentation
[BF Docs GitHub](https://github.com/issues?q=is%3Aissue+label%3A%22BF+Docs%22+label%3AR10)

Following feedback from customers and the Bot Framework Support Team, a number of net new documents have been written as well as updates to existing documentation. These are helpful towards providing answers and information relating to recurring issues from bot developers.

- Code comment documentation
- Samples readme improvements
- SDK repository readme and wiki updates
- New documents addressing recurring bot developer issues

## Customer Supportability 

[BF Supportability GitHub](https://github.com/issues?q=is%3Aissue+label%3A%22BF+Supportability%22+label%3AR10)

Developers using the Microsoft Bot Framework have many avenues for getting help. See [additional resources](https://docs.microsoft.com/en-us/azure/bot-service/bot-service-resources-links-help) Internal tools have been improved to increase the responsiveness of the engineering team in areas of most interest to developers.

- Creation of internal bots and improved tools for customer support
- Improved analytics of trends in customer reported feature requests and issues
- Coordination of labels across `GitHub` repositories

## Customer Ask 
[BF Customer Ask GitHub](https://github.com/issues?q=is%3Aissue+label%3A%22BF+Customer+Ask%22+label%3AR10)

- Additional Teams channel lifecycle events
- Improved `Application Insights` integration
- Coordination of labels across `Git Hub` repositories
- Add Locale to `ConversationUpdate`
- Update `CardAction` to support alt text for images on buttons
- Update `Skill Handler` to return `Resource Response`
- Release of library using latest `Azure Blobs` storage
- Enable custom fields for `Entity`
- Fixes to OAuthPrompt timeout and addition of EndOnInvalidMessage
- Various bug fixes and telemetry improvements

## Code Quality

- Analyzer rules in place and running (code style and format)
- Unit test code coverage and quality
- Increased profiling of the code base
- Swagger file unified across SDK repositories and version # introduced
- Specific SDKs asks and needs:
    - Settings object pattern for C# adapters
    - LG dependent files testing (C#)
    - Dependency policing (JS)
    - Integration tests with Direct Line JS and adaptive cards

## Team Agility

[BF Team Agility GitHub](https://github.com/issues?q=is%3Aissue+label%3A%22BF+Agility%22+label%3AR10)

Improvements have been made across SDK repositories towards decreased CI pipeline times, improved testing, including both functional integration and unit tests.

### Speed​

- Reduce time to build for SDKs (local and remote)​
- Reduce SDK unit test duration through refactoring and/or concurrent approaches​
- Refactor ADO pipelines into smaller, separate jobs or stages​
- Run as-applicable pipelines (e.g. no style-checks on .yaml files)​

### ​Reliability​

- Refine or replace current monorepo/”mono-solution” setups as necessary​
- Address nondeterministic build/test failures
- Enable continuous integration for forked pull request submissions
- Complete integration tests added with bots dynamically created

## Other Updates and Enhancements
* [Microsoft Teams](#Microsoft-Teams) Continued improvements to Microsoft Teams API support
* [Bot Framework CLI Tools](#Bot-Framework-CLI-Tools) `Lg` added as core plugin, publish preview builds to npm, other improvements
* [Bot Builder Samples](#Samples) Readme updates, CI improvements, new Teams `Typescript` samples
* [Composer](#Composer) Advancements in Skills support and Cognitive Services integration
* [Web Chat](#Web-Chat) Many Accessibility improvements
* [Emulator](#Emulator) Bug fixes and updates

## Microsoft Teams 

- SDK and `OAuthPrompt` now support Teams SSO
- Increased `Adaptive Dialog` support for Teams events
- SDK supprot for lifecyle events: `ChannelRestored`, `TeamArchived`, `TeamUnarchived`,`TeamRestored`, `TeamDeleted`, and `TeamHardDeleted` 
- `InstallationUpdate` activity type support
- `LinkToMessage` added to `MessageActionsPayload`

## Bot Framework CLI Tools
- `Lg` added as BF-CLI core plugin
- Enhancements and fixes to `lu` parser
- `QnaMaker` support extended
- Publish daily builds and RCs of `botframework-cli` to npm

## Samples
- Readme updates and consolidation across language samples
- Build pipelines for samples CI
- Demonstreate using Locale in `ConversationUpdate` welcome message sample
- Additional Teams samples in [Typescript](https://github.com/microsoft/BotBuilder-Samples/tree/master/samples/typescript_nodejs)
- Teams `TaskModule` samples now includes [HTML/JavaScript task modules](https://docs.microsoft.com/microsoftteams/platform/task-modules-and-cards/what-are-task-modules#task-module-css-for-htmljavascript-task-modules)

## Composer
- The Bot Framework SDK continues to support the `Bot Framework Composer`.

See Composer [1.1.0 Release Notes](https://github.com/microsoft/BotFramework-Composer/blob/main/releases/1.1.0.md)

## Web Chat
- Many accessibility improvements and fixes
- Group activity by timestamp and sender
- Convert emoticon to Emoji
- Added scrolling API: allow save/restore scroll position and scroll to specific activity

## Emulator
- Added an additional log panel entry on conversation start that displays the current bot's endpoint
- Fixed a bug where trying to open the sign-in link on an OAuth card when ngrok was not configured would cause the Windows File Explorer to open
- Improved CONTRIBUTING.md to more accurately reflect requisites to build the Emulator from source
- Updates to Cosmos DB service editor dialog

## Additional New SDK Features
- [Orchestrator](https://aka.ms/bf-orchestrator): Transformer based solution that runs locally with your bot to dispatch across one or more [Bot Builder Skills](https://docs.microsoft.com/en-us/azure/bot-service/bot-builder-skills-overview) or [LUIS](https://www.luis.ai/) applications or [QnA Maker](https://www.qnamaker.ai/) Knowledgebase.

- [Microsoft.Bot.Builder.Azure.Queues](Microsoft.Bot.Builder.Azure.Queues) (preview) Enables more easily interacting with [Azure Queues](https://docs.microsoft.com/azure/storage/queues/storage-queues-introduction) and `ContinueConversationLater` Dialog

- [Microsoft.Bot.Builder.Azure.Blobs](Microsoft.Bot.Builder.Azure.Blobs) `BlobsStorage` and `BlobsTranscriptStore` implementations replacing `AzureBlobStorage` and `AzureBlobTranscriptStore`. This library uses [Azure.Storage.Blobs](https://www.nuget.org/packages/Azure.Storage.Blobs) and is a replacement for the older [Microsoft.Azure.Storage.Blob](https://www.nuget.org/packages/Microsoft.Azure.Storage.Blob/) used by [Microsoft.Bot.Builder.Azure](https://www.nuget.org/packages/Microsoft.Bot.Builder.Azure/).
