#include "runtime_impl.h"
#include "uuid_util.h"

#include "common/common/utility.h"

bool UuidUtils::uuidModBy(const std::string& uuid, uint16_t& out, uint16_t mod) {
  if (uuid.length() < 8) {
    return false;
  }

  uint64_t value;
  if (!StringUtil::atoul(uuid.substr(0, 8).c_str(), value, 16)) {
    return false;
  }

  out = value % mod;
  return true;
}

UuidTraceStatus UuidUtils::isTraceableUuid(const std::string& uuid) {
  if (uuid.length() != Runtime::RandomGeneratorImpl::UUID_LENGTH) {
    return UuidTraceStatus::NoTrace;
  }

  switch (uuid[TRACE_BYTE_POSITION]) {
  case TRACE_FORCED:
    return UuidTraceStatus::Forced;
  case TRACE_SAMPLED:
    return UuidTraceStatus::Sampled;
  case TRACE_CLIENT:
    return UuidTraceStatus::Client;
  default:
    return UuidTraceStatus::NoTrace;
  }
}

bool UuidUtils::setTraceableUuid(std::string& uuid, UuidTraceStatus trace_status) {
  if (uuid.length() != Runtime::RandomGeneratorImpl::UUID_LENGTH) {
    return false;
  }

  switch (trace_status) {
  case UuidTraceStatus::Forced:
    uuid[TRACE_BYTE_POSITION] = TRACE_FORCED;
    break;
  case UuidTraceStatus::Client:
    uuid[TRACE_BYTE_POSITION] = TRACE_CLIENT;
    break;
  case UuidTraceStatus::Sampled:
    uuid[TRACE_BYTE_POSITION] = TRACE_SAMPLED;
    break;
  case UuidTraceStatus::NoTrace:
    uuid[TRACE_BYTE_POSITION] = NO_TRACE;
    break;
  }

  return true;
}
