import pytest

from statistic.time_stats import _build_time_dict, _fill_in_time_gaps


def test_build_time_dict():
    test_input = [{'_id': {'month': 12, 'year': 2016}, 'count': 10},
                  {'_id': {'month': 1, 'year': 2017}, 'count': 8}]
    expected_result = {2016: {12: 10}, 2017: {1: 8}}
    assert _build_time_dict(test_input) == expected_result


@pytest.mark.parametrize('input_data, expected', [
    ({}, {}),
    ({2016: {11: 10}, 2017: {2: 8}}, {2016: {11: 10, 12: 0}, 2017: {1: 0, 2: 8}}),
    ({2000: {12: 1}, 2002: {1: 1}},
     {2000: {12: 1}, 2001: {1: 0, 2: 0, 3: 0, 4: 0, 5: 0, 6: 0, 7: 0, 8: 0, 9: 0, 10: 0, 11: 0, 12: 0},
      2002: {1: 1}})
])
def test_fill_in_time_gaps(input_data, expected):
    _fill_in_time_gaps(input_data)
    assert input_data == expected
