var React = require('react');
var Route = require('./Route');

function createRedirectHandler(to) {
  return React.createClass({
    statics: {
      willTransitionTo: function (transition, params, query) {
        transition.redirect(to, params, query);
      }
    },

    render: function () {
      return null;
    }
  });
}

/**
 * A <Redirect> component is a special kind of <Route> that always
 * redirects to another route when it matches.
 */
function Redirect(props) {
  return Route({
    name: props.name,
    path: props.from || props.path || '*',
    handler: createRedirectHandler(props.to)
  });
}

module.exports = Redirect;
