var invariant = require('react/lib/invariant');
var RouteStore = require('../stores/RouteStore');
var Path = require('./Path');

/**
 * Returns an absolute URL path created from the given route name, URL
 * parameters, and query values.
 */
function makePath(to, params, query) {
  var path;
  if (to.charAt(0) === '/') {
    path = Path.normalize(to); // Absolute path.
  } else {
    var route = RouteStore.getRouteByName(to);

    invariant(
      route,
      'Unable to find a route named "' + to + '". Make sure you have ' +
      'a <Route name="' + to + '"> defined somewhere in your routes'
    );

    path = route.props.path;
  }

  return Path.withQuery(Path.injectParams(path, params), query);
}

module.exports = makePath;
