var React = require('react');

function isValidChild(object) {
  return object == null || React.isValidElement(object);
}

function isReactChildren(object) {
  return isValidChild(object) || (Array.isArray(object) && object.every(isValidChild));
}

module.exports = isReactChildren;
