// ==========================================================================
// Project:  Ember Runtime
// Copyright: ©2006-2011 Strobe Inc. and contributors.
//            Portions ©2008-2011 Apple Inc. All rights reserved.
// License:   Licensed under MIT license (see license.js)
// ==========================================================================

require('ember-metal/mixin');

var IS_BINDING = Ember.IS_BINDING = /^.+Binding$/;

Ember._mixinBindings = function(obj, key, value, m) {
  if (IS_BINDING.test(key)) {
    if (!(value instanceof Ember.Binding)) {
      value = new Ember.Binding(key.slice(0,-7), value); // make binding
    } else {
      value.to(key.slice(0, -7));
    }
    value.connect(obj);

    // keep a set of bindings in the meta so that when we rewatch we can
    // resync them...
    var bindings = m.bindings;
    if (!bindings) {
      bindings = m.bindings = { __emberproto__: obj };
    } else if (bindings.__emberproto__ !== obj) {
      bindings = m.bindings = Ember.create(m.bindings);
      bindings.__emberproto__ = obj;
    }

    bindings[key] = true;
  }

  return value;
};
