import fs from 'fs'
import { resolve } from 'pathe'
import { execa } from 'execa'
import { describe, expect, it } from 'vitest'
import { parse } from 'flatted'

const skip = (process.platform === 'win32' || process.platform === 'darwin') && process.env.CI

describe.skipIf(skip)('html reporter', async () => {
  const vitestRoot = resolve(__dirname, '../../..')
  const root = resolve(__dirname, '../fixtures')

  it('resolves to "passing" status for test file "all-passing-or-skipped"', async () => {
    const [expected, testFile, basePath] = ['passing', 'all-passing-or-skipped', 'html/all-passing-or-skipped']
    await execa('npx', ['vitest', 'run', testFile, '--reporter=html', `--outputFile=${basePath}/index.html`], {
      cwd: root,
      env: {
        ...process.env,
        CI: 'true',
        NO_COLOR: 'true',
      },
      stdio: 'inherit',
    }).catch(e => e)
    const metaJson = fs.readFileSync(resolve(root, `${basePath}/html.meta.json`), { encoding: 'utf-8' })
    const indexHtml = fs.readFileSync(resolve(root, `${basePath}/index.html`), { encoding: 'utf-8' })
    const resultJson = parse(metaJson.replace(new RegExp(vitestRoot, 'g'), '<rootDir>'))
    resultJson.config = {} // doesn't matter for a test
    const file = resultJson.files[0]
    file.id = 0
    file.collectDuration = 0
    file.setupDuration = 0
    file.result.duration = 0
    file.result.startTime = 0
    const task = file.tasks[0]
    task.id = 0
    task.result.duration = 0
    task.result.startTime = 0
    expect(task.result.error).not.toBeDefined()
    expect(task.result.logs).not.toBeDefined()
    expect(resultJson).toMatchSnapshot(`tests are ${expected}`)
    expect(indexHtml).toMatch('window.METADATA_PATH="html.meta.json"')
  }, 120000)

  it('resolves to "failing" status for test file "json-fail"', async () => {
    const [expected, testFile, basePath] = ['failing', 'json-fail', 'html/fail']
    await execa('npx', ['vitest', 'run', testFile, '--reporter=html', `--outputFile=${basePath}/index.html`], {
      cwd: root,
      env: {
        ...process.env,
        CI: 'true',
        NO_COLOR: 'true',
      },
      stdio: 'inherit',
    }).catch(e => e)
    const metaJson = fs.readFileSync(resolve(root, `${basePath}/html.meta.json`), { encoding: 'utf-8' })
    const indexHtml = fs.readFileSync(resolve(root, `${basePath}/index.html`), { encoding: 'utf-8' })
    const resultJson = parse(metaJson.replace(new RegExp(vitestRoot, 'g'), '<rootDir>'))
    resultJson.config = {} // doesn't matter for a test
    const file = resultJson.files[0]
    file.id = 0
    file.collectDuration = 0
    file.setupDuration = 0
    file.result.duration = 0
    file.result.startTime = 0
    const task = file.tasks[0]
    task.id = 0
    task.result.duration = 0
    task.result.startTime = 0
    expect(task.result.error).toBeDefined()
    task.result.error.stack = task.result.error.stack.split('\n')[0]
    task.result.error.stackStr = task.result.error.stackStr.split('\n')[0]
    expect(task.logs).toBeDefined()
    expect(task.logs).toHaveLength(1)
    task.logs[0].taskId = 0
    task.logs[0].time = 0
    expect(resultJson).toMatchSnapshot(`tests are ${expected}`)
    expect(indexHtml).toMatch('window.METADATA_PATH="html.meta.json"')
  }, 120000)
})
