# 《Go 语言项目开发实战》课程目录

| 序号                                | 标题名                                                     |
| ----------------------------------- | ---------------------------------------------------------- |
| 开篇词                              | 从 0 开始搭建一个企业级 Go 应用                            |
| 01                                  | IAM系统概述：我们要实现什么样的 Go 项目？                  |
| 02                                  | 环境准备：如何安装和配置一个基本的 Go 开发环境？           |
| 03                                  | 项目部署：如何快速部署 IAM 系统？                          |
| **实战第 1 站：规范设计**           |                                                            |
| 04                                  | 规范设计（上）：项目开发杂乱无章，如何规范？               |
| 05                                  | 规范设计（下）：Commit 风格迥异、难以阅读，如何规范？      |
| 06                                  | 目录结构设计：如何组织一个可维护、可扩展的代码目录？       |
| 07                                  | 工作流设计：合理的多人开发模式该怎么设计？                 |
| 08                                  | 研发流程设计（上）：如何设计 Go 项目的开发流程？           |
| 09                                  | 研发流程设计（下）：如何管理应用的生命周期？               |
| 10                                  | 设计方法：怎么写出优雅的 Go 项目？                         |
| 11                                  | Go常见的设计模式有哪些？                                   |
| **实战第 2 站：基础功能设计或开发** |                                                            |
| 12                                  | API 风格（上）：如何设计RESTful API？                      |
| 13                                  | API 风格（下）：RPC API介绍                                |
| 14                                  | 项目管理：如何基于 Makefile 高效地管理项目？               |
| 15                                  | 代码检查：如何进行静态代码检查？                           |
| 16                                  | 研发流程实战：IAM项目是如何进行研发流程管理的？            |
| 17                                  | API 文档：如何生成 Swagger API 文档 ？                     |
| 18                                  | 错误处理（上）：如何设计错误包？                           |
| 19                                  | 错误处理（下）：如何设计一套科学的错误码？                 |
| 20                                  | 日志处理（上）：如何设计日志包并记录日志？                 |
| 21                                  | 日志处理（下）：手把手带你从 0 编写一个日志包              |
| 22                                  | 应用构建三剑客：Pflag、Viper、Cobra 核心功能介绍           |
| 23                                  | 应用构建实战：如何构建一个优秀的企业应用框架？             |
| **实战第 3 站：服务开发**           |                                                            |
| 24                                  | Web 服务：Web 服务核心功能有哪些？                         |
| 25                                  | 权限模型：5大权限模型是如何进行资源授权的？                |
| 26                                  | 认证机制：应用程序如何进行访问认证？                       |
| 27                                  | 控制流（上）：通过iam-apiserver设计，看Web服务的构建       |
| 28                                  | 控制流（下）：Web服务核心功能实现讲解                      |
| 29                                  | ORM：CURD 神器 GORM 包介绍                                 |
| 30                                  | 数据访问：业务系统如何跟数据库交互？                       |
| 31                                  | 数据流（上）：通过iam-authz-server设计，看数据流服务的设计 |
| 32                                  | 数据流（下）：数据流服务核心功能实现讲解                   |
| 33                                  | 数据处理：如何高效处理应用程序产生的数据？                 |
| 34                                  | SDK 设计（上）：如何设计出一个优秀的 Go SDK？              |
| 35                                  | SDK 设计（下）：如何开发出一个 Go SDK？                    |
| 36                                  | 效率神器：如何设计和实现一个命令行客户端工具？             |
| **实战第 4 站：服务测试**           |                                                            |
| 37                                  | 代码测试（上）：Go 语言单元测试、性能测试实战              |
| 38                                  | 代码测试（下）：Go 语言其它测试类型及 IAM 测试介绍         |
| 39                                  | 性能分析（上）：如何分析 Go 语言代码的性能？               |
| 40                                  | API Server 性能测试实战                                    |
| 41                                  | API Server 性能调优实战                                    |
| **实战第 5 站：服务部署**           |                                                            |
| 42                                  | 软件部署（上）：如何部署应用软件？                         |
| 43                                  | 软件部署（下）：如何在公有云上部署应用软件？               |
| 44                                  | 软件部署实战（上）：部署方案及负载均衡、高可用组件介绍     |
| 45                                  | 软件部署实战（中）：IAM 系统生产环境部署实战               |
| 46                                  | 软件部署实战（下）：IAM系统安全加固、水平扩缩容实战        |
| 47                                  | 容器化（上）：应用软件如何容器化部署？                     |
| 48                                  | 容器化（下）：基于腾讯 EKS 的容器化部署实战                |
| 49                                  | 服务编排（上）：多服务编排部署设计                         |
| 50                                  | 服务编排（下）：多服务编排部署实战                         |
| 51                                  | DevOps（上）：CI/CD 系统设计原理介绍                       |
| 52                                  | DevOps（下）：基于 Coding的 CI/CD 实战                     |
| 结束语                              | 如何让自己的 Go 研发之路走得更远                           |
