## iamctl jwt sign

Sign a jwt token with given secretID and secretKey

### Synopsis

Sign a jwt token with given secretID and secretKey

```
iamctl jwt sign SECRETID SECRETKEY
```

### Examples

```
  # Sign a token with secretID and secretKey
  iamctl sign tgydj8d9EQSnFqKf iBdEdFNBLN1nR3fV
  
  # Sign a token with expires and sign method
  iamctl sign tgydj8d9EQSnFqKf iBdEdFNBLN1nR3fV --timeout=2h --algorithm=HS256
```

### Options

```
      --algorithm string      Signing algorithm - possible values are HS256, HS384, HS512. (default "HS256")
      --audience string       Identifies the recipients that the JWT is intended for. (default "iam.authz.marmotedu.com")
      --claim map             Add additional claims. may be used more than once. (default {})
      --header map            Add additional header params. may be used more than once. (default {})
  -h, --help                  help for sign
      --issuer string         Identifies the principal that issued the JWT. (default "iamctl")
      --not-before duration   Identifies the time before which the JWT MUST NOT be accepted for processing.
      --timeout duration      JWT token expires time. (default 2h0m0s)
```

### Options inherited from parent commands

```
      --iamconfig string                      Path to the iamconfig file to use for CLI requests
      --match-server-version                  Require server version to match client version
      --profile string                        Name of profile to capture. One of (none|cpu|heap|goroutine|threadcreate|block|mutex) (default "none")
      --profile-output string                 Name of the file to write the profile to (default "profile.pprof")
  -s, --server.address string                 The address and port of the IAM API server
      --server.certificate-authority string   Path to a cert file for the certificate authority
      --server.insecure-skip-tls-verify       If true, the server's certificate will not be checked for validity. This will make your HTTPS connections insecure
      --server.max-retries int                Maximum number of retries.
      --server.retry-interval duration        The interval time between each attempt. (default 1s)
      --server.timeout duration               The length of time to wait before giving up on a single server request. Non-zero values should contain a corresponding time unit (e.g. 1s, 2m, 3h). A value of zero means don't timeout requests. (default 30s)
      --server.tls-server-name string         Server name to use for server certificate validation. If it is not provided, the hostname used to contact the server is used
      --user.client-certificate string        Path to a client certificate file for TLS
      --user.client-key string                Path to a client key file for TLS
      --user.password string                  Password for basic authentication to the API server
      --user.secret-id string                 SecretID for JWT authentication to the API server
      --user.secret-key string                SecretKey for jwt authentication to the API server
      --user.token string                     Bearer token for authentication to the API server
      --user.username string                  Username for basic authentication to the API server
```

### SEE ALSO

* [iamctl jwt](iamctl_jwt.md)	 - JWT command-line tool

###### Auto generated by spf13/cobra on 1-Apr-2021
