CONTENT: 

# OVERVIEW

What It Does: Fabric is an open-source framework designed to augment human capabilities using AI, making it easier to integrate AI into daily tasks.

Why People Use It: Users leverage Fabric to seamlessly apply AI for solving everyday challenges, enhancing productivity, and fostering human creativity through technology.

# HOW TO USE IT

Most Common Syntax: The most common usage involves executing Fabric commands in the terminal, such as `fabric --pattern <PATTERN_NAME>`.

# COMMON USE CASES

For Summarizing Content: `fabric --pattern summarize`
For Analyzing Claims: `fabric --pattern analyze_claims`
For Extracting Wisdom from Videos: `fabric --pattern extract_wisdom`
For Creating AI Agents: `echo "<TASK>" | fabric --agents`
For creating custom patterns: `fabric --pattern create_pattern`
- One possible place to store them is ~/.config/custom-fabric-patterns.
- Then when you want to use them, simply copy them into ~/.config/fabric/patterns.
`cp -a ~/.config/custom-fabric-patterns/* ~/.config/fabric/patterns/`
- Now you can run them with: `pbpaste | fabric -p your_custom_pattern`


# MOST IMPORTANT AND USED OPTIONS AND FEATURES

- **--pattern PATTERN, -p PATTERN**: Specifies the pattern (prompt) to use. Useful for applying specific AI prompts to your input.
  
- **--agents, -a**: Creates an AI agent to perform a task based on the input. Great for automating complex tasks with AI.
  
- **--stream, -s**: Streams results in real-time. Ideal for getting immediate feedback from AI operations.
  
- **--update, -u**: Updates patterns. Ensures you're using the latest AI prompts for your tasks.
  
- **--model MODEL, -m MODEL**: Selects the AI model to use. Allows customization of the AI backend for different tasks.
  
- **--setup**: Sets up your Fabric instance. Essential for first-time users to configure Fabric correctly.
  
- **--list, -l**: Lists available patterns. Helps users discover new AI prompts for various applications.
  
- **--context, -c**: Uses a Context file to add context to your pattern. Enhances the relevance of AI responses by providing additional background information.

# PATTERNS

## agility_story
Generates user stories and acceptance criteria for specified topics, focusing on Agile framework principles. This prompt specializes in translating topics into structured Agile documentation, specifically for user story and acceptance criteria creation. The expected output is a JSON-formatted document detailing the topic, user story, and acceptance criteria.

## ai
Summarizes and responds to questions with insightful bullet points. It involves creating a mental model of the question for deeper understanding. The output consists of 3-5 concise bullet points, each with a 10-word limit.

## analyze_answers
Evaluates the correctness of answers provided by learners to questions generated by a complementary quiz creation pattern. It aims to assess understanding of learning objectives and identify areas needing further study. The expected output is an analysis of the learner's answers, indicating their grasp of the subject matter.

## analyze_claims
Analyzes and rates the truth claims in input, providing evidence for and against, along with a balanced view. It separates truth claims from arguments, offering a nuanced analysis with ratings and labels for each claim. The output includes a summary, evidence, refutations, logical fallacies, ratings, labels, and an overall score and analysis.

## analyze_debate
Analyzes debate transcripts to help users understand different viewpoints and broaden their perspectives. It maps out claims, analyzes them neutrally, and rates the debate's insightfulness and emotionality. The output includes scores, participant emotionality, argument summaries with sources, and lists of agreements, disagreements, misunderstandings, learnings, and takeaways.

## analyze_incident
Summarizes cybersecurity breach articles by extracting key information efficiently, focusing on conciseness and organization. It avoids inferential conclusions, relying solely on the article's content for details like attack date, type, and impact. The output is a structured summary with specific details about the cybersecurity incident, including attack methods, vulnerabilities, and recommendations for prevention.

## analyze_logs
Analyzes a server log file to identify patterns, anomalies, and potential issues, aiming to enhance the server's reliability and performance. The process involves a detailed examination of log entries, assessment of operational reliability, and identification of recurring issues. Recommendations for improvements are provided based on data-driven analysis, excluding personal opinions and irrelevant information.

## analyze_malware
Analyzes malware across various platforms, focusing on extracting indicators of compromise and detailed malware behavior. This approach includes analyzing telemetry and community data to aid in malware detection and analysis. The expected output includes a summary of findings, potential indicators of compromise, Mitre Att&CK techniques, pivoting advice, detection strategies, suggested Yara rules, additional references, and technical recommendations.

## analyze_paper
This service analyzes research papers to determine their main findings, scientific rigor, and quality. It uniquely maps out claims, evaluates study design, and assesses conflicts of interest. The output includes a summary, author details, findings, study quality, and a final grade with explanations.

## analyze_patent
The prompt outlines the role and responsibilities of a patent examiner, emphasizing the importance of technical and legal expertise in evaluating patents. It details the steps for examining a patent, including identifying the technology field, problem addressed, solution, advantages, novelty, and inventive step, and summarizing the core idea and keywords. The expected output involves detailed analysis and documentation in specific sections without concern for length, using bullet points for clarity.

## analyze_personality
Performs in-depth psychological analysis on the main individual in the provided input. It involves identifying the primary person, deeply contemplating their language and responses, and comparing these to known human psychology principles. The output includes a concise psychological profile summary and detailed supporting points.

## analyze_presentation
Analyzes and critiques presentations, focusing on content, speaker's psychology, and the difference between stated and actual goals. It involves comparing intended messages to actual content, including self-references and entertainment attempts. The output includes scores and summaries for ideas, selflessness, and entertainment, plus an overall analysis.

## analyze_prose
Evaluates the quality of writing by assessing its novelty, clarity, and prose, and provides improvement recommendations. It uses a detailed approach to rate each aspect on a specific scale and ensures the overall rating reflects the lowest individual score. The expected output includes ratings and concise improvement tips.

## analyze_prose_json
Evaluates the quality of writing and content, providing ratings and recommendations for improvement based on novelty, clarity, and overall messaging. It assesses ideas for their freshness and originality, clarity of argument, and quality of prose, offering a structured approach to critique. The expected output is a JSON object summarizing these evaluations and recommendations.

## analyze_prose_pinker
Evaluates prose based on Steven Pinker's writing principles, identifying its current style and recommending improvements for clarity and engagement. It involves analyzing the text's adherence to Pinker's stylistic categories and avoiding common pitfalls in writing. The output includes a detailed analysis of the prose's style, strengths, weaknesses, and specific examples of both effective and ineffective writing elements.

## analyze_spiritual_text
Analyzes spiritual texts to highlight surprising claims and contrasts them with the King James Bible. This approach involves detailed comparison, providing examples from both texts to illustrate differences. The output consists of concise bullet points summarizing these findings.

## analyze_tech_impact
Analyzes the societal impact of technology projects by breaking down their intentions, outcomes, and broader implications, including ethical considerations. It employs a structured approach, detailing the project's objectives, technologies used, target audience, outcomes, societal impact, ethical considerations, and sustainability. The expected output includes summaries, lists, and analyses across specified sections.

## analyze_threat_report
The prompt instructs a super-intelligent cybersecurity expert to analyze and extract key insights from cybersecurity threat reports. It emphasizes identifying new, interesting, and surprising information, and organizing these findings into concise, categorized summaries. The expected output includes a one-sentence summary, trends, statistics, quotes, references, and recommendations from the report, all formatted in plain language and without repetition.

## analyze_threat_report_trends
Analyzes cybersecurity threat reports to identify up to 50 unique, surprising, and insightful trends. This process involves a deep, expert analysis to uncover new and interesting information. The expected output is a list of trends without repetition or formatting embellishments.

## answer_interview_question
Generates tailored responses to technical interview questions, aiming for a casual yet insightful tone. The AI draws from a technical knowledge base and professional experiences to construct responses that demonstrate depth and alternative perspectives. Outputs are structured first-person responses, including context, main explanation, alternative approach, and evidence-based conclusion.

## ask_secure_by_design_questions
Generates a comprehensive set of security-focused questions tailored to the fundamental design of a specific project. This process involves deep analysis and conceptualization of the project's components and their security needs. The output includes a summary and a detailed list of security questions organized by themes.

## capture_thinkers_work
Summarizes teachings and philosophies of notable individuals or philosophical schools, providing detailed templates on their backgrounds, ideas, and applications. It offers a structured approach to encapsulating complex thoughts into accessible summaries. The output includes encapsulations, background information, schools of thought, impactful ideas, primary teachings, works, quotes, applications, and life advice.

## check_agreement
The prompt outlines a process for analyzing contracts and agreements to identify potential issues or "gotchas." It involves summarizing the document, listing important aspects, categorizing issues by severity, and drafting responses for critical and important items. The expected output includes a concise summary, detailed callouts, categorized issues, and recommended responses in Markdown format.

## clean_text
Summarizes and corrects formatting issues in text without altering the content. It focuses on removing odd line breaks to improve readability. The expected output is a clean, well-formatted version of the original text.

## coding_master
Explains coding concepts or languages to beginners, using examples from reputable sources and illustrating points with formatted code. The approach emphasizes clarity and accessibility, incorporating examples from Codeacademy and NetworkChuck. Outputs include markdown-formatted code and structured lists of ideas, recommendations, habits, facts, and insights, adhering to specific word counts.

## compare_and_contrast
Compares and contrasts a list of items, focusing on their differences and similarities. The approach involves analyzing the items across various topics, organizing the findings into a markdown table. The expected output is a structured comparison in table format.

## create_5_sentence_summary
Generates concise summaries or answers at five decreasing levels of depth. It involves deep understanding and thoughtful analysis of the input. The output is a structured list capturing the essence in 5, 4, 3, 2, and 1 word(s).

## create_academic_paper
Produces high-quality, authoritative Latex academic papers with clear concept explanations. It focuses on logical layout and simplicity while maintaining a professional appearance. The expected output is LateX code formatted in a two-column layout with a header and footer.

## create_ai_jobs_analysis
Analyzes job reports to identify roles least and most vulnerable to automation, offering strategies for enhancing job security. It leverages historical insights to predict automation's impact on various job categories. The output includes a detailed analysis and recommendations for resilience against automation.

## create_aphorisms
Generates a list of 20 aphorisms related to the given topic(s), ensuring variety in their beginnings. It focuses on sourcing quotes from real individuals. The output includes each aphorism followed by the name of the person who said it.

## create_art_prompt
The prompt guides an expert artist in conceptualizing and instructing AI to create art that perfectly encapsulates a given concept. It emphasizes deep thought on the concept and its visual representation, aiming for compelling and interesting artwork. The expected output is a 100-word description that not only instructs the AI on what to create but also how the art should evoke feelings and suggest style through examples.

## create_better_frame
The essay explores the concept of framing as a way to construct and interpret reality through different lenses, emphasizing the power of perspective in shaping one's experience of the world. It highlights various dichotomies in perceptions around topics like AI, race/gender, success, personal identity, and control over life, illustrating how different frames can lead to vastly different outlooks and outcomes. The author argues for the importance of choosing positive frames to improve individual and collective realities, suggesting that changing frames can change outcomes and foster more positive social dynamics.

## create_coding_project
Generates wireframes and starter code for coding projects based on user ideas. It specifically caters to transforming ideas into actionable project outlines and code skeletons, including detailed steps and file structures. The output includes project summaries, structured directories, and initial code setups.

## create_command
Generates specific command lines for various penetration testing tools based on a brief description of the desired outcome. This approach leverages the tool's help documentation to ensure accuracy and relevance. The expected output is a precise command that aligns with the user's objectives for the tool.

## create_cyber_summary
The prompt instructs on creating a comprehensive summary of cybersecurity threats, vulnerabilities, incidents, and malware for a technical audience. It emphasizes deep understanding through repetitive analysis and visualization techniques. The expected output includes a concise summary and categorized lists of cybersecurity issues.

## create_git_diff_commit
This prompt provides instructions for using specific Git commands to manage code changes. It explains how to view differences since the last commit and display the current state of the repository. The expected output is a guide on executing these commands.

## create_idea_compass
Guides users in developing a structured exploration of ideas through a detailed template. It emphasizes clarity and organization by breaking down the process into specific steps, including defining, supporting, and contextualizing the idea. The expected output is a comprehensive summary with related ideas, evidence, and sources organized in a structured format.

## create_investigation_visualization
Creates detailed GraphViz visualizations to illustrate complex intelligence investigations and data insights. This approach involves extensive analysis, organizing information, and visual representation using shapes, colors, and labels for clarity. The output includes a comprehensive diagram and analytical conclusions with a certainty rating.

## create_keynote
The prompt guides in creating TED-quality keynote presentations from provided input, focusing on narrative flow and practical takeaways. It outlines steps for structuring the presentation into slides with concise bullet points, images, and speaker notes. The expected output includes a story flow, the final takeaway, and a detailed slide deck presentation.

## create_logo
Generates simple, minimalist company logos based on provided input, focusing on elegance and impact without text. The approach emphasizes super minimalist designs. The output is a prompt for an AI image generator to create a simple, vector graphic logo.

## create_markmap_visualization
Transforms complex ideas into visual formats using MarkMap syntax for easy understanding. This process involves simplifying concepts to ensure they can be effectively represented within the constraints of MarkMap. The output is a MarkMap syntax diagram that visually communicates the core ideas.

## create_mermaid_visualization
Transforms complex ideas into simplified Mermaid (Markdown) visual diagrams. This process involves creating detailed visualizations that can independently explain concepts using Mermaid syntax, focusing on clarity and comprehensibility. The expected output is a Mermaid syntax diagram accompanied by a concise visual explanation.

## create_micro_summary
Summarizes content into a Markdown formatted summary, focusing on brevity and clarity. It emphasizes creating concise, impactful points and takeaways. The output includes a one-sentence summary, main points, and key takeaways, each adhering to strict word limits.

## create_network_threat_landscape
Analyzes open ports and services from network scans to identify security risks and provide recommendations. This process involves a detailed examination of port and service statistics to uncover potential vulnerabilities. The expected output is a markdown formatted threat report with sections on description, risk, recommendations, a concise summary, trends, and quotes from the analysis.

## create_npc
Generates detailed NPCs for D&D 5th edition, incorporating a wide range of characteristics from background to appearance. It emphasizes creativity in developing a character's backstory, traits, and goals. The output is a comprehensive character profile suitable for gameplay.

## create_pattern
The AI assistant is designed to interpret and respond to LLM/AI prompts with structured outputs. It specializes in organizing and analyzing prompts to produce responses that adhere to specific instructions and formatting requirements. The assistant ensures accuracy and alignment with the intended outcomes through meticulous analysis.

## create_quiz
Generates questions for reviewing learning objectives based on provided subject and objectives. It requires defining the subject and learning objectives for accurate question generation. The output consists of questions aimed at helping students review key concepts.

## create_reading_plan
Designs a tailored three-phase reading plan based on user input, focusing on an author or specific guidance. It carefully selects books from various sources, including hidden gems, to enhance the user's knowledge on the topic. The output includes a concise plan summary and categorized reading lists with reasons for each selection.

## create_report_finding
The prompt instructs the creation of a detailed markdown security finding report, incorporating sections like Description, Risk, Recommendations, and others, based on a vulnerability title and explanation provided by the user. It emphasizes a structured, insightful approach to documenting cybersecurity vulnerabilities. The expected output is a comprehensive report with specific sections, focusing on clarity, insightfulness, and relevance to cybersecurity assessment.

## create_security_update
The prompt instructs on creating concise security updates for newsletters, focusing on cybersecurity developments, threats, advisories, and new vulnerabilities. It emphasizes brevity and relevance, requiring links to further information. The expected output includes structured sections with short descriptions and relevant details, aiming to inform readers about the latest security concerns efficiently.

## create_show_intro
Creates compelling short intros for podcasts, focusing on the most interesting aspects of the show. It involves listening to the entire show, identifying key topics, and highlighting them in a concise introduction. The output is a structured intro that teases the conversation's main points.

## create_stride_threat_model
The prompt instructs on creating a detailed threat model using the STRIDE per element methodology for a given system design document. It emphasizes understanding the system's assets, trust boundaries, and data flows to identify and prioritize potential threats. The expected output is a comprehensive table listing threats, their components, mitigation strategies, and risk assessments.

## create_summary
Summarizes content into a structured Markdown format, focusing on brevity and clarity. It emphasizes creating a concise summary, listing main points, and identifying key takeaways. The output is organized into specific sections for easy reference.

## create_threat_model
The prompt outlines a comprehensive approach to everyday threat modeling, emphasizing its application beyond technical defenses to include personal and physical security scenarios. It distinguishes between realistic and possible threats, advocating for a balanced approach to risk management that considers the value of what's being protected, the likelihood of threats, and the cost of controls. The expected output involves creating threat models for various scenarios, highlighting realistic defenses, and guiding individuals towards logical security decisions through structured analysis.

## create_threat_scenarios
The prompt seeks to identify and prioritize potential threats to a given system or situation, using a narrative-based, simple threat modeling approach. It emphasizes distinguishing between realistic and possible threats, focusing on those worth defending against. The expected output includes a list of prioritized threat scenarios, an analysis of the threat model, recommended controls, a narrative analysis, and a concise conclusion.

## create_upgrade_pack
Extracts and organizes insights on world models and task algorithms from provided content. It focuses on identifying and categorizing beliefs about the world and optimal task execution strategies. The output includes concise, actionable bullet points under relevant categories.

## create_video_chapters
Extracts and organizes the most engaging topics from a transcript with corresponding timestamps. This process involves a detailed review of the transcript to identify key moments and subjects. The output is a list of topics with their timestamps in a sequential format.

## create_visualization
Transforms complex ideas into simplified ASCII art visualizations. This approach focuses on distilling intricate concepts into visual forms that can be easily understood through ASCII art. The expected output is a detailed ASCII art representation accompanied by a concise visual explanation.

## explain_code
Analyzes and explains code, security tool outputs, or configuration texts, tailoring the explanation to the type of input. It uses specific sections to clarify the function, implications, or settings based on the input's nature. The expected output is a detailed explanation or answer in designated sections.

## explain_docs
The prompt instructs on transforming input about tool usage into improved, structured documentation. It emphasizes clarity and utility, breaking down the process into specific sections for a comprehensive guide. The expected output includes an overview, usage syntax, common use cases, and key features of the tool.

## explain_project
Summarizes project documentation into a concise, user and developer-focused summary, highlighting its purpose, problem addressed, approach, installation, usage, and examples. It simplifies complex information for easy understanding and application. The output includes a project overview, problem it addresses, approach to solving the problem, and practical steps for installation and usage.

## explain_terms
Produces a glossary of advanced terms found in specific content, including definitions and analogies. It focuses on explaining obscure or complex terms to aid understanding. The output is a list of terms with explanations and analogies in a structured Markdown format.

## extract_algorithm_update_recommendations
Analyzes input to provide concise recommendations for improving processes. It focuses on extracting actionable advice from content descriptions. The output consists of a bulleted list of up to three brief suggestions.

## extract_article_wisdom
Extracts key insights and valuable information from textual content, focusing on ideas, quotes, habits, and references. It aims to address the issue of information overload by providing a concise summary of the content's most meaningful aspects. The expected output includes summarized ideas, notable quotes, referenced materials, and habits worth adopting.

## extract_book_ideas
Summarizes a book's key content by extracting 50 to 100 of its most interesting ideas. The process involves a deep dive into the book's insights, prioritizing them by interest and insightfulness. The output is a concise list of bulleted ideas, limited to 20 words each.

## extract_book_recommendations
Summarizes a book's key content by extracting 50 to 100 of its most practical recommendations, prioritizing the most impactful advice. This process involves a thorough memory search to identify actionable insights. The output is formatted as an instructive, bullet-pointed list, limited to 20 words each.

## extract_business_ideas
The prompt outlines a process for identifying and elaborating on innovative business ideas. It focuses on extracting top business concepts from provided content and then refining the best ten by exploring adjacent possibilities. The expected output includes two sections: a list of extracted ideas and a detailed elaboration on the top ten ideas, ensuring uniqueness and differentiation.

## extract_extraordinary_claims
Identifies and lists extraordinary claims from conversations, focusing on those rejected by the scientific community or based on misinformation. The process involves deep analysis to pinpoint statements that defy accepted scientific truths, such as denying evolution or the moon landing. The output is a detailed list of quotes, ranging from 50 to 100, showcasing these claims.

## extract_ideas
Extracts and condenses insightful ideas from text into 15-word bullet points focusing on life's purpose and human progress. This process emphasizes capturing unique insights on specified themes. The output consists of a list of concise, thought-provoking ideas.

## extract_insights
Extracts and condenses complex insights from text on profound topics into 15-word bullet points. This process emphasizes the extraction of nuanced, powerful ideas related to human and technological advancement. The expected output is a concise list of abstracted, insightful bullets.

## extract_main_idea
Extracts and highlights the most crucial or intriguing idea from any given content. This prompt emphasizes a methodical approach to identify and articulate the essence of the input. The expected output includes a concise main idea and a recommendation based on that idea.

## extract_patterns
The prompt guides in identifying and analyzing recurring, surprising, or insightful patterns from a collection of ideas, data, or observations. It emphasizes extracting the most notable patterns based on their frequency and significance, and then documenting the process of discovery and analysis. The expected output includes a detailed summary of patterns, an explanation of their selection and significance, and actionable advice for startup builders based on these insights.

## extract_poc
Analyzes security or bug bounty reports to extract and provide proof of concept URLs for validating vulnerabilities. It specializes in identifying actionable URLs and commands from the reports, ensuring direct verification of reported vulnerabilities. The output includes the URL with a specific command to execute it, like using curl or python.

## extract_predictions
Extracts and organizes predictions from content into a structured format. It focuses on identifying specific predictions, their timelines, confidence levels, and verification methods. The expected output includes a bulleted list and a detailed table of these predictions.

## extract_questions
Extracts questions from content and analyzes their effectiveness in eliciting high-quality responses. It focuses on identifying the elements that make these questions particularly insightful. The expected output includes a list of questions, an analysis of their strengths, and recommendations for interviewers.

## extract_recommendations
Extracts and condenses recommendations from content into a concise list. This process involves identifying both explicit and implicit advice within the given material. The output is a bulleted list of up to 20 brief recommendations.

## extract_references
Extracts references to various forms of cultural and educational content from provided text. This process involves identifying and listing references to art, literature, and academic papers concisely. The expected output is a bulleted list of up to 20 references, each summarized in no more than 15 words.

## extract_song_meaning
Analyzes and interprets the meaning of songs based on extensive research and lyric examination. This process involves deep analysis of the artist's background, song context, and lyrics to deduce the song's essence. Outputs include a summary sentence, detailed meaning in bullet points, and evidence supporting the interpretation.

## extract_sponsors
Identifies and distinguishes between official and potential sponsors from transcripts. This process involves analyzing content to separate actual sponsors from merely mentioned companies. The output lists official sponsors and potential sponsors based on their mention in the content.

## extract_videoid
Extracts video IDs from URLs for use in other applications. It meticulously analyzes the URL to isolate the video ID. The output is solely the video ID, with no additional information or errors included.

## extract_wisdom
Extracts key insights, ideas, quotes, habits, and references from textual content to address the issue of information overload and the challenge of retaining knowledge. It uniquely filters and condenses valuable information from various texts, making it easier for users to decide if the content warrants a deeper review or to use as a note-taking alternative. The output includes summarized ideas, notable quotes, relevant habits, and useful references, all aimed at enhancing understanding and retention.

## extract_wisdom_agents
This prompt outlines a complex process for extracting insights from text content, focusing on themes like the meaning of life and technology's impact on humanity. It involves creating teams of AI agents with diverse expertise to analyze the content and produce summaries, ideas, insights, quotes, habits, facts, references, and recommendations. The expected output includes structured sections filled with concise, insightful entries derived from the input material.

## extract_wisdom_dm
Extracts and synthesizes valuable content from input text, focusing on insights related to life's purpose and human advancement. It employs a structured approach to distill surprising ideas, insights, quotes, habits, facts, and recommendations from the content. The output includes summaries, ideas, insights, and other categorized information for deep understanding and practical application.

## extract_wisdom_nometa
This prompt guides the extraction and organization of insightful content from text, focusing on life's purpose, human flourishing, and technology's impact. It emphasizes identifying and summarizing surprising ideas, refined insights, practical habits, notable quotes, valid facts, and useful recommendations related to these themes. The expected output includes structured sections for summaries, ideas, insights, quotes, habits, facts, recommendations, and references, each with specific content and formatting requirements.

## find_hidden_message
Analyzes political messages to reveal overt and hidden intentions. It employs knowledge of politics, propaganda, and psychology to dissect content, focusing on recent political debates. The output includes overt messages, hidden cynical messages, supporting arguments, desired audience actions, and analyses from cynical to favorable.

## find_logical_fallacies
Identifies and categorizes various fallacies in arguments or texts. This prompt focuses on recognizing invalid or faulty reasoning across a wide range of fallacies, from formal to informal types. The expected output is a list of identified fallacies with brief explanations.

## get_wow_per_minute
Evaluates the density of wow-factor in content by analyzing its surprise, novelty, insight, value, and wisdom. This process involves a detailed and varied consumption of the content to assess its potential to engage and enrich viewers. The expected output is a JSON report detailing scores and explanations for each wow-factor component and overall wow-factor per minute.

## get_youtube_rss
Generates RSS URLs for YouTube channels based on given channel IDs or URLs. It extracts the channel ID from the input and constructs the corresponding RSS URL. The output is solely the RSS URL.

## improve_academic_writing
This prompt aims to enhance the quality of text for academic purposes. It focuses on refining grammatical errors, improving clarity and coherence, and adopting an academic tone while ensuring ease of understanding. The expected output is a professionally refined text with a list of applied corrections.

## improve_prompt
This service enhances LLM/AI prompts by applying expert prompt writing techniques to achieve better results. It leverages strategies like clear instructions, persona adoption, and reference text provision to refine prompts. The output is an improved version of the original prompt, optimized for clarity and effectiveness.

## improve_report_finding
The prompt instructs the creation of an improved security finding report from a penetration test, detailing the finding, risk, recommendations, references, a concise summary, and insightful quotes, all formatted in markdown without using markdown syntax or special formatting. It emphasizes a detailed, insightful approach to presenting cybersecurity issues and solutions. The output should be comprehensive, covering various sections including title, description, risk, recommendations, references, and quotes, aiming for clarity and depth in reporting.

## improve_writing
This prompt aims to refine input text for enhanced clarity, coherence, grammar, and style. It involves analyzing the text for errors and inconsistencies, then applying corrections while preserving the original meaning. The expected output is a grammatically correct and stylistically improved version of the text.

## label_and_rate
Evaluates and categorizes content based on its relevance to specific human-centric themes, then assigns a tiered rating and a numerical quality score. It uses a predefined set of labels for categorization and assesses content based on idea quantity and thematic alignment. The expected output is a structured JSON object detailing the content summary, labels, rating, and quality score with explanations.

## official_pattern_template
The prompt outlines a complex process for diagnosing and addressing psychological issues based on a person's background and behaviors. It involves deep analysis of the individual's history, identifying potential mental health issues, and suggesting corrective actions. The expected output includes summaries of past events, possible psychological issues, their impact on behavior, and recommendations for improvement.

## philocapsulate
Summarizes teachings of philosophers or philosophies, providing detailed templates on their background, encapsulated philosophy, school, teachings, works, quotes, application, and life advice. It differentiates between individual philosophers and philosophies with tailored templates for each. The output includes structured information for educational or analytical purposes.

## provide_guidance
Provides comprehensive psychological advice tailored to the individual's specific question and context. This approach delves into the person's past, traumas, and life goals to offer targeted feedback and recommendations. The expected output includes a concise analysis, detailed scientific rationale, actionable recommendations, Esther Perel's perspective, self-reflection prompts, possible clinical diagnoses, and a summary, all aimed at fostering self-awareness and positive change.

## rate_ai_response
Evaluates the quality of AI responses against the benchmark of human experts, assigning a letter grade and score. It involves deep analysis of both the instructions given to the AI and its output, comparing these to the potential performance of the world's best human expert. The process culminates in a detailed justification for the assigned grade, highlighting specific strengths and weaknesses of the AI's response.

## rate_ai_result
Evaluates the quality of AI-generated content based on construction, quality, and spirit. The process involves analyzing AI outputs against criteria set by experts and a high-IQ AI panel. The expected output is a final score out of 100, with deductions detailed for each category.

## rate_content
The prompt outlines a process for evaluating content by labeling it with relevant single-word descriptors, rating its quality based on idea quantity and thematic alignment, and scoring it on a scale from 1 to 100. It emphasizes the importance of matching content with specific themes related to human meaning and the future of AI, among others. The expected output includes a list of labels, a tiered rating with an explanation, and an overall quality score with justification.

## rate_value
This prompt seeks to acknowledge the collaborative effort behind its creation, inspired by notable figures in information theory and viral content creation. It highlights the fusion of theoretical foundations and modern digital strategies. The output is an attribution of credit.

## raw_query
The prompt instructs the AI to produce the best possible output by thoroughly analyzing and understanding the input. It emphasizes deep contemplation of the input's meaning and the sender's intentions. The expected output is an optimal response tailored to the inferred desires of the input provider.

## recommend_artists
Recommends a personalized festival schedule featuring artists similar to the user's preferences in EDM genres and artists. The recommendation process involves analyzing the user's favorite styles and artists, then selecting similar artists and explaining the choices. The output is a detailed schedule organized by day, set time, stage, and artist, optimized for the user's enjoyment.

## show_fabric_options_markmap
Create a visual representation of the functionalities provided by the Fabric project, focusing on augmenting human capabilities with AI. The approach involves breaking down the project's capabilities into categories like summarization, analysis, and more, with specific patterns branching from these categories. The expected output is comprehensive Markmap code detailing this functionality map.

## suggest
Analyzes user input to suggest appropriate fabric commands or patterns, enhancing the tool's functionality. It involves understanding specific needs, determining suitable commands, and providing clear, user-friendly suggestions. The output includes command suggestions, explanations, and instructions for new patterns.

## summarize
Summarizes content into a structured Markdown format, focusing on brevity and clarity. It extracts and lists the most crucial points and takeaways. The output includes a one-sentence summary, main points, and key takeaways, adhering to specified word limits.

## summarize_debate
Analyzes debates to identify and summarize the primary disagreements, arguments, and evidence that could change participants' minds. It breaks down complex discussions into concise summaries and evaluates argument strength, predicting outcomes. The output includes structured summaries and analyses of each party's position and evidence.

## summarize_git_changes
Summarizes major changes and upgrades in a GitHub project over the past week. It involves identifying key updates, then crafting a concise, enthusiastic summary and detailed bullet points highlighting these changes. The output includes a 20-word introduction and excitedly written update bullets.

## summarize_git_diff
Analyzes Git diffs to summarize major changes and upgrades. It emphasizes creating concise bullet points for feature changes and updates, tailored to the extent of modifications. The expected output includes a 100-character intro sentence using conventional commits format.

## summarize_micro
Summarizes content into a structured Markdown format. This prompt focuses on concise, bullet-pointed summaries and takeaways. The output includes a one-sentence summary and lists of main points and takeaways.

## summarize_newsletter
Extracts and organizes key content from newsletters, focusing on the most meaningful, interesting, and useful information. It uniquely parses the entire newsletter to provide concise summaries, lists of content, opinions, tools, companies, and follow-up actions. The output includes sections for a brief summary, detailed content points, author opinions, mentioned tools and companies, and recommended follow-ups in a structured Markdown format.

## summarize_paper
Summarizes academic papers by extracting key sections such as title, authors, main goals, and more from the provided text. It employs a structured approach to highlight the paper's core aspects including technical methodology, distinctive features, and experimental outcomes. The output is a detailed summary covering various dimensions of the research.

## summarize_pattern
This prompt instructs on summarizing AI chat prompts into concise paragraphs. It emphasizes using active voice and present tense for clarity. The expected output is a structured summary highlighting the prompt's purpose, approach, and anticipated results.

## summarize_pull-requests
Summarizes pull requests for a coding project, focusing on the types of changes made. It involves creating a summary and a detailed list of main PRs, rewritten for clarity. The output includes a concise overview and specific examples of pull requests.

## summarize_rpg_session
This prompt outlines the process for summarizing in-person role-playing game sessions, focusing on key events, combat details, character development, and worldbuilding. It emphasizes capturing the essence of the session in a structured format, including summaries, lists, and descriptions to encapsulate the narrative and gameplay dynamics. The expected output includes a comprehensive overview of the session's storyline, character interactions, and significant moments, tailored for both players and observers.

## to_flashcards
Creates Anki cards from texts following specific principles to ensure simplicity, optimized wording, and no reliance on external context. This approach aims to enhance learning efficiency and comprehension without requiring prior knowledge of the text. The expected output is a set of questions and answers formatted as a CSV table.

## tweet
Guides users on crafting engaging tweets with emojis, focusing on Twitter's basics and content creation strategies. It emphasizes understanding Twitter, identifying the target audience, and using emojis effectively. The expected output is a comprehensive guide for creating appealing tweets with emojis.

## write_essay
The task is to write an essay in the style of Paul Graham, focusing on the essence and approach of writing concise, clear, and illuminating essays on any given topic.

## write_micro_essay
The task is to write an essay in the style of Paul Graham, focusing on the essence of simplicity in conveying complex ideas.

## write_nuclei_template_rule
The purpose of this prompt is to guide the creation of Nuclei templates for cybersecurity applications, focusing on generating precise and efficient scanning templates for various protocols like HTTP, DNS, TCP, and more. It emphasizes the importance of incorporating elements such as matchers, extractors, and conditions to tailor the templates for detecting specific vulnerabilities or configurations. The expected output is a well-structured YAML Nuclei template that adheres to best practices in template creation, including handling dynamic data extraction, utilizing complex matchers, and ensuring accurate vulnerability detection with minimal false positives.

## write_pull-request
The prompt instructs on drafting a detailed pull request (PR) description based on the output of a `git diff` command, focusing on identifying and explaining code changes. It emphasizes analyzing changes, understanding their purpose, and detailing their impact on the project. The expected output is a structured PR description in markdown, covering a summary of changes, reasons, impacts, and testing plans in clear language.

## write_semgrep_rule
The prompt requests the creation of a Semgrep rule to detect a specific vulnerability pattern in code, based on provided context and examples. It emphasizes the importance of crafting a rule that is general enough to catch any instance of the described vulnerability, rather than being overly specific to the given examples. The expected output is a well-structured Semgrep rule that aligns with the syntax and guidelines detailed in the context, capable of identifying the vulnerability across different scenarios.

