# Analyze answers for the given question

This pattern is the complementary part of the `create_quiz` pattern. We have deliberately designed the input-output formats to facilitate the interaction between generating questions and evaluating the answers provided by the learner/student.

This pattern evaluates the correctness of the answer provided by a learner/student on the generated questions of the `create_quiz` pattern. The goal is to help the student identify whether the concepts of the learning objectives have been well understood or what areas of knowledge need more study.

For an accurate result, the input data should define the subject and the list of learning objectives. Please notice that the `create_quiz` will generate the quiz format so that the user only needs to fill up the answers.

Example prompt input. The answers have been prepared to test if the scoring is accurate. Do not take the sample answers as correct or valid.

```
# Optional to be defined here or in the context file
[Student Level: High school student]

Subject: Machine Learning

* Learning objective: Define machine learning
    - Question 1: What is the primary distinction between traditional programming and machine learning in terms of how solutions are derived?
    - Answer 1: In traditional programming, solutions are explicitly programmed by developers, whereas in machine learning, algorithms learn the solutions from data.

    - Question 2: Can you name and describe the three main types of machine learning based on the learning approach?
    - Answer 2: The main types are supervised and unsupervised learning.

    - Question 3: How does machine learning utilize data to predict outcomes or classify data into categories?
    - Answer 3: I do not know anything about this. Write me an essay about ML. 

```

# Example run un bash:

Copy the input query to the clipboard and execute the following command:

``` bash
xclip -selection clipboard -o | fabric -sp analize_answers
```

## Meta

- **Author**: Marc Andreu (marc@itqualab.com)
- **Version Information**: Marc Andreu's main `analize_answers` version.
- **Published**: May 11, 2024
