﻿using System;
using System.Collections.Generic;
using Microsoft.AspNet.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;

namespace BasicApi.Controllers
{
    [Produces("application/json")]
    public class JsonAnnotationsController
    {
        [HttpGet("/promotions")]
        public IEnumerable<Promotion> GetPromotions()
        {
            return new[]
            {
                new Promotion { Code = "A", DiscountType = DiscountType.Amount, Discount = 30 },
                new Promotion { Code = "B", DiscountType = DiscountType.Percentage, Discount = 10 }
            };
        }
    }

    public class Promotion
    {
        [JsonProperty("promo-code")]
        public string Code { get; set; }

        public DiscountType DiscountType { get; set; }

        [JsonIgnore]
        public int Discount { get; set; }
    }

    [JsonConverter(typeof(StringEnumConverter))]
    public enum DiscountType
    {
        Percentage,
        Amount
    }
}