---
title: Senior Site Reliability Engineer
---

import Apply from '../../components/apply/apply.tsx'

# Senior Site Reliability Engineer

<div className="pill"> Full-Time, San Francisco Bay Area & Remote</div>

BuildBuddy was founded to make developers more productive. Today we're solving a small piece of this problem with an open-core remote build execution platform for Bazel - but our ambitions are much larger. Our mission is to take the world class engineering tools that are only available to employees of large companies and make them available to everyone.

We're looking for a Senior SRE to help us fulfill this mission. You'll scale our stack (Golang, Typescript, React, Bazel, Protobuf) on GCP to support hundreds of customers and millions of QPS. From driving large technical projects to understanding the nitty gritty details of the Bazel build event protocol - you'll have your fingerprints all over our open-source and internal codebases.

This is a unique opportunity to shape the future of how engineers build and test software.

## You will

- Plan for growth, and scale our platform and infrastructure
- Work with the team to identify opportunities and implement solutions that improve our reliability and resiliency
- Build solutions that improve the developer experience and product overall
- Debug and fix complex production issues across the stack

## We're looking for someone who

- Has a strong understanding of reliability practices, distributed systems, and cloud native architectures
- Has extensive Unix/Linux experience and has successfully scaled systems before
- Can manage priorities and make progress on complex problems without supervision
- Works well with others and is open to feedback as well as mentoring others and helping the team grow
- We don't expect that you're an expert in all areas. Above all, we're looking for people who are passionate and fun to work with. You're encouraged to apply even if your experience doesn't exactly match the job description. We welcome diverse perspectives and people who aren't afraid to challenge the status quo.

## Who you'll work with

- Tyler Williams - GitHub: @tylerwilliams, Twitter: @tylerbw
- Siggi Simonarson - GitHub: @siggisim, Twitter: @siggi
- Brandon Duffany - GitHub: @bduffany, Twitter: @brandon_duffany
- Vadim Berezniker - GitHub: @vadimberezniker
- And the rest of the **[team here](/team)**

## What's it like to work at BuildBuddy?

- We're a small team of builders that value getting things done over busywork
- We value curiosity and encourage employees to contribute to open source projects
- We aim to create a warm & welcoming work environment
- We treat our coworkers well, and offer platinum health benefits at no cost to employees
- We offer generous equity & comp packages, and reward those that help the company grow
- We work remotely, but are loosely based out of the San Francisco Bay Area
- We get together in-person about twice a year for a company-wide offsite

## Apply now

<Apply />
