---
id: cache-encryption-keys
title: Customer-managed Encryption Keys
sidebar_label: Customer-managed Encryption Keys
---

BuildBuddy allows you to provide a managed key to be used to encrypt cache artifacts at rest.

BuildBuddy currently supports encryption keys stored in Google Cloud Platform (GCP) KMS or Amazon Web Services (AWS) KMS.

To get started, open the organization settings page and navigate to the "Encryption keys" tab.

Only organization administrators may change the encryption settings.

## Key permissions

### Google Cloud Platform (GCP)

BuildBuddy infrastructure will access the supplied key using the `kms-prod@flame-build.iam.gserviceaccount.com`
service account. You must grant this service account permissions to use the supplied key. At a minimum, the service
account must be granted both of the following IAM permissions:

```
cloudkms.cryptoKeyVersions.useToEncrypt
cloudkms.cryptoKeyVersions.useToDecrypt
```

These permissions are available as part of the `Cloud KMS CryptoKey Encrypter/Decrypter` predefined IAM role.

### Amazon Web Services (AWS)

BuildBuddy infrastructure will access the supplied key using a BuildBuddy owned user in account `561871016185`. You must
grant this AWS account access to the supplied key.

## Considerations

- When enabling or disabling customer-managed encryption keys, it may take up to 10 minutes for the change to propagate
  through the system. If there are active builds during this window, they may experience "not found" errors while the
  change propagates.

- Artifacts written prior to enabling this feature will not be retroactively encrypted using the new key, but will
  become effectively inaccessible and will be evicted from the cache as part of the regular cache lifecycle.

- The key used for encryption and decryption may be cached in memory by the BuildBuddy infrastructure for up to 10
  minutes for performance reasons.

- The customer-managed key may be rotated. During rotation, the old key material must remain accessible for at least 24
  hours.

## Implementation details

### Key management

When the feature is enabled, two internal 256-bit keys are generated by BuildBuddy. The first being the "Customer Key"
and the second being the "BuildBuddy Key". Before being stored within BuildBuddy systems, the Customer Key is encrypted
using the customer supplied key and the BuildBuddy Key is encrypted using a BuildBuddy managed key.

To perform encryption or decryption, a third 256-bit key ("Derived Key") is obtained by decrypting the Customer Key and
the BuildBuddy key and feeding their concatenation into HKDF-Expand using a SHA256 hash.

During operation, the Derived Key may be cached in memory by BuildBuddy systems for up to 10 minutes for performance
reasons.

If the feature is disabled, the Customer Key and BuildBuddy Key material are immediately deleted. Previously encrypted
data will no longer be decryptable after 10 minutes at most, due to temporary in-memory key caching.

### Content encryption and decryption

The Derived Key is used to encrypt and decrypt content using the XChaCha20-Poly1305 algorithm.
