---
title: Software Engineer
---

import Apply from '../../components/apply/apply.tsx'

# Software Engineer

<div className="pill"> Full-Time, San Francisco Bay Area & Remote</div>

BuildBuddy was founded to make developers more productive. Today we're solving a small piece of this problem with an open-core remote build execution platform for Bazel - but our ambitions are much larger. Our mission is to take the world class engineering tools that are only available to employees of large companies and make them available to everyone.

We're looking for generalist software engineers to help us fulfill this mission. You'll work across our stack (Golang, Typescript, React, Bazel, Protobuf) to build the next generation of engineering tools. From driving large technical projects to understanding the nitty gritty details of the Bazel build event protocol - you'll have your fingerprints all over our open-source and internal codebases.

This is a unique opportunity to shape the future of how engineers build and test software.

## You will

- Design, build, test, deploy, and maintain reliable software
- Debug complex production issues across the stack
- Plan for the growth of our platform and infrastructure
- Build a great customer experience for our users (other engineers!)

## We're looking for someone who

- Is comfortable with ambiguity and working outside of their comfort zone
- Can manage priorities well when there's a lot to be done
- Holds yourself and others to a high bar when working with production
- Is able to write high quality code in a programming language (e.g. Golang, Typescript).

## Who you'll work with

- Tyler Williams - GitHub: @tylerwilliams, Twitter: @tylerbw
- Siggi Simonarson - GitHub: @siggisim, Twitter: @siggi
- Brandon Duffany - GitHub: @bduffany, Twitter: @brandon_duffany
- Vadim Berezniker - GitHub: @vadimberezniker
- And the rest of the **[team here](/team)**

## What's it like to work at BuildBuddy?

- We're a small team of builders that value getting things done over busywork
- We value curiosity and encourage employees to contribute to open source projects
- We aim to create a warm & welcoming work environment
- We treat our coworkers well, and offer platinum health benefits at no cost to employees
- We offer generous equity & comp packages, and reward those that help the company grow
- We work remotely, but are loosely based out of the San Francisco Bay Area
- We get together in-person about twice a year for a company-wide offsite

## Apply now

<Apply />
