/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.mapreduce.HCatBaseOutputFormat;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.InternalUtil;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hcatalog.mapreduce.RecordWriterContainer;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;

class FileRecordWriterContainer
extends RecordWriterContainer {
    private final HCatStorageHandler storageHandler;
    private final SerDe serDe;
    private final ObjectInspector objectInspector;
    private boolean dynamicPartitioningUsed = false;
    private final Map<String, RecordWriter<? super WritableComparable<?>, ? super Writable>> baseDynamicWriters;
    private final Map<String, SerDe> baseDynamicSerDe;
    private final Map<String, org.apache.hadoop.mapred.OutputCommitter> baseDynamicCommitters;
    private final Map<String, org.apache.hadoop.mapred.TaskAttemptContext> dynamicContexts;
    private final Map<String, ObjectInspector> dynamicObjectInspectors;
    private Map<String, OutputJobInfo> dynamicOutputJobInfo;
    private final List<Integer> partColsToDel;
    private final List<Integer> dynamicPartCols;
    private int maxDynamicPartitions;
    private OutputJobInfo jobInfo;
    private TaskAttemptContext context;

    public FileRecordWriterContainer(RecordWriter<? super WritableComparable<?>, ? super Writable> baseWriter, TaskAttemptContext context) throws IOException, InterruptedException {
        super(context, baseWriter);
        this.context = context;
        this.jobInfo = HCatOutputFormat.getJobInfo((JobContext)context);
        this.storageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), this.jobInfo.getTableInfo().getStorerInfo());
        this.serDe = (SerDe)ReflectionUtils.newInstance((Class)this.storageHandler.getSerDeClass(), (Configuration)context.getConfiguration());
        this.objectInspector = InternalUtil.createStructObjectInspector(this.jobInfo.getOutputSchema());
        try {
            InternalUtil.initializeOutputSerDe(this.serDe, context.getConfiguration(), this.jobInfo);
        }
        catch (SerDeException e) {
            throw new IOException("Failed to inialize SerDe", e);
        }
        this.partColsToDel = this.jobInfo.getPosOfPartCols();
        this.dynamicPartitioningUsed = this.jobInfo.isDynamicPartitioningUsed();
        this.dynamicPartCols = this.jobInfo.getPosOfDynPartCols();
        this.maxDynamicPartitions = this.jobInfo.getMaxDynamicPartitions();
        if (this.partColsToDel == null || this.dynamicPartitioningUsed && this.dynamicPartCols == null) {
            throw new HCatException("It seems that setSchema() is not called on HCatOutputFormat. Please make sure that method is called.");
        }
        if (!this.dynamicPartitioningUsed) {
            this.baseDynamicSerDe = null;
            this.baseDynamicWriters = null;
            this.baseDynamicCommitters = null;
            this.dynamicContexts = null;
            this.dynamicObjectInspectors = null;
            this.dynamicOutputJobInfo = null;
        } else {
            this.baseDynamicSerDe = new HashMap<String, SerDe>();
            this.baseDynamicWriters = new HashMap();
            this.baseDynamicCommitters = new HashMap<String, org.apache.hadoop.mapred.OutputCommitter>();
            this.dynamicContexts = new HashMap<String, org.apache.hadoop.mapred.TaskAttemptContext>();
            this.dynamicObjectInspectors = new HashMap<String, ObjectInspector>();
            this.dynamicOutputJobInfo = new HashMap<String, OutputJobInfo>();
        }
    }

    public HCatStorageHandler getStorageHandler() {
        return this.storageHandler;
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        Reporter reporter = InternalUtil.createReporter(context);
        if (this.dynamicPartitioningUsed) {
            for (RecordWriter<? super WritableComparable<?>, ? super Writable> recordWriter : this.baseDynamicWriters.values()) {
                recordWriter.close(reporter);
            }
            for (Map.Entry entry : this.baseDynamicCommitters.entrySet()) {
                org.apache.hadoop.mapred.TaskAttemptContext currContext = this.dynamicContexts.get(entry.getKey());
                OutputCommitter baseOutputCommitter = (OutputCommitter)entry.getValue();
                if (!baseOutputCommitter.needsTaskCommit((TaskAttemptContext)currContext)) continue;
                baseOutputCommitter.commitTask((TaskAttemptContext)currContext);
            }
        } else {
            this.getBaseRecordWriter().close(reporter);
        }
    }

    public void write(WritableComparable<?> key, HCatRecord value) throws IOException, InterruptedException {
        ObjectInspector localObjectInspector;
        SerDe localSerDe;
        RecordWriter<? super WritableComparable<?>, ? super Writable> localWriter;
        OutputJobInfo localJobInfo = null;
        if (this.dynamicPartitioningUsed) {
            ArrayList<String> dynamicPartValues = new ArrayList<String>();
            for (Integer colToAppend : this.dynamicPartCols) {
                dynamicPartValues.add(value.get(colToAppend).toString());
            }
            String dynKey = ((Object)dynamicPartValues).toString();
            if (!this.baseDynamicWriters.containsKey(dynKey)) {
                if (this.maxDynamicPartitions != -1 && this.baseDynamicWriters.size() > this.maxDynamicPartitions) {
                    throw new HCatException(ErrorType.ERROR_TOO_MANY_DYNAMIC_PTNS, "Number of dynamic partitions being created exceeds configured max allowable partitions[" + this.maxDynamicPartitions + "], increase parameter [" + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + "] if needed.");
                }
                org.apache.hadoop.mapred.TaskAttemptContext currTaskContext = HCatMapRedUtil.createTaskAttemptContext(this.context);
                this.configureDynamicStorageHandler((JobContext)currTaskContext, dynamicPartValues);
                localJobInfo = HCatBaseOutputFormat.getJobInfo((JobContext)currTaskContext);
                SerDe currSerDe = (SerDe)ReflectionUtils.newInstance((Class)this.storageHandler.getSerDeClass(), (Configuration)currTaskContext.getJobConf());
                try {
                    InternalUtil.initializeOutputSerDe(currSerDe, currTaskContext.getConfiguration(), localJobInfo);
                }
                catch (SerDeException e) {
                    throw new IOException("Failed to initialize SerDe", e);
                }
                OutputFormat baseOF = (OutputFormat)ReflectionUtils.newInstance((Class)this.storageHandler.getOutputFormatClass(), (Configuration)currTaskContext.getJobConf());
                org.apache.hadoop.mapred.OutputCommitter baseOutputCommitter = currTaskContext.getJobConf().getOutputCommitter();
                org.apache.hadoop.mapred.JobContext currJobContext = HCatMapRedUtil.createJobContext((JobContext)currTaskContext);
                baseOutputCommitter.setupJob(currJobContext);
                currTaskContext = HCatMapRedUtil.createTaskAttemptContext(currJobContext.getJobConf(), currTaskContext.getTaskAttemptID(), currTaskContext.getProgressible());
                currTaskContext.getConfiguration().set("mapred.work.output.dir", new FileOutputCommitter(new Path(localJobInfo.getLocation()), (TaskAttemptContext)currTaskContext).getWorkPath().toString());
                baseOutputCommitter.setupTask(currTaskContext);
                Path parentDir = new Path(currTaskContext.getConfiguration().get("mapred.work.output.dir"));
                Path childPath = new Path(parentDir, FileOutputFormat.getUniqueFile((TaskAttemptContext)currTaskContext, (String)"part", (String)""));
                RecordWriter baseRecordWriter = baseOF.getRecordWriter(parentDir.getFileSystem(currTaskContext.getConfiguration()), currTaskContext.getJobConf(), childPath.toString(), (Progressable)InternalUtil.createReporter((TaskAttemptContext)currTaskContext));
                this.baseDynamicWriters.put(dynKey, baseRecordWriter);
                this.baseDynamicSerDe.put(dynKey, currSerDe);
                this.baseDynamicCommitters.put(dynKey, baseOutputCommitter);
                this.dynamicContexts.put(dynKey, currTaskContext);
                this.dynamicObjectInspectors.put(dynKey, (ObjectInspector)InternalUtil.createStructObjectInspector(this.jobInfo.getOutputSchema()));
                this.dynamicOutputJobInfo.put(dynKey, HCatOutputFormat.getJobInfo((JobContext)this.dynamicContexts.get(dynKey)));
            }
            localJobInfo = this.dynamicOutputJobInfo.get(dynKey);
            localWriter = this.baseDynamicWriters.get(dynKey);
            localSerDe = this.baseDynamicSerDe.get(dynKey);
            localObjectInspector = this.dynamicObjectInspectors.get(dynKey);
        } else {
            localJobInfo = this.jobInfo;
            localWriter = this.getBaseRecordWriter();
            localSerDe = this.serDe;
            localObjectInspector = this.objectInspector;
        }
        for (Integer colToDel : this.partColsToDel) {
            value.remove(colToDel);
        }
        try {
            localWriter.write((Object)NullWritable.get(), (Object)localSerDe.serialize(value.getAll(), localObjectInspector));
        }
        catch (SerDeException e) {
            throw new IOException("Failed to serialize object", e);
        }
    }

    protected void configureDynamicStorageHandler(JobContext context, List<String> dynamicPartVals) throws IOException {
        HCatOutputFormat.configureOutputStorageHandler(context, dynamicPartVals);
    }
}

