/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public class SpecialCases {
    private static final Log LOG = LogFactory.getLog(SpecialCases.class);

    public static void addSpecialCasesParametersToOutputJobProperties(Map<String, String> jobProperties, OutputJobInfo jobInfo, Class<? extends OutputFormat> ofclass) {
        if (ofclass == RCFileOutputFormat.class) {
            jobProperties.put("hive.io.rcfile.column.number.conf", Integer.toOctalString(jobInfo.getOutputSchema().getFields().size()));
        } else if (ofclass == OrcOutputFormat.class) {
            Map tableProps = jobInfo.getTableInfo().getTable().getParameters();
            for (OrcFile.OrcTableProperties property : OrcFile.OrcTableProperties.values()) {
                String propName = property.getPropName();
                if (!tableProps.containsKey(propName)) continue;
                jobProperties.put(propName, (String)tableProps.get(propName));
            }
        }
    }
}

