/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.hcatalog.mapreduce.FileOutputCommitterContainer;
import org.apache.hcatalog.mapreduce.FileRecordWriterContainer;
import org.apache.hcatalog.mapreduce.HCatBaseOutputFormat;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.InternalUtil;
import org.apache.hcatalog.mapreduce.OutputFormatContainer;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hcatalog.mapreduce.StorerInfo;
import org.apache.thrift.TException;

class FileOutputFormatContainer
extends OutputFormatContainer {
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public FileOutputFormatContainer(OutputFormat<? super WritableComparable<?>, ? super Writable> of) {
        super(of);
    }

    public RecordWriter<WritableComparable<?>, HCatRecord> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        FileRecordWriterContainer rw;
        FileOutputFormatContainer.setWorkOutputPath(context);
        context.getConfiguration().set("mapred.output.key.class", NullWritable.class.getName());
        String jobInfoString = context.getConfiguration().get("mapreduce.lib.hcatoutput.info");
        OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize(jobInfoString);
        StorerInfo storeInfo = jobInfo.getTableInfo().getStorerInfo();
        HCatStorageHandler storageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), storeInfo);
        Class serde = storageHandler.getSerDeClass();
        SerDe sd = (SerDe)ReflectionUtils.newInstance((Class)serde, (Configuration)context.getConfiguration());
        context.getConfiguration().set("mapred.output.value.class", sd.getSerializedClass().getName());
        if (HCatBaseOutputFormat.getJobInfo((JobContext)context).isDynamicPartitioningUsed()) {
            rw = new FileRecordWriterContainer((org.apache.hadoop.mapred.RecordWriter)null, context);
        } else {
            Path parentDir = new Path(context.getConfiguration().get("mapred.work.output.dir"));
            Path childPath = new Path(parentDir, FileOutputFormat.getUniqueName((JobConf)new JobConf(context.getConfiguration()), (String)"part"));
            rw = new FileRecordWriterContainer(this.getBaseOutputFormat().getRecordWriter(parentDir.getFileSystem(context.getConfiguration()), new JobConf(context.getConfiguration()), childPath.toString(), (Progressable)InternalUtil.createReporter(context)), context);
        }
        return rw;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(context);
        HiveMetaStoreClient client = null;
        try {
            HiveConf hiveConf = HCatUtil.getHiveConf(context.getConfiguration());
            client = HCatUtil.getHiveClient(hiveConf);
            FileOutputFormatContainer.handleDuplicatePublish(context, jobInfo, client, new Table(jobInfo.getTableInfo().getTable()));
        }
        catch (MetaException e) {
            try {
                throw new IOException(e);
                catch (TException e2) {
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable) {
                HCatUtil.closeHiveClientQuietly(client);
                throw throwable;
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
        if (!jobInfo.isDynamicPartitioningUsed()) {
            JobConf jobConf = new JobConf(context.getConfiguration());
            this.getBaseOutputFormat().checkOutputSpecs(null, jobConf);
            HCatUtil.copyConf((Configuration)jobConf, context.getConfiguration());
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        FileOutputFormatContainer.setWorkOutputPath(context);
        return new FileOutputCommitterContainer((JobContext)context, HCatBaseOutputFormat.getJobInfo((JobContext)context).isDynamicPartitioningUsed() ? null : new JobConf(context.getConfiguration()).getOutputCommitter());
    }

    private static void handleDuplicatePublish(JobContext context, OutputJobInfo outputInfo, HiveMetaStoreClient client, Table table) throws IOException, MetaException, TException, NoSuchObjectException {
        if (table.getPartitionKeys().size() > 0) {
            if (!outputInfo.isDynamicPartitioningUsed()) {
                List<String> partitionValues = FileOutputFormatContainer.getPartitionValueList(table, outputInfo.getPartitionValues());
                List currentParts = client.listPartitionNames(outputInfo.getDatabaseName(), outputInfo.getTableName(), partitionValues, (short)1);
                if (currentParts.size() > 0) {
                    throw new HCatException(ErrorType.ERROR_DUPLICATE_PARTITION);
                }
            }
        } else {
            FileStatus[] status;
            List<String> partitionValues = FileOutputFormatContainer.getPartitionValueList(table, outputInfo.getPartitionValues());
            Path tablePath = new Path(table.getTTable().getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem(context.getConfiguration());
            if (fs.exists(tablePath) && (status = fs.globStatus(new Path(tablePath, "*"), hiddenFileFilter)).length > 0) {
                throw new HCatException(ErrorType.ERROR_NON_EMPTY_TABLE, table.getDbName() + "." + table.getTableName());
            }
        }
    }

    static List<String> getPartitionValueList(Table table, Map<String, String> valueMap) throws IOException {
        if (valueMap.size() != table.getPartitionKeys().size()) {
            throw new HCatException(ErrorType.ERROR_INVALID_PARTITION_VALUES, "Table " + table.getTableName() + " has " + table.getPartitionKeys().size() + " partition keys, got " + valueMap.size());
        }
        ArrayList<String> values = new ArrayList<String>();
        for (FieldSchema schema : table.getPartitionKeys()) {
            String value = valueMap.get(schema.getName().toLowerCase());
            if (value == null) {
                throw new HCatException(ErrorType.ERROR_MISSING_PARTITION_KEY, "Key " + schema.getName() + " of table " + table.getTableName());
            }
            values.add(value);
        }
        return values;
    }

    static void setWorkOutputPath(TaskAttemptContext context) throws IOException {
        String outputPath = context.getConfiguration().get("mapred.output.dir");
        if (outputPath != null) {
            context.getConfiguration().set("mapred.work.output.dir", new FileOutputCommitter(new Path(outputPath), context).getWorkPath().toString());
        }
    }
}

