/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hcatalog.data.DataType;

public abstract class ReaderWriter {
    private static final String UTF8 = "UTF-8";

    public static Object readDatum(DataInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 55: {
                byte[] buffer = new byte[in.readInt()];
                in.readFully(buffer);
                return new String(buffer, UTF8);
            }
            case 10: {
                VIntWritable vint = new VIntWritable();
                vint.readFields(in);
                return vint.get();
            }
            case 15: {
                VLongWritable vlong = new VLongWritable();
                vlong.readFields(in);
                return vlong.get();
            }
            case 20: {
                return Float.valueOf(in.readFloat());
            }
            case 25: {
                return in.readDouble();
            }
            case 5: {
                return in.readBoolean();
            }
            case 6: {
                return in.readByte();
            }
            case 11: {
                return in.readShort();
            }
            case 1: {
                return null;
            }
            case 60: {
                int len = in.readInt();
                byte[] ba = new byte[len];
                in.readFully(ba);
                return ba;
            }
            case 100: {
                int size = in.readInt();
                HashMap<Object, Object> m = new HashMap<Object, Object>(size);
                for (int i = 0; i < size; ++i) {
                    m.put(ReaderWriter.readDatum(in), ReaderWriter.readDatum(in));
                }
                return m;
            }
            case 120: {
                int sz = in.readInt();
                ArrayList<Object> list = new ArrayList<Object>(sz);
                for (int i = 0; i < sz; ++i) {
                    list.add(ReaderWriter.readDatum(in));
                }
                return list;
            }
        }
        throw new IOException("Unexpected data type " + type + " found in stream.");
    }

    public static void writeDatum(DataOutput out, Object val) throws IOException {
        byte type = DataType.findType(val);
        switch (type) {
            case 120: {
                out.writeByte(120);
                List list = (List)val;
                int sz = list.size();
                out.writeInt(sz);
                for (int i = 0; i < sz; ++i) {
                    ReaderWriter.writeDatum(out, list.get(i));
                }
                return;
            }
            case 100: {
                out.writeByte(100);
                Map m = (Map)val;
                out.writeInt(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    ReaderWriter.writeDatum(out, entry.getKey());
                    ReaderWriter.writeDatum(out, entry.getValue());
                }
                return;
            }
            case 10: {
                out.writeByte(10);
                new VIntWritable(((Integer)val).intValue()).write(out);
                return;
            }
            case 15: {
                out.writeByte(15);
                new VLongWritable(((Long)val).longValue()).write(out);
                return;
            }
            case 20: {
                out.writeByte(20);
                out.writeFloat(((Float)val).floatValue());
                return;
            }
            case 25: {
                out.writeByte(25);
                out.writeDouble((Double)val);
                return;
            }
            case 5: {
                out.writeByte(5);
                out.writeBoolean((Boolean)val);
                return;
            }
            case 6: {
                out.writeByte(6);
                out.writeByte(((Byte)val).byteValue());
                return;
            }
            case 11: {
                out.writeByte(11);
                out.writeShort(((Short)val).shortValue());
                return;
            }
            case 55: {
                String s = (String)val;
                byte[] utfBytes = s.getBytes(UTF8);
                out.writeByte(55);
                out.writeInt(utfBytes.length);
                out.write(utfBytes);
                return;
            }
            case 60: {
                byte[] ba = (byte[])val;
                out.writeByte(60);
                out.writeInt(ba.length);
                out.write(ba);
                return;
            }
            case 1: {
                out.writeByte(1);
                return;
            }
        }
        throw new IOException("Unexpected data type " + type + " found in stream.");
    }
}

