/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.security.HdfsAuthorizationProvider;

public class StorageDelegationAuthorizationProvider
extends HiveAuthorizationProviderBase {
    protected HiveAuthorizationProvider hdfsAuthorizer = new HdfsAuthorizationProvider();
    protected static Map<String, String> authProviders = new HashMap<String, String>();

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.hdfsAuthorizer.setConf(conf);
    }

    public void init(Configuration conf) throws HiveException {
        this.hive_db = new HiveAuthorizationProviderBase.HiveProxy((HiveAuthorizationProviderBase)this, Hive.get((HiveConf)new HiveConf(conf, HiveAuthorizationProvider.class)));
    }

    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        super.setAuthenticator(authenticator);
        this.hdfsAuthorizer.setAuthenticator(authenticator);
    }

    public static void registerAuthProvider(String storageHandlerClass, String authProviderClass) {
        authProviders.put(storageHandlerClass, authProviderClass);
    }

    protected HiveAuthorizationProvider getDelegate(Table table) throws HiveException {
        HiveStorageHandler handler = table.getStorageHandler();
        if (handler != null) {
            if (handler instanceof HCatStorageHandler) {
                return ((HCatStorageHandler)handler).getAuthorizationProvider();
            }
            String authProviderClass = authProviders.get(handler.getClass().getCanonicalName());
            if (authProviderClass != null) {
                try {
                    ReflectionUtils.newInstance((Class)this.getConf().getClassByName(authProviderClass), (Configuration)this.getConf());
                }
                catch (ClassNotFoundException ex) {
                    throw new HiveException("Cannot instantiate delegation AuthotizationProvider");
                }
            }
            throw new HiveException(String.format("Storage Handler for table:%s is not an instance of HCatStorageHandler", table.getTableName()));
        }
        return this.hdfsAuthorizer;
    }

    public void authorize(Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.hdfsAuthorizer.authorize(readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Database db, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.hdfsAuthorizer.authorize(db, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Table table, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.getDelegate(table).authorize(table, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Partition part, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.getDelegate(part.getTable()).authorize(part, readRequiredPriv, writeRequiredPriv);
    }

    public void authorize(Table table, Partition part, List<String> columns, Privilege[] readRequiredPriv, Privilege[] writeRequiredPriv) throws HiveException, AuthorizationException {
        this.getDelegate(table).authorize(table, part, columns, readRequiredPriv, writeRequiredPriv);
    }

    static {
        StorageDelegationAuthorizationProvider.registerAuthProvider("org.apache.hadoop.hive.hbase.HBaseStorageHandler", "org.apache.hcatalog.hbase.HBaseAuthorizationProvider");
        StorageDelegationAuthorizationProvider.registerAuthProvider("org.apache.hcatalog.hbase.HBaseHCatStorageHandler", "org.apache.hcatalog.hbase.HBaseAuthorizationProvider");
    }
}

