/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hcatalog.common.ErrorType;
import org.apache.hcatalog.common.HCatException;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.data.schema.HCatSchemaUtils;
import org.apache.hcatalog.har.HarOutputCommitterPostProcessor;
import org.apache.hcatalog.mapreduce.FileOutputFormatContainer;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.HCatStorageHandler;
import org.apache.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hcatalog.mapreduce.InternalUtil;
import org.apache.hcatalog.mapreduce.OutputCommitterContainer;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hcatalog.mapreduce.StorerInfo;
import org.apache.hive.hcatalog.mapreduce.HCatMapRedUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileOutputCommitterContainer
extends OutputCommitterContainer {
    private static final String TEMP_DIR_NAME = "_temporary";
    private static final String LOGS_DIR_NAME = "_logs";
    private static final Logger LOG = LoggerFactory.getLogger(FileOutputCommitterContainer.class);
    private final boolean dynamicPartitioningUsed;
    private boolean partitionsDiscovered;
    private Map<String, Map<String, String>> partitionsDiscoveredByPath;
    private Map<String, org.apache.hadoop.mapreduce.JobContext> contextDiscoveredByPath;
    private final HCatStorageHandler cachedStorageHandler;
    HarOutputCommitterPostProcessor harProcessor = new HarOutputCommitterPostProcessor();
    private String ptnRootLocation = null;
    private OutputJobInfo jobInfo = null;
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";

    public FileOutputCommitterContainer(org.apache.hadoop.mapreduce.JobContext context, OutputCommitter baseCommitter) throws IOException {
        super(context, baseCommitter);
        this.jobInfo = HCatOutputFormat.getJobInfo(context);
        this.dynamicPartitioningUsed = this.jobInfo.isDynamicPartitioningUsed();
        this.partitionsDiscovered = !this.dynamicPartitioningUsed;
        this.cachedStorageHandler = HCatUtil.getStorageHandler(context.getConfiguration(), this.jobInfo.getTableInfo().getStorerInfo());
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().abortTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            FileOutputFormatContainer.setWorkOutputPath(context);
            this.getBaseOutputCommitter().commitTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            return this.getBaseOutputCommitter().needsTaskCommit((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
        return false;
    }

    public void setupJob(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().setupJob((org.apache.hadoop.mapreduce.JobContext)HCatMapRedUtil.createJobContext(context));
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (!this.dynamicPartitioningUsed) {
            this.getBaseOutputCommitter().setupTask((TaskAttemptContext)HCatMapRedUtil.createTaskAttemptContext(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJob(org.apache.hadoop.mapreduce.JobContext jobContext, JobStatus.State state) throws IOException {
        try {
            if (this.dynamicPartitioningUsed) {
                this.discoverPartitions(jobContext);
            }
            JobContext mapRedJobContext = HCatMapRedUtil.createJobContext(jobContext);
            if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
                this.getBaseOutputCommitter().abortJob((org.apache.hadoop.mapreduce.JobContext)mapRedJobContext, state);
            } else if (this.dynamicPartitioningUsed) {
                for (org.apache.hadoop.mapreduce.JobContext currContext : this.contextDiscoveredByPath.values()) {
                    try {
                        new JobConf(currContext.getConfiguration()).getOutputCommitter().abortJob(currContext, state);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(jobContext);
            Path src = this.dynamicPartitioningUsed ? new Path(this.getPartitionRootLocation(jobInfo.getLocation(), jobInfo.getTableInfo().getTable().getPartitionKeysSize())) : new Path(jobInfo.getLocation());
            FileSystem fs = src.getFileSystem(jobContext.getConfiguration());
            LOG.info("Job failed. Cleaning up temporary directory [{}].", (Object)src);
            fs.delete(src, true);
        }
        finally {
            this.cancelDelegationTokens(jobContext);
        }
    }

    private static boolean getOutputDirMarking(Configuration conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitJob(org.apache.hadoop.mapreduce.JobContext jobContext) throws IOException {
        try {
            Path filePath;
            Path outputPath;
            FileSystem fileSys;
            if (this.dynamicPartitioningUsed) {
                this.discoverPartitions(jobContext);
                for (org.apache.hadoop.mapreduce.JobContext context : this.contextDiscoveredByPath.values()) {
                    new JobConf(context.getConfiguration()).getOutputCommitter().commitJob(context);
                }
            }
            if (this.getBaseOutputCommitter() != null && !this.dynamicPartitioningUsed) {
                this.getBaseOutputCommitter().commitJob((org.apache.hadoop.mapreduce.JobContext)HCatMapRedUtil.createJobContext(jobContext));
            }
            this.registerPartitions(jobContext);
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(jobContext);
            if (FileOutputCommitterContainer.getOutputDirMarking(jobContext.getConfiguration()) && (fileSys = (outputPath = new Path(jobInfo.getLocation())).getFileSystem(jobContext.getConfiguration())).exists(outputPath) && !fileSys.exists(filePath = new Path(outputPath, SUCCEEDED_FILE_NAME))) {
                fileSys.create(filePath).close();
            }
        }
        finally {
            this.cancelDelegationTokens(jobContext);
        }
    }

    public void cleanupJob(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        throw new IOException("The method cleanupJob is deprecated and should not be called.");
    }

    private String getPartitionRootLocation(String ptnLocn, int numPtnKeys) {
        if (this.ptnRootLocation == null) {
            Path ptnRoot = new Path(ptnLocn);
            for (int i = 0; i < numPtnKeys; ++i) {
                ptnRoot = ptnRoot.getParent();
            }
            this.ptnRootLocation = ptnRoot.toString();
        }
        return this.ptnRootLocation;
    }

    private Partition constructPartition(org.apache.hadoop.mapreduce.JobContext context, OutputJobInfo jobInfo, String partLocnRoot, Map<String, String> partKVs, HCatSchema outputSchema, Map<String, String> params, Table table, FileSystem fs, String grpName, FsPermission perms) throws IOException {
        Path partPath;
        Partition partition = new Partition();
        partition.setDbName(table.getDbName());
        partition.setTableName(table.getTableName());
        partition.setSd(new StorageDescriptor(table.getTTable().getSd()));
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (HCatFieldSchema fieldSchema : outputSchema.getFields()) {
            fields.add(HCatSchemaUtils.getFieldSchema(fieldSchema));
        }
        partition.getSd().setCols(fields);
        partition.setValues(FileOutputFormatContainer.getPartitionValueList(table, partKVs));
        partition.setParameters(params);
        if (Boolean.valueOf(table.getProperty("EXTERNAL")).booleanValue() && jobInfo.getLocation() != null && jobInfo.getLocation().length() > 0) {
            partPath = new Path(jobInfo.getLocation());
        } else {
            partPath = new Path(partLocnRoot);
            int i = 0;
            for (FieldSchema partKey : table.getPartitionKeys()) {
                if (i++ != 0) {
                    this.applyGroupAndPerms(fs, partPath, perms, grpName, false);
                }
                partPath = this.constructPartialPartPath(partPath, partKey.getName().toLowerCase(), partKVs);
            }
        }
        if (!ShimLoader.getHadoopShims().getHCatShim().isFileInHDFS(fs, partPath)) {
            this.applyGroupAndPerms(fs, partPath, perms, grpName, true);
        }
        if (this.dynamicPartitioningUsed) {
            String dynamicPartitionDestination = this.getFinalDynamicPartitionDestination(table, partKVs);
            if (this.harProcessor.isEnabled()) {
                this.harProcessor.exec(context, partition, partPath);
                partition.getSd().setLocation(this.harProcessor.getProcessedLocation(new Path(dynamicPartitionDestination)));
            } else {
                partition.getSd().setLocation(dynamicPartitionDestination);
            }
        } else {
            partition.getSd().setLocation(partPath.toString());
        }
        return partition;
    }

    private void applyGroupAndPerms(FileSystem fs, Path dir, FsPermission permission, String group, boolean recursive) throws IOException {
        fs.setPermission(dir, permission);
        if (recursive) {
            for (FileStatus fileStatus : fs.listStatus(dir)) {
                if (fileStatus.isDir()) {
                    this.applyGroupAndPerms(fs, fileStatus.getPath(), permission, group, true);
                    continue;
                }
                fs.setPermission(fileStatus.getPath(), permission);
            }
        }
    }

    private String getFinalDynamicPartitionDestination(Table table, Map<String, String> partKVs) {
        Path partPath = new Path(table.getTTable().getSd().getLocation());
        for (FieldSchema partKey : table.getPartitionKeys()) {
            partPath = this.constructPartialPartPath(partPath, partKey.getName().toLowerCase(), partKVs);
        }
        return partPath.toString();
    }

    private Map<String, String> getStorerParameterMap(StorerInfo storer) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : storer.getProperties().entrySet()) {
            params.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return params;
    }

    private Path constructPartialPartPath(Path partialPath, String partKey, Map<String, String> partKVs) {
        StringBuilder sb = new StringBuilder(FileUtils.escapePathName((String)partKey));
        sb.append("=");
        sb.append(FileUtils.escapePathName((String)partKVs.get(partKey)));
        return new Path(partialPath, sb.toString());
    }

    private void updateTableSchema(HiveMetaStoreClient client, Table table, HCatSchema partitionSchema) throws IOException, InvalidOperationException, MetaException, TException {
        List<FieldSchema> newColumns = HCatUtil.validatePartitionSchema(table, partitionSchema);
        if (newColumns.size() != 0) {
            ArrayList<FieldSchema> tableColumns = new ArrayList<FieldSchema>(table.getTTable().getSd().getCols());
            tableColumns.addAll(newColumns);
            table.getTTable().getSd().setCols(tableColumns);
            client.alter_table(table.getDbName(), table.getTableName(), table.getTTable());
        }
    }

    private void moveTaskOutputs(FileSystem fs, Path file, Path srcDir, Path destDir, boolean dryRun) throws IOException {
        if (file.getName().equals(TEMP_DIR_NAME) || file.getName().equals(LOGS_DIR_NAME) || file.getName().equals(SUCCEEDED_FILE_NAME)) {
            return;
        }
        Path finalOutputPath = this.getFinalPath(file, srcDir, destDir);
        if (fs.isFile(file)) {
            if (dryRun) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Testing if moving file: [" + file + "] to [" + finalOutputPath + "] would cause a problem");
                }
                if (fs.exists(finalOutputPath)) {
                    throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Data already exists in " + finalOutputPath + ", duplicate publish not possible.");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Moving file: [ " + file + "] to [" + finalOutputPath + "]");
                }
                fs.mkdirs(finalOutputPath.getParent());
                if (!fs.rename(file, finalOutputPath)) {
                    if (!fs.delete(finalOutputPath, true)) {
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Failed to delete existing path " + finalOutputPath);
                    }
                    if (!fs.rename(file, finalOutputPath)) {
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Failed to move output to " + finalOutputPath);
                    }
                }
            }
        } else if (fs.getFileStatus(file).isDir()) {
            FileStatus[] children = fs.listStatus(file);
            FileStatus firstChild = null;
            if (children != null) {
                for (int index = 0; index < children.length; ++index) {
                    if (children[index].getPath().getName().equals(TEMP_DIR_NAME) || children[index].getPath().getName().equals(LOGS_DIR_NAME) || children[index].getPath().getName().equals(SUCCEEDED_FILE_NAME)) continue;
                    firstChild = children[index];
                    break;
                }
            }
            if (firstChild != null && firstChild.isDir()) {
                for (FileStatus child : children) {
                    this.moveTaskOutputs(fs, child.getPath(), srcDir, destDir, dryRun);
                }
            } else if (!dryRun) {
                if (this.dynamicPartitioningUsed) {
                    Path parentDir = finalOutputPath.getParent();
                    Path placeholder = new Path(parentDir, "_placeholder");
                    if (fs.mkdirs(parentDir)) {
                        fs.create(placeholder).close();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Moving directory: " + file + " to " + parentDir);
                    }
                    if (!fs.rename(file, parentDir)) {
                        String msg = "Failed to move file: " + file + " to " + parentDir;
                        LOG.error(msg);
                        throw new HCatException(ErrorType.ERROR_MOVE_FAILED, msg);
                    }
                    fs.delete(placeholder, false);
                } else {
                    for (FileStatus child : children) {
                        this.moveTaskOutputs(fs, child.getPath(), srcDir, destDir, dryRun);
                    }
                }
            } else if (fs.exists(finalOutputPath)) {
                throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Data already exists in " + finalOutputPath + ", duplicate publish not possible.");
            }
        } else {
            String msg = "Unknown file type being asked to be moved, erroring out";
            throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Unknown file type being asked to be moved, erroring out");
        }
    }

    private Path getFinalPath(Path file, Path src, Path dest) throws IOException {
        URI relativePath;
        URI taskOutputUri = file.toUri();
        if (taskOutputUri == (relativePath = src.toUri().relativize(taskOutputUri))) {
            throw new HCatException(ErrorType.ERROR_MOVE_FAILED, "Can not get the relative path: base = " + src + " child = " + file);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(dest, relativePath.getPath());
        }
        return dest;
    }

    private void discoverPartitions(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        if (!this.partitionsDiscovered) {
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(context);
            this.harProcessor.setEnabled(jobInfo.getHarRequested());
            List<Integer> dynamicPartCols = jobInfo.getPosOfDynPartCols();
            int maxDynamicPartitions = jobInfo.getMaxDynamicPartitions();
            Path loadPath = new Path(jobInfo.getLocation());
            FileSystem fs = loadPath.getFileSystem(context.getConfiguration());
            String dynPathSpec = loadPath.toUri().getPath();
            dynPathSpec = dynPathSpec.replaceAll("__HIVE_DEFAULT_PARTITION__", "*");
            Path pathPattern = new Path(dynPathSpec);
            FileStatus[] status = fs.globStatus(pathPattern);
            this.partitionsDiscoveredByPath = new LinkedHashMap<String, Map<String, String>>();
            this.contextDiscoveredByPath = new LinkedHashMap<String, org.apache.hadoop.mapreduce.JobContext>();
            if (status.length != 0) {
                if (maxDynamicPartitions != -1 && status.length > maxDynamicPartitions) {
                    this.partitionsDiscovered = true;
                    throw new HCatException(ErrorType.ERROR_TOO_MANY_DYNAMIC_PTNS, "Number of dynamic partitions being created exceeds configured max allowable partitions[" + maxDynamicPartitions + "], increase parameter [" + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + "] if needed.");
                }
                for (FileStatus st : status) {
                    LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>();
                    Warehouse.makeSpecFromName(fullPartSpec, (Path)st.getPath());
                    this.partitionsDiscoveredByPath.put(st.getPath().toString(), fullPartSpec);
                    JobConf jobConf = (JobConf)context.getConfiguration();
                    JobContext currContext = HCatMapRedUtil.createJobContext(jobConf, context.getJobID(), (Progressable)InternalUtil.createReporter(HCatMapRedUtil.createTaskAttemptContext((Configuration)jobConf, ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptID())));
                    HCatOutputFormat.configureOutputStorageHandler((org.apache.hadoop.mapreduce.JobContext)currContext, jobInfo, fullPartSpec);
                    this.contextDiscoveredByPath.put(st.getPath().toString(), (org.apache.hadoop.mapreduce.JobContext)currContext);
                }
            }
            this.partitionsDiscovered = true;
        }
    }

    private void registerPartitions(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        HiveMetaStoreClient client;
        block20: {
            if (this.dynamicPartitioningUsed) {
                this.discoverPartitions(context);
            }
            OutputJobInfo jobInfo = HCatOutputFormat.getJobInfo(context);
            Configuration conf = context.getConfiguration();
            Table table = new Table(jobInfo.getTableInfo().getTable());
            Path tblPath = new Path(table.getTTable().getSd().getLocation());
            FileSystem fs = tblPath.getFileSystem(conf);
            if (table.getPartitionKeys().size() == 0) {
                Path src = new Path(jobInfo.getLocation());
                this.moveTaskOutputs(fs, src, src, tblPath, false);
                fs.delete(src, true);
                return;
            }
            client = null;
            HCatTableInfo tableInfo = jobInfo.getTableInfo();
            ArrayList partitionsAdded = new ArrayList();
            try {
                Path src;
                HiveConf hiveConf = HCatUtil.getHiveConf(conf);
                client = HCatUtil.getHiveClient(hiveConf);
                StorerInfo storer = InternalUtil.extractStorerInfo(table.getTTable().getSd(), table.getParameters());
                FileStatus tblStat = fs.getFileStatus(tblPath);
                String grpName = tblStat.getGroup();
                FsPermission perms = tblStat.getPermission();
                ArrayList<Partition> partitionsToAdd = new ArrayList<Partition>();
                if (!this.dynamicPartitioningUsed) {
                    partitionsToAdd.add(this.constructPartition(context, jobInfo, tblPath.toString(), jobInfo.getPartitionValues(), jobInfo.getOutputSchema(), this.getStorerParameterMap(storer), table, fs, grpName, perms));
                } else {
                    for (Map.Entry<String, Map<String, String>> entry : this.partitionsDiscoveredByPath.entrySet()) {
                        partitionsToAdd.add(this.constructPartition(context, jobInfo, this.getPartitionRootLocation(entry.getKey(), entry.getValue().size()), entry.getValue(), jobInfo.getOutputSchema(), this.getStorerParameterMap(storer), table, fs, grpName, perms));
                    }
                }
                ArrayList<Map<String, String>> ptnInfos = new ArrayList<Map<String, String>>();
                for (Partition ptn : partitionsToAdd) {
                    ptnInfos.add(InternalUtil.createPtnKeyValueMap(new Table(tableInfo.getTable()), ptn));
                }
                if (this.dynamicPartitioningUsed && this.harProcessor.isEnabled() && !partitionsToAdd.isEmpty()) {
                    src = new Path(this.ptnRootLocation);
                    this.moveTaskOutputs(fs, src, src, tblPath, true);
                    this.moveTaskOutputs(fs, src, src, tblPath, false);
                    fs.delete(src, true);
                    try {
                        this.updateTableSchema(client, table, jobInfo.getOutputSchema());
                        LOG.info("HAR is being used. The table {} has new partitions {}.", (Object)table.getTableName(), ptnInfos);
                        client.add_partitions(partitionsToAdd);
                        partitionsAdded = partitionsToAdd;
                        break block20;
                    }
                    catch (Exception e) {
                        for (Partition p : partitionsToAdd) {
                            Path ptnPath = new Path(this.harProcessor.getParentFSPath(new Path(p.getSd().getLocation())));
                            if (!fs.exists(ptnPath)) continue;
                            fs.delete(ptnPath, true);
                        }
                        throw e;
                    }
                }
                this.updateTableSchema(client, table, jobInfo.getOutputSchema());
                LOG.info("HAR not is not being used. The table {} has new partitions {}.", (Object)table.getTableName(), ptnInfos);
                if (this.dynamicPartitioningUsed && partitionsToAdd.size() > 0) {
                    src = new Path(this.ptnRootLocation);
                    this.moveTaskOutputs(fs, src, src, tblPath, true);
                    this.moveTaskOutputs(fs, src, src, tblPath, false);
                    fs.delete(src, true);
                }
                client.add_partitions(partitionsToAdd);
                partitionsAdded = partitionsToAdd;
            }
            catch (Exception e) {
                try {
                    if (partitionsAdded.size() > 0) {
                        try {
                            for (Partition p : partitionsAdded) {
                                client.dropPartition(tableInfo.getDatabaseName(), tableInfo.getTableName(), p.getValues());
                            }
                        }
                        catch (Exception te) {
                            throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, (Throwable)e);
                        }
                    }
                    if (e instanceof HCatException) {
                        throw (HCatException)e;
                    }
                    throw new HCatException(ErrorType.ERROR_PUBLISHING_PARTITION, (Throwable)e);
                }
                catch (Throwable throwable) {
                    HCatUtil.closeHiveClientQuietly(client);
                    throw throwable;
                }
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cancelDelegationTokens(org.apache.hadoop.mapreduce.JobContext context) throws IOException {
        HiveMetaStoreClient client;
        block6: {
            LOG.info("Cancelling deletgation token for the job.");
            client = null;
            try {
                HiveConf hiveConf = HCatUtil.getHiveConf(context.getConfiguration());
                client = HCatUtil.getHiveClient(hiveConf);
                String tokenStrForm = client.getTokenStrForm();
                if (tokenStrForm == null || context.getConfiguration().get("mapreduce.lib.hcatoutput.token.sig") == null) break block6;
                client.cancelDelegationToken(tokenStrForm);
            }
            catch (MetaException e) {
                LOG.warn("MetaException while cancelling delegation token.", (Throwable)e);
                HCatUtil.closeHiveClientQuietly(client);
            }
            catch (TException e2) {
                LOG.warn("TException while cancelling delegation token.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        HCatUtil.closeHiveClientQuietly(client);
                        throw throwable;
                    }
                }
                HCatUtil.closeHiveClientQuietly(client);
            }
        }
        HCatUtil.closeHiveClientQuietly(client);
    }
}

