/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package test.org.apache.spark.java8

import org.apache.spark.SharedSparkContext
import org.apache.spark.SparkFunSuite

/**
 * Test cases where JDK8-compiled Scala user code is used with Spark.
 */
class JDK8ScalaSuite extends SparkFunSuite with SharedSparkContext {
  test("basic RDD closure test (SPARK-6152)") {
    sc.parallelize(1 to 1000).map(x => x * x).count()
  }
}
