/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hcatalog.cli;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HCatDriver
extends Driver {
    public CommandProcessorResponse run(String command) {
        CommandProcessorResponse cpr = null;
        try {
            cpr = super.run(command);
        }
        catch (CommandNeedRetryException e) {
            return new CommandProcessorResponse(-1, e.toString(), "");
        }
        SessionState ss = SessionState.get();
        if (cpr.getResponseCode() == 0) {
            int rc = this.setFSPermsNGrp(ss);
            cpr = new CommandProcessorResponse(rc);
        }
        ss.getConf().set("hcat.create.db.name", "");
        ss.getConf().set("hcat.create.tbl.name", "");
        return cpr;
    }

    private int setFSPermsNGrp(SessionState ss) {
        HiveConf conf = ss.getConf();
        String tblName = conf.get("hcat.create.tbl.name", "");
        if (tblName.isEmpty()) {
            tblName = conf.get("import.destination.table", "");
            conf.set("import.destination.table", "");
        }
        String dbName = conf.get("hcat.create.db.name", "");
        String grp = conf.get("hcat.group", null);
        String permsStr = conf.get("hcat.perms", null);
        if (tblName.isEmpty() && dbName.isEmpty()) {
            return 0;
        }
        if (null == grp && null == permsStr) {
            return 0;
        }
        FsPermission perms = FsPermission.valueOf((String)permsStr);
        if (!tblName.isEmpty()) {
            Hive db = null;
            try {
                db = Hive.get();
                Table tbl = db.getTable(tblName);
                Path tblPath = tbl.getPath();
                FileSystem fs = tblPath.getFileSystem((Configuration)conf);
                if (null != perms) {
                    fs.setPermission(tblPath, perms);
                }
                if (null != grp) {
                    fs.setOwner(tblPath, null, grp);
                }
                return 0;
            }
            catch (Exception e) {
                ss.err.println(String.format("Failed to set permissions/groups on TABLE: <%s> %s", tblName, e.getMessage()));
                try {
                    if (null != db) {
                        db.dropTable(tblName);
                    }
                }
                catch (HiveException he) {
                    ss.err.println(String.format("Failed to drop TABLE <%s> after failing to set permissions/groups on it. %s", tblName, e.getMessage()));
                }
                return 1;
            }
        }
        if (dbName.isEmpty() || dbName.equals("default")) {
            return 0;
        }
        try {
            Hive db = Hive.get();
            Path dbPath = new Warehouse((Configuration)conf).getDatabasePath(db.getDatabase(dbName));
            FileSystem fs = dbPath.getFileSystem((Configuration)conf);
            if (perms != null) {
                fs.setPermission(dbPath, perms);
            }
            if (null != grp) {
                fs.setOwner(dbPath, null, grp);
            }
            return 0;
        }
        catch (Exception e) {
            ss.err.println(String.format("Failed to set permissions and/or group on DB: <%s> %s", dbName, e.getMessage()));
            try {
                Hive.get().dropDatabase(dbName);
            }
            catch (Exception e1) {
                ss.err.println(String.format("Failed to drop DB <%s> after failing to set permissions/group on it. %s", dbName, e1.getMessage()));
            }
            return 1;
        }
    }
}

