import { StyleSheet, Platform } from 'react-native';
import { scenePadding } from 'kitsu/screens/Profiles/constants';
import * as colors from 'kitsu/constants/colors';

export const styles = StyleSheet.create({
  loading: {
    alignItems: 'center',
    justifyContent: 'center',
    height: 100,
  },
  itemWrap: {
    padding: scenePadding,
    backgroundColor: colors.white,
    flexDirection: 'row',
    alignItems: 'center',
  },
  textContainer: {
    flex: 1,
    flexDirection: 'row',
    alignItems: 'center',
  },
  itemTitle: {
    marginLeft: 8,
    flexShrink: 1,
  },
  progressIconContainer: {
    paddingLeft: 8,
    paddingVertical: 4,
  },
  progressIconCircle: {
    width: 30,
    height: 30,
    borderRadius: 15,
    borderWidth: StyleSheet.hairlineWidth,
    borderColor: colors.lightGrey,
    alignItems: 'center',
    justifyContent: 'center',
  },
  progressIconCircle__completed: {
    backgroundColor: colors.green,
    borderColor: colors.green,
  },
  progressIcon: {
    fontSize: 28,
    backgroundColor: 'transparent',
    paddingTop: Platform.select({ ios: 4, android: 0 }),
  },

  sortingContainer: {
    backgroundColor: colors.listBackPurple,
    justifyContent: 'flex-end',
    padding: 8,
  },
  sortingText: {
    fontSize: 12,
    color: 'white',
    textAlign: 'right',
    textAlignVertical: 'center',
  },
  watchIcon: {
    color: colors.darkGrey,
    paddingHorizontal: 8,
    paddingVertical: 0,
  },
  arrowIcon: {
    fontSize: 16,
    color: colors.darkGrey,
    paddingLeft: 8,
    paddingVertical: 0,
  },
});
