/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { ApprovalStatus } from './ApprovalStatus';
import {
    ApprovalStatusFromJSON,
    ApprovalStatusFromJSONTyped,
    ApprovalStatusToJSON,
    ApprovalStatusToJSONTyped,
} from './ApprovalStatus';

/**
 * 
 * @export
 * @interface Approval
 */
export interface Approval {
    /**
     * Unique approval identifier
     * @type {string}
     * @memberof Approval
     */
    id: string;
    /**
     * Associated run ID
     * @type {string}
     * @memberof Approval
     */
    runId: string;
    /**
     * Associated session ID
     * @type {string}
     * @memberof Approval
     */
    sessionId: string;
    /**
     * 
     * @type {ApprovalStatus}
     * @memberof Approval
     */
    status: ApprovalStatus;
    /**
     * Creation timestamp
     * @type {Date}
     * @memberof Approval
     */
    createdAt: Date;
    /**
     * Response timestamp
     * @type {Date}
     * @memberof Approval
     */
    respondedAt?: Date;
    /**
     * Tool requesting approval
     * @type {string}
     * @memberof Approval
     */
    toolName: string;
    /**
     * Tool input parameters
     * @type {{ [key: string]: any; }}
     * @memberof Approval
     */
    toolInput: { [key: string]: any; };
    /**
     * Approver's comment
     * @type {string}
     * @memberof Approval
     */
    comment?: string;
}



/**
 * Check if a given object implements the Approval interface.
 */
export function instanceOfApproval(value: object): value is Approval {
    if (!('id' in value) || value['id'] === undefined) return false;
    if (!('runId' in value) || value['runId'] === undefined) return false;
    if (!('sessionId' in value) || value['sessionId'] === undefined) return false;
    if (!('status' in value) || value['status'] === undefined) return false;
    if (!('createdAt' in value) || value['createdAt'] === undefined) return false;
    if (!('toolName' in value) || value['toolName'] === undefined) return false;
    if (!('toolInput' in value) || value['toolInput'] === undefined) return false;
    return true;
}

export function ApprovalFromJSON(json: any): Approval {
    return ApprovalFromJSONTyped(json, false);
}

export function ApprovalFromJSONTyped(json: any, ignoreDiscriminator: boolean): Approval {
    if (json == null) {
        return json;
    }
    return {
        
        'id': json['id'],
        'runId': json['run_id'],
        'sessionId': json['session_id'],
        'status': ApprovalStatusFromJSON(json['status']),
        'createdAt': (new Date(json['created_at'])),
        'respondedAt': json['responded_at'] == null ? undefined : (new Date(json['responded_at'])),
        'toolName': json['tool_name'],
        'toolInput': json['tool_input'],
        'comment': json['comment'] == null ? undefined : json['comment'],
    };
}

export function ApprovalToJSON(json: any): Approval {
    return ApprovalToJSONTyped(json, false);
}

export function ApprovalToJSONTyped(value?: Approval | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'id': value['id'],
        'run_id': value['runId'],
        'session_id': value['sessionId'],
        'status': ApprovalStatusToJSON(value['status']),
        'created_at': ((value['createdAt']).toISOString()),
        'responded_at': value['respondedAt'] == null ? undefined : ((value['respondedAt']).toISOString()),
        'tool_name': value['toolName'],
        'tool_input': value['toolInput'],
        'comment': value['comment'],
    };
}

