/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  BulkArchiveRequest,
  BulkArchiveResponse,
  BulkRestoreDraftsRequest,
  BulkRestoreDraftsResponse,
  ContinueSessionRequest,
  ContinueSessionResponse,
  ConversationResponse,
  CreateSessionRequest,
  CreateSessionResponse,
  DirectoryNotFoundResponse,
  ErrorResponse,
  InterruptSessionResponse,
  LaunchDraftSessionRequest,
  RecentPathsResponse,
  SessionResponse,
  SessionSearchResponse,
  SessionsResponse,
  SlashCommandsResponse,
  SnapshotsResponse,
  UpdateSessionRequest,
} from '../models/index';
import {
    BulkArchiveRequestFromJSON,
    BulkArchiveRequestToJSON,
    BulkArchiveResponseFromJSON,
    BulkArchiveResponseToJSON,
    BulkRestoreDraftsRequestFromJSON,
    BulkRestoreDraftsRequestToJSON,
    BulkRestoreDraftsResponseFromJSON,
    BulkRestoreDraftsResponseToJSON,
    ContinueSessionRequestFromJSON,
    ContinueSessionRequestToJSON,
    ContinueSessionResponseFromJSON,
    ContinueSessionResponseToJSON,
    ConversationResponseFromJSON,
    ConversationResponseToJSON,
    CreateSessionRequestFromJSON,
    CreateSessionRequestToJSON,
    CreateSessionResponseFromJSON,
    CreateSessionResponseToJSON,
    DirectoryNotFoundResponseFromJSON,
    DirectoryNotFoundResponseToJSON,
    ErrorResponseFromJSON,
    ErrorResponseToJSON,
    InterruptSessionResponseFromJSON,
    InterruptSessionResponseToJSON,
    LaunchDraftSessionRequestFromJSON,
    LaunchDraftSessionRequestToJSON,
    RecentPathsResponseFromJSON,
    RecentPathsResponseToJSON,
    SessionResponseFromJSON,
    SessionResponseToJSON,
    SessionSearchResponseFromJSON,
    SessionSearchResponseToJSON,
    SessionsResponseFromJSON,
    SessionsResponseToJSON,
    SlashCommandsResponseFromJSON,
    SlashCommandsResponseToJSON,
    SnapshotsResponseFromJSON,
    SnapshotsResponseToJSON,
    UpdateSessionRequestFromJSON,
    UpdateSessionRequestToJSON,
} from '../models/index';

export interface BulkArchiveSessionsRequest {
    bulkArchiveRequest: BulkArchiveRequest;
}

export interface BulkRestoreDraftsOperationRequest {
    bulkRestoreDraftsRequest: BulkRestoreDraftsRequest;
}

export interface ContinueSessionOperationRequest {
    id: string;
    continueSessionRequest: ContinueSessionRequest;
}

export interface CreateSessionOperationRequest {
    createSessionRequest: CreateSessionRequest;
}

export interface DeleteDraftSessionRequest {
    id: string;
}

export interface GetRecentPathsRequest {
    limit?: number;
}

export interface GetSessionRequest {
    id: string;
}

export interface GetSessionMessagesRequest {
    id: string;
}

export interface GetSessionSnapshotsRequest {
    id: string;
}

export interface GetSlashCommandsRequest {
    workingDir: string;
    query?: string;
}

export interface HardDeleteEmptyDraftSessionRequest {
    id: string;
}

export interface InterruptSessionRequest {
    id: string;
}

export interface LaunchDraftSessionOperationRequest {
    id: string;
    launchDraftSessionRequest: LaunchDraftSessionRequest;
}

export interface ListSessionsRequest {
    leavesOnly?: boolean;
    filter?: ListSessionsFilterEnum;
}

export interface SearchSessionsRequest {
    query?: string;
    limit?: number;
}

export interface UpdateSessionOperationRequest {
    id: string;
    updateSessionRequest: UpdateSessionRequest;
}

/**
 * SessionsApi - interface
 * 
 * @export
 * @interface SessionsApiInterface
 */
export interface SessionsApiInterface {
    /**
     * Archive or unarchive multiple sessions in a single operation
     * @summary Bulk archive/unarchive sessions
     * @param {BulkArchiveRequest} bulkArchiveRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    bulkArchiveSessionsRaw(requestParameters: BulkArchiveSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BulkArchiveResponse>>;

    /**
     * Archive or unarchive multiple sessions in a single operation
     * Bulk archive/unarchive sessions
     */
    bulkArchiveSessions(requestParameters: BulkArchiveSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BulkArchiveResponse>;

    /**
     * Restore multiple discarded draft sessions back to draft status
     * @summary Restore multiple discarded draft sessions
     * @param {BulkRestoreDraftsRequest} bulkRestoreDraftsRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    bulkRestoreDraftsRaw(requestParameters: BulkRestoreDraftsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BulkRestoreDraftsResponse>>;

    /**
     * Restore multiple discarded draft sessions back to draft status
     * Restore multiple discarded draft sessions
     */
    bulkRestoreDrafts(requestParameters: BulkRestoreDraftsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BulkRestoreDraftsResponse>;

    /**
     * Create a new session that continues from an existing session, inheriting its conversation history. 
     * @summary Continue or fork a session
     * @param {string} id Session ID
     * @param {ContinueSessionRequest} continueSessionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    continueSessionRaw(requestParameters: ContinueSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContinueSessionResponse>>;

    /**
     * Create a new session that continues from an existing session, inheriting its conversation history. 
     * Continue or fork a session
     */
    continueSession(requestParameters: ContinueSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContinueSessionResponse>;

    /**
     * Create and start a new Claude Code session
     * @summary Launch a new session
     * @param {CreateSessionRequest} createSessionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    createSessionRaw(requestParameters: CreateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CreateSessionResponse>>;

    /**
     * Create and start a new Claude Code session
     * Launch a new session
     */
    createSession(requestParameters: CreateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CreateSessionResponse>;

    /**
     * Delete a draft session that has not been launched yet
     * @summary Delete a draft session
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    deleteDraftSessionRaw(requestParameters: DeleteDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete a draft session that has not been launched yet
     * Delete a draft session
     */
    deleteDraftSession(requestParameters: DeleteDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Retrieve recently used working directories for quick access
     * @summary Get recent working directories
     * @param {number} [limit] Maximum number of paths to return
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    getRecentPathsRaw(requestParameters: GetRecentPathsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RecentPathsResponse>>;

    /**
     * Retrieve recently used working directories for quick access
     * Get recent working directories
     */
    getRecentPaths(requestParameters: GetRecentPathsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RecentPathsResponse>;

    /**
     * Get detailed information about a specific session
     * @summary Get session details
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    getSessionRaw(requestParameters: GetSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>>;

    /**
     * Get detailed information about a specific session
     * Get session details
     */
    getSession(requestParameters: GetSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse>;

    /**
     * Retrieve the full conversation history for a session, including messages, tool calls, and tool results. 
     * @summary Get conversation messages
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    getSessionMessagesRaw(requestParameters: GetSessionMessagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConversationResponse>>;

    /**
     * Retrieve the full conversation history for a session, including messages, tool calls, and tool results. 
     * Get conversation messages
     */
    getSessionMessages(requestParameters: GetSessionMessagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConversationResponse>;

    /**
     * Retrieve file snapshots captured during the session, showing the state of files at specific points in time. 
     * @summary Get file snapshots
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    getSessionSnapshotsRaw(requestParameters: GetSessionSnapshotsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SnapshotsResponse>>;

    /**
     * Retrieve file snapshots captured during the session, showing the state of files at specific points in time. 
     * Get file snapshots
     */
    getSessionSnapshots(requestParameters: GetSessionSnapshotsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SnapshotsResponse>;

    /**
     * Retrieve slash commands available in the specified working directory
     * @summary Get available slash commands
     * @param {string} workingDir Working directory to search for commands
     * @param {string} [query] Fuzzy search query
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    getSlashCommandsRaw(requestParameters: GetSlashCommandsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SlashCommandsResponse>>;

    /**
     * Retrieve slash commands available in the specified working directory
     * Get available slash commands
     */
    getSlashCommands(requestParameters: GetSlashCommandsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SlashCommandsResponse>;

    /**
     * Permanently delete a draft or discarded session from the database if it is truly empty. A session is considered empty if it has no meaningful content (no title, no query, default model, no editor state). 
     * @summary Permanently delete an empty draft session
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    hardDeleteEmptyDraftSessionRaw(requestParameters: HardDeleteEmptyDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Permanently delete a draft or discarded session from the database if it is truly empty. A session is considered empty if it has no meaningful content (no title, no query, default model, no editor state). 
     * Permanently delete an empty draft session
     */
    hardDeleteEmptyDraftSession(requestParameters: HardDeleteEmptyDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Send an interrupt signal to a running session, causing it to complete gracefully. 
     * @summary Interrupt a running session
     * @param {string} id Session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    interruptSessionRaw(requestParameters: InterruptSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InterruptSessionResponse>>;

    /**
     * Send an interrupt signal to a running session, causing it to complete gracefully. 
     * Interrupt a running session
     */
    interruptSession(requestParameters: InterruptSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InterruptSessionResponse>;

    /**
     * Launch a draft session, transitioning it from draft to running state
     * @summary Launch a draft session
     * @param {string} id Session ID
     * @param {LaunchDraftSessionRequest} launchDraftSessionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    launchDraftSessionRaw(requestParameters: LaunchDraftSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>>;

    /**
     * Launch a draft session, transitioning it from draft to running state
     * Launch a draft session
     */
    launchDraftSession(requestParameters: LaunchDraftSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse>;

    /**
     * List all sessions with optional filtering. By default returns only leaf sessions (sessions with no children). Set leavesOnly=false to get all sessions. 
     * @summary List sessions
     * @param {boolean} [leavesOnly] Return only leaf sessions (sessions with no children)
     * @param {'normal' | 'archived' | 'draft'} [filter] Filter sessions by type
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    listSessionsRaw(requestParameters: ListSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionsResponse>>;

    /**
     * List all sessions with optional filtering. By default returns only leaf sessions (sessions with no children). Set leavesOnly=false to get all sessions. 
     * List sessions
     */
    listSessions(requestParameters: ListSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionsResponse>;

    /**
     * Search for sessions using SQL LIKE queries against the title field. Returns top sessions ordered by last_activity_at descending. Limited to 20 most recently modified sessions for performance. 
     * @summary Search sessions by title
     * @param {string} [query] Search query for title matching (uses SQL LIKE)
     * @param {number} [limit] Maximum number of results to return
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    searchSessionsRaw(requestParameters: SearchSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionSearchResponse>>;

    /**
     * Search for sessions using SQL LIKE queries against the title field. Returns top sessions ordered by last_activity_at descending. Limited to 20 most recently modified sessions for performance. 
     * Search sessions by title
     */
    searchSessions(requestParameters: SearchSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionSearchResponse>;

    /**
     * Update session settings such as auto-accept mode or archived status. Only specified fields will be updated. 
     * @summary Update session settings
     * @param {string} id Session ID
     * @param {UpdateSessionRequest} updateSessionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SessionsApiInterface
     */
    updateSessionRaw(requestParameters: UpdateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>>;

    /**
     * Update session settings such as auto-accept mode or archived status. Only specified fields will be updated. 
     * Update session settings
     */
    updateSession(requestParameters: UpdateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse>;

}

/**
 * 
 */
export class SessionsApi extends runtime.BaseAPI implements SessionsApiInterface {

    /**
     * Archive or unarchive multiple sessions in a single operation
     * Bulk archive/unarchive sessions
     */
    async bulkArchiveSessionsRaw(requestParameters: BulkArchiveSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BulkArchiveResponse>> {
        if (requestParameters['bulkArchiveRequest'] == null) {
            throw new runtime.RequiredError(
                'bulkArchiveRequest',
                'Required parameter "bulkArchiveRequest" was null or undefined when calling bulkArchiveSessions().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions/archive`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: BulkArchiveRequestToJSON(requestParameters['bulkArchiveRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BulkArchiveResponseFromJSON(jsonValue));
    }

    /**
     * Archive or unarchive multiple sessions in a single operation
     * Bulk archive/unarchive sessions
     */
    async bulkArchiveSessions(requestParameters: BulkArchiveSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BulkArchiveResponse> {
        const response = await this.bulkArchiveSessionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Restore multiple discarded draft sessions back to draft status
     * Restore multiple discarded draft sessions
     */
    async bulkRestoreDraftsRaw(requestParameters: BulkRestoreDraftsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<BulkRestoreDraftsResponse>> {
        if (requestParameters['bulkRestoreDraftsRequest'] == null) {
            throw new runtime.RequiredError(
                'bulkRestoreDraftsRequest',
                'Required parameter "bulkRestoreDraftsRequest" was null or undefined when calling bulkRestoreDrafts().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions/restore`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: BulkRestoreDraftsRequestToJSON(requestParameters['bulkRestoreDraftsRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BulkRestoreDraftsResponseFromJSON(jsonValue));
    }

    /**
     * Restore multiple discarded draft sessions back to draft status
     * Restore multiple discarded draft sessions
     */
    async bulkRestoreDrafts(requestParameters: BulkRestoreDraftsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<BulkRestoreDraftsResponse> {
        const response = await this.bulkRestoreDraftsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create a new session that continues from an existing session, inheriting its conversation history. 
     * Continue or fork a session
     */
    async continueSessionRaw(requestParameters: ContinueSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ContinueSessionResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling continueSession().'
            );
        }

        if (requestParameters['continueSessionRequest'] == null) {
            throw new runtime.RequiredError(
                'continueSessionRequest',
                'Required parameter "continueSessionRequest" was null or undefined when calling continueSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions/{id}/continue`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ContinueSessionRequestToJSON(requestParameters['continueSessionRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ContinueSessionResponseFromJSON(jsonValue));
    }

    /**
     * Create a new session that continues from an existing session, inheriting its conversation history. 
     * Continue or fork a session
     */
    async continueSession(requestParameters: ContinueSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ContinueSessionResponse> {
        const response = await this.continueSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Create and start a new Claude Code session
     * Launch a new session
     */
    async createSessionRaw(requestParameters: CreateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CreateSessionResponse>> {
        if (requestParameters['createSessionRequest'] == null) {
            throw new runtime.RequiredError(
                'createSessionRequest',
                'Required parameter "createSessionRequest" was null or undefined when calling createSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateSessionRequestToJSON(requestParameters['createSessionRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CreateSessionResponseFromJSON(jsonValue));
    }

    /**
     * Create and start a new Claude Code session
     * Launch a new session
     */
    async createSession(requestParameters: CreateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CreateSessionResponse> {
        const response = await this.createSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Delete a draft session that has not been launched yet
     * Delete a draft session
     */
    async deleteDraftSessionRaw(requestParameters: DeleteDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling deleteDraftSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}/launch`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete a draft session that has not been launched yet
     * Delete a draft session
     */
    async deleteDraftSession(requestParameters: DeleteDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteDraftSessionRaw(requestParameters, initOverrides);
    }

    /**
     * Retrieve recently used working directories for quick access
     * Get recent working directories
     */
    async getRecentPathsRaw(requestParameters: GetRecentPathsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RecentPathsResponse>> {
        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/recent-paths`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RecentPathsResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve recently used working directories for quick access
     * Get recent working directories
     */
    async getRecentPaths(requestParameters: GetRecentPathsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RecentPathsResponse> {
        const response = await this.getRecentPathsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get detailed information about a specific session
     * Get session details
     */
    async getSessionRaw(requestParameters: GetSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionResponseFromJSON(jsonValue));
    }

    /**
     * Get detailed information about a specific session
     * Get session details
     */
    async getSession(requestParameters: GetSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse> {
        const response = await this.getSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve the full conversation history for a session, including messages, tool calls, and tool results. 
     * Get conversation messages
     */
    async getSessionMessagesRaw(requestParameters: GetSessionMessagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConversationResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getSessionMessages().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}/messages`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConversationResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve the full conversation history for a session, including messages, tool calls, and tool results. 
     * Get conversation messages
     */
    async getSessionMessages(requestParameters: GetSessionMessagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConversationResponse> {
        const response = await this.getSessionMessagesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve file snapshots captured during the session, showing the state of files at specific points in time. 
     * Get file snapshots
     */
    async getSessionSnapshotsRaw(requestParameters: GetSessionSnapshotsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SnapshotsResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getSessionSnapshots().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}/snapshots`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SnapshotsResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve file snapshots captured during the session, showing the state of files at specific points in time. 
     * Get file snapshots
     */
    async getSessionSnapshots(requestParameters: GetSessionSnapshotsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SnapshotsResponse> {
        const response = await this.getSessionSnapshotsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve slash commands available in the specified working directory
     * Get available slash commands
     */
    async getSlashCommandsRaw(requestParameters: GetSlashCommandsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SlashCommandsResponse>> {
        if (requestParameters['workingDir'] == null) {
            throw new runtime.RequiredError(
                'workingDir',
                'Required parameter "workingDir" was null or undefined when calling getSlashCommands().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['workingDir'] != null) {
            queryParameters['working_dir'] = requestParameters['workingDir'];
        }

        if (requestParameters['query'] != null) {
            queryParameters['query'] = requestParameters['query'];
        }

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/slash-commands`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SlashCommandsResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve slash commands available in the specified working directory
     * Get available slash commands
     */
    async getSlashCommands(requestParameters: GetSlashCommandsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SlashCommandsResponse> {
        const response = await this.getSlashCommandsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Permanently delete a draft or discarded session from the database if it is truly empty. A session is considered empty if it has no meaningful content (no title, no query, default model, no editor state). 
     * Permanently delete an empty draft session
     */
    async hardDeleteEmptyDraftSessionRaw(requestParameters: HardDeleteEmptyDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling hardDeleteEmptyDraftSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}/hard-delete-empty`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Permanently delete a draft or discarded session from the database if it is truly empty. A session is considered empty if it has no meaningful content (no title, no query, default model, no editor state). 
     * Permanently delete an empty draft session
     */
    async hardDeleteEmptyDraftSession(requestParameters: HardDeleteEmptyDraftSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.hardDeleteEmptyDraftSessionRaw(requestParameters, initOverrides);
    }

    /**
     * Send an interrupt signal to a running session, causing it to complete gracefully. 
     * Interrupt a running session
     */
    async interruptSessionRaw(requestParameters: InterruptSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InterruptSessionResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling interruptSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/{id}/interrupt`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => InterruptSessionResponseFromJSON(jsonValue));
    }

    /**
     * Send an interrupt signal to a running session, causing it to complete gracefully. 
     * Interrupt a running session
     */
    async interruptSession(requestParameters: InterruptSessionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InterruptSessionResponse> {
        const response = await this.interruptSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Launch a draft session, transitioning it from draft to running state
     * Launch a draft session
     */
    async launchDraftSessionRaw(requestParameters: LaunchDraftSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling launchDraftSession().'
            );
        }

        if (requestParameters['launchDraftSessionRequest'] == null) {
            throw new runtime.RequiredError(
                'launchDraftSessionRequest',
                'Required parameter "launchDraftSessionRequest" was null or undefined when calling launchDraftSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions/{id}/launch`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LaunchDraftSessionRequestToJSON(requestParameters['launchDraftSessionRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionResponseFromJSON(jsonValue));
    }

    /**
     * Launch a draft session, transitioning it from draft to running state
     * Launch a draft session
     */
    async launchDraftSession(requestParameters: LaunchDraftSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse> {
        const response = await this.launchDraftSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all sessions with optional filtering. By default returns only leaf sessions (sessions with no children). Set leavesOnly=false to get all sessions. 
     * List sessions
     */
    async listSessionsRaw(requestParameters: ListSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionsResponse>> {
        const queryParameters: any = {};

        if (requestParameters['leavesOnly'] != null) {
            queryParameters['leavesOnly'] = requestParameters['leavesOnly'];
        }

        if (requestParameters['filter'] != null) {
            queryParameters['filter'] = requestParameters['filter'];
        }

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionsResponseFromJSON(jsonValue));
    }

    /**
     * List all sessions with optional filtering. By default returns only leaf sessions (sessions with no children). Set leavesOnly=false to get all sessions. 
     * List sessions
     */
    async listSessions(requestParameters: ListSessionsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionsResponse> {
        const response = await this.listSessionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Search for sessions using SQL LIKE queries against the title field. Returns top sessions ordered by last_activity_at descending. Limited to 20 most recently modified sessions for performance. 
     * Search sessions by title
     */
    async searchSessionsRaw(requestParameters: SearchSessionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionSearchResponse>> {
        const queryParameters: any = {};

        if (requestParameters['query'] != null) {
            queryParameters['query'] = requestParameters['query'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/sessions/search`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionSearchResponseFromJSON(jsonValue));
    }

    /**
     * Search for sessions using SQL LIKE queries against the title field. Returns top sessions ordered by last_activity_at descending. Limited to 20 most recently modified sessions for performance. 
     * Search sessions by title
     */
    async searchSessions(requestParameters: SearchSessionsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionSearchResponse> {
        const response = await this.searchSessionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Update session settings such as auto-accept mode or archived status. Only specified fields will be updated. 
     * Update session settings
     */
    async updateSessionRaw(requestParameters: UpdateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SessionResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling updateSession().'
            );
        }

        if (requestParameters['updateSessionRequest'] == null) {
            throw new runtime.RequiredError(
                'updateSessionRequest',
                'Required parameter "updateSessionRequest" was null or undefined when calling updateSession().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/sessions/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateSessionRequestToJSON(requestParameters['updateSessionRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SessionResponseFromJSON(jsonValue));
    }

    /**
     * Update session settings such as auto-accept mode or archived status. Only specified fields will be updated. 
     * Update session settings
     */
    async updateSession(requestParameters: UpdateSessionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SessionResponse> {
        const response = await this.updateSessionRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const ListSessionsFilterEnum = {
    Normal: 'normal',
    Archived: 'archived',
    Draft: 'draft'
} as const;
export type ListSessionsFilterEnum = typeof ListSessionsFilterEnum[keyof typeof ListSessionsFilterEnum];
