/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApprovalResponse,
  ApprovalsResponse,
  CreateApprovalRequest,
  CreateApprovalResponse,
  DecideApprovalRequest,
  DecideApprovalResponse,
  ErrorResponse,
} from '../models/index';
import {
    ApprovalResponseFromJSON,
    ApprovalResponseToJSON,
    ApprovalsResponseFromJSON,
    ApprovalsResponseToJSON,
    CreateApprovalRequestFromJSON,
    CreateApprovalRequestToJSON,
    CreateApprovalResponseFromJSON,
    CreateApprovalResponseToJSON,
    DecideApprovalRequestFromJSON,
    DecideApprovalRequestToJSON,
    DecideApprovalResponseFromJSON,
    DecideApprovalResponseToJSON,
    ErrorResponseFromJSON,
    ErrorResponseToJSON,
} from '../models/index';

export interface CreateApprovalOperationRequest {
    createApprovalRequest: CreateApprovalRequest;
}

export interface DecideApprovalOperationRequest {
    id: string;
    decideApprovalRequest: DecideApprovalRequest;
}

export interface GetApprovalRequest {
    id: string;
}

export interface ListApprovalsRequest {
    sessionId?: string;
}

/**
 * ApprovalsApi - interface
 * 
 * @export
 * @interface ApprovalsApiInterface
 */
export interface ApprovalsApiInterface {
    /**
     * Create a new approval request for human review
     * @summary Create approval request
     * @param {CreateApprovalRequest} createApprovalRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ApprovalsApiInterface
     */
    createApprovalRaw(requestParameters: CreateApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CreateApprovalResponse>>;

    /**
     * Create a new approval request for human review
     * Create approval request
     */
    createApproval(requestParameters: CreateApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CreateApprovalResponse>;

    /**
     * Approve or deny an approval request
     * @summary Decide on approval request
     * @param {string} id Approval ID
     * @param {DecideApprovalRequest} decideApprovalRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ApprovalsApiInterface
     */
    decideApprovalRaw(requestParameters: DecideApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DecideApprovalResponse>>;

    /**
     * Approve or deny an approval request
     * Decide on approval request
     */
    decideApproval(requestParameters: DecideApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DecideApprovalResponse>;

    /**
     * Get detailed information about a specific approval request
     * @summary Get approval details
     * @param {string} id Approval ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ApprovalsApiInterface
     */
    getApprovalRaw(requestParameters: GetApprovalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApprovalResponse>>;

    /**
     * Get detailed information about a specific approval request
     * Get approval details
     */
    getApproval(requestParameters: GetApprovalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApprovalResponse>;

    /**
     * List approval requests with optional session filtering
     * @summary List approval requests
     * @param {string} [sessionId] Filter by session ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ApprovalsApiInterface
     */
    listApprovalsRaw(requestParameters: ListApprovalsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApprovalsResponse>>;

    /**
     * List approval requests with optional session filtering
     * List approval requests
     */
    listApprovals(requestParameters: ListApprovalsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApprovalsResponse>;

}

/**
 * 
 */
export class ApprovalsApi extends runtime.BaseAPI implements ApprovalsApiInterface {

    /**
     * Create a new approval request for human review
     * Create approval request
     */
    async createApprovalRaw(requestParameters: CreateApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CreateApprovalResponse>> {
        if (requestParameters['createApprovalRequest'] == null) {
            throw new runtime.RequiredError(
                'createApprovalRequest',
                'Required parameter "createApprovalRequest" was null or undefined when calling createApproval().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/approvals`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateApprovalRequestToJSON(requestParameters['createApprovalRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => CreateApprovalResponseFromJSON(jsonValue));
    }

    /**
     * Create a new approval request for human review
     * Create approval request
     */
    async createApproval(requestParameters: CreateApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CreateApprovalResponse> {
        const response = await this.createApprovalRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Approve or deny an approval request
     * Decide on approval request
     */
    async decideApprovalRaw(requestParameters: DecideApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DecideApprovalResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling decideApproval().'
            );
        }

        if (requestParameters['decideApprovalRequest'] == null) {
            throw new runtime.RequiredError(
                'decideApprovalRequest',
                'Required parameter "decideApprovalRequest" was null or undefined when calling decideApproval().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/approvals/{id}/decide`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DecideApprovalRequestToJSON(requestParameters['decideApprovalRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DecideApprovalResponseFromJSON(jsonValue));
    }

    /**
     * Approve or deny an approval request
     * Decide on approval request
     */
    async decideApproval(requestParameters: DecideApprovalOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DecideApprovalResponse> {
        const response = await this.decideApprovalRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get detailed information about a specific approval request
     * Get approval details
     */
    async getApprovalRaw(requestParameters: GetApprovalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApprovalResponse>> {
        if (requestParameters['id'] == null) {
            throw new runtime.RequiredError(
                'id',
                'Required parameter "id" was null or undefined when calling getApproval().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/approvals/{id}`;
        urlPath = urlPath.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters['id'])));

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApprovalResponseFromJSON(jsonValue));
    }

    /**
     * Get detailed information about a specific approval request
     * Get approval details
     */
    async getApproval(requestParameters: GetApprovalRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApprovalResponse> {
        const response = await this.getApprovalRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List approval requests with optional session filtering
     * List approval requests
     */
    async listApprovalsRaw(requestParameters: ListApprovalsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ApprovalsResponse>> {
        const queryParameters: any = {};

        if (requestParameters['sessionId'] != null) {
            queryParameters['sessionId'] = requestParameters['sessionId'];
        }

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/approvals`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ApprovalsResponseFromJSON(jsonValue));
    }

    /**
     * List approval requests with optional session filtering
     * List approval requests
     */
    async listApprovals(requestParameters: ListApprovalsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ApprovalsResponse> {
        const response = await this.listApprovalsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
