// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.5.0 DO NOT EDIT.
package api

import (
	"bytes"
	"compress/gzip"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"
	"time"

	"github.com/getkin/kin-openapi/openapi3"
	"github.com/gin-gonic/gin"
	"github.com/oapi-codegen/runtime"
	strictgin "github.com/oapi-codegen/runtime/strictmiddleware/gin"
)

// Defines values for AgentSource.
const (
	AgentSourceGlobal AgentSource = "global"
	AgentSourceLocal  AgentSource = "local"
)

// Defines values for ApprovalStatus.
const (
	ApprovalStatusApproved ApprovalStatus = "approved"
	ApprovalStatusDenied   ApprovalStatus = "denied"
	ApprovalStatusPending  ApprovalStatus = "pending"
)

// Defines values for ConversationEventApprovalStatus.
const (
	ConversationEventApprovalStatusApproved ConversationEventApprovalStatus = "approved"
	ConversationEventApprovalStatusDenied   ConversationEventApprovalStatus = "denied"
	ConversationEventApprovalStatusPending  ConversationEventApprovalStatus = "pending"
	ConversationEventApprovalStatusResolved ConversationEventApprovalStatus = "resolved"
)

// Defines values for ConversationEventEventType.
const (
	ConversationEventEventTypeMessage    ConversationEventEventType = "message"
	ConversationEventEventTypeSystem     ConversationEventEventType = "system"
	ConversationEventEventTypeThinking   ConversationEventEventType = "thinking"
	ConversationEventEventTypeToolCall   ConversationEventEventType = "tool_call"
	ConversationEventEventTypeToolResult ConversationEventEventType = "tool_result"
)

// Defines values for ConversationEventRole.
const (
	ConversationEventRoleAssistant ConversationEventRole = "assistant"
	ConversationEventRoleSystem    ConversationEventRole = "system"
	ConversationEventRoleUser      ConversationEventRole = "user"
)

// Defines values for CreateSessionRequestModel.
const (
	Haiku  CreateSessionRequestModel = "haiku"
	Opus   CreateSessionRequestModel = "opus"
	Sonnet CreateSessionRequestModel = "sonnet"
)

// Defines values for DecideApprovalRequestDecision.
const (
	Approve DecideApprovalRequestDecision = "approve"
	Deny    DecideApprovalRequestDecision = "deny"
)

// Defines values for EventType.
const (
	ApprovalResolved       EventType = "approval_resolved"
	ConversationUpdated    EventType = "conversation_updated"
	NewApproval            EventType = "new_approval"
	SessionSettingsChanged EventType = "session_settings_changed"
	SessionStatusChanged   EventType = "session_status_changed"
)

// Defines values for HealthResponseStatus.
const (
	Degraded HealthResponseStatus = "degraded"
	Ok       HealthResponseStatus = "ok"
)

// Defines values for InterruptSessionResponseDataStatus.
const (
	InterruptSessionResponseDataStatusInterrupting InterruptSessionResponseDataStatus = "interrupting"
)

// Defines values for SessionStatus.
const (
	SessionStatusCompleted    SessionStatus = "completed"
	SessionStatusDiscarded    SessionStatus = "discarded"
	SessionStatusDraft        SessionStatus = "draft"
	SessionStatusFailed       SessionStatus = "failed"
	SessionStatusInterrupted  SessionStatus = "interrupted"
	SessionStatusInterrupting SessionStatus = "interrupting"
	SessionStatusRunning      SessionStatus = "running"
	SessionStatusStarting     SessionStatus = "starting"
	SessionStatusWaitingInput SessionStatus = "waiting_input"
)

// Defines values for SlashCommandSource.
const (
	SlashCommandSourceGlobal SlashCommandSource = "global"
	SlashCommandSourceLocal  SlashCommandSource = "local"
)

// Defines values for ListSessionsParamsFilter.
const (
	Archived ListSessionsParamsFilter = "archived"
	Draft    ListSessionsParamsFilter = "draft"
	Normal   ListSessionsParamsFilter = "normal"
)

// Agent defines model for Agent.
type Agent struct {
	// Description Optional description from YAML frontmatter
	Description *string `json:"description,omitempty"`

	// MentionText Text to use for mentions
	MentionText string `json:"mentionText"`

	// Name Agent name from YAML frontmatter
	Name string `json:"name"`

	// Source Whether agent is from local or global directory
	Source AgentSource `json:"source"`
}

// AgentSource Whether agent is from local or global directory
type AgentSource string

// Approval defines model for Approval.
type Approval struct {
	// Comment Approver's comment
	Comment *string `json:"comment,omitempty"`

	// CreatedAt Creation timestamp
	CreatedAt time.Time `json:"created_at"`

	// Id Unique approval identifier
	Id string `json:"id"`

	// RespondedAt Response timestamp
	RespondedAt *time.Time `json:"responded_at"`

	// RunId Associated run ID
	RunId string `json:"run_id"`

	// SessionId Associated session ID
	SessionId string `json:"session_id"`

	// Status Current status of the approval
	Status ApprovalStatus `json:"status"`

	// ToolInput Tool input parameters
	ToolInput map[string]interface{} `json:"tool_input"`

	// ToolName Tool requesting approval
	ToolName string `json:"tool_name"`
}

// ApprovalResponse defines model for ApprovalResponse.
type ApprovalResponse struct {
	Data Approval `json:"data"`
}

// ApprovalStatus Current status of the approval
type ApprovalStatus string

// ApprovalsResponse defines model for ApprovalsResponse.
type ApprovalsResponse struct {
	Data []Approval `json:"data"`
}

// BulkArchiveRequest defines model for BulkArchiveRequest.
type BulkArchiveRequest struct {
	// Archived True to archive, false to unarchive
	Archived bool `json:"archived"`

	// SessionIds Sessions to archive/unarchive
	SessionIds []string `json:"session_ids"`
}

// BulkArchiveResponse defines model for BulkArchiveResponse.
type BulkArchiveResponse struct {
	Data struct {
		// FailedSessions Sessions that failed to update
		FailedSessions *[]string `json:"failed_sessions,omitempty"`
		Success        bool      `json:"success"`
	} `json:"data"`
}

// BulkRestoreDraftsRequest defines model for BulkRestoreDraftsRequest.
type BulkRestoreDraftsRequest struct {
	// SessionIds Draft sessions to restore from discarded status
	SessionIds []string `json:"session_ids"`
}

// BulkRestoreDraftsResponse defines model for BulkRestoreDraftsResponse.
type BulkRestoreDraftsResponse struct {
	Data struct {
		// FailedSessions Sessions that failed to restore
		FailedSessions *[]string `json:"failed_sessions,omitempty"`
		Success        bool      `json:"success"`
	} `json:"data"`
}

// ConfigResponse defines model for ConfigResponse.
type ConfigResponse struct {
	// ClaudeAvailable Whether Claude is available at the configured path
	ClaudeAvailable bool `json:"claude_available"`

	// ClaudeDetectedPath Automatically detected Claude path (may differ from configured)
	ClaudeDetectedPath *string `json:"claude_detected_path,omitempty"`

	// ClaudePath Currently configured Claude path
	ClaudePath string `json:"claude_path"`
}

// ContinueSessionRequest defines model for ContinueSessionRequest.
type ContinueSessionRequest struct {
	// AllowedTools Allowed tools list
	AllowedTools *[]string `json:"allowed_tools,omitempty"`

	// AppendSystemPrompt Append to system prompt
	AppendSystemPrompt *string `json:"append_system_prompt,omitempty"`

	// CustomInstructions Custom instructions
	CustomInstructions *string `json:"custom_instructions,omitempty"`

	// DisallowedTools Disallowed tools list
	DisallowedTools *[]string `json:"disallowed_tools,omitempty"`

	// MaxTurns Max conversation turns
	MaxTurns  *int       `json:"max_turns,omitempty"`
	McpConfig *MCPConfig `json:"mcp_config,omitempty"`

	// PermissionPromptTool MCP tool for permissions
	PermissionPromptTool *string `json:"permission_prompt_tool,omitempty"`

	// Query New query to continue with
	Query string `json:"query"`

	// SystemPrompt Override system prompt
	SystemPrompt *string `json:"system_prompt,omitempty"`
}

// ContinueSessionResponse defines model for ContinueSessionResponse.
type ContinueSessionResponse struct {
	Data struct {
		ClaudeSessionId string `json:"claude_session_id"`
		ParentSessionId string `json:"parent_session_id"`
		RunId           string `json:"run_id"`
		SessionId       string `json:"session_id"`
	} `json:"data"`
}

// ConversationEvent defines model for ConversationEvent.
type ConversationEvent struct {
	// ApprovalId Associated approval ID
	ApprovalId *string `json:"approval_id"`

	// ApprovalStatus Approval status for tool calls
	ApprovalStatus  *ConversationEventApprovalStatus `json:"approval_status"`
	ClaudeSessionId *string                          `json:"claude_session_id,omitempty"`

	// Content Message content
	Content   *string   `json:"content,omitempty"`
	CreatedAt time.Time `json:"created_at"`

	// EventType Type of conversation event
	EventType ConversationEventEventType `json:"event_type"`
	Id        int64                      `json:"id"`

	// IsCompleted Whether tool call has received result
	IsCompleted *bool `json:"is_completed,omitempty"`

	// ParentToolUseId Parent tool use ID for nested calls
	ParentToolUseId *string `json:"parent_tool_use_id,omitempty"`

	// Role Message role (for message events)
	Role *ConversationEventRole `json:"role,omitempty"`

	// Sequence Sequence number in conversation
	Sequence  int    `json:"sequence"`
	SessionId string `json:"session_id"`

	// ToolId Tool invocation ID (for tool events)
	ToolId *string `json:"tool_id,omitempty"`

	// ToolInputJson JSON string of tool input (for tool_call events)
	ToolInputJson *string `json:"tool_input_json,omitempty"`

	// ToolName Tool name (for tool_call events)
	ToolName *string `json:"tool_name,omitempty"`

	// ToolResultContent Tool result content
	ToolResultContent *string `json:"tool_result_content,omitempty"`

	// ToolResultForId Tool call ID this result is for
	ToolResultForId *string `json:"tool_result_for_id,omitempty"`
}

// ConversationEventApprovalStatus Approval status for tool calls
type ConversationEventApprovalStatus string

// ConversationEventEventType Type of conversation event
type ConversationEventEventType string

// ConversationEventRole Message role (for message events)
type ConversationEventRole string

// ConversationResponse defines model for ConversationResponse.
type ConversationResponse struct {
	Data []ConversationEvent `json:"data"`
}

// CreateApprovalRequest defines model for CreateApprovalRequest.
type CreateApprovalRequest struct {
	// RunId Run ID for the approval
	RunId string `json:"run_id"`

	// ToolInput Tool input parameters
	ToolInput map[string]interface{} `json:"tool_input"`

	// ToolName Name of the tool requesting approval
	ToolName string `json:"tool_name"`
}

// CreateApprovalResponse defines model for CreateApprovalResponse.
type CreateApprovalResponse struct {
	Data struct {
		// ApprovalId Created approval ID
		ApprovalId string `json:"approval_id"`
	} `json:"data"`
}

// CreateSessionRequest defines model for CreateSessionRequest.
type CreateSessionRequest struct {
	// AdditionalDirectories Additional directories Claude can access
	AdditionalDirectories *[]string `json:"additional_directories,omitempty"`

	// AllowedTools Whitelist of allowed tools
	AllowedTools *[]string `json:"allowed_tools,omitempty"`

	// AppendSystemPrompt Text to append to system prompt
	AppendSystemPrompt *string `json:"append_system_prompt,omitempty"`

	// AutoAcceptEdits Enable auto-accept for edit tools
	AutoAcceptEdits *bool `json:"auto_accept_edits,omitempty"`

	// CreateDirectoryIfNotExists Create the working directory if it does not exist
	CreateDirectoryIfNotExists *bool `json:"createDirectoryIfNotExists,omitempty"`

	// CustomInstructions Custom instructions for Claude
	CustomInstructions *string `json:"custom_instructions,omitempty"`

	// DangerouslySkipPermissions Launch session with dangerously skip permissions enabled
	DangerouslySkipPermissions *bool `json:"dangerously_skip_permissions,omitempty"`

	// DangerouslySkipPermissionsTimeout Optional default timeout in milliseconds for dangerously skip permissions
	DangerouslySkipPermissionsTimeout *int64 `json:"dangerously_skip_permissions_timeout"`

	// DisallowedTools Blacklist of disallowed tools
	DisallowedTools *[]string `json:"disallowed_tools,omitempty"`

	// Draft Create session in draft state without launching Claude
	Draft *bool `json:"draft,omitempty"`

	// MaxTurns Maximum conversation turns
	MaxTurns  *int       `json:"max_turns,omitempty"`
	McpConfig *MCPConfig `json:"mcp_config,omitempty"`

	// Model Model to use for the session
	Model *CreateSessionRequestModel `json:"model,omitempty"`

	// PermissionPromptTool MCP tool for permission prompts
	PermissionPromptTool *string `json:"permission_prompt_tool,omitempty"`

	// ProxyApiKey API key for proxy authentication
	ProxyApiKey *string `json:"proxy_api_key,omitempty"`

	// ProxyBaseUrl Base URL for proxy service
	ProxyBaseUrl *string `json:"proxy_base_url,omitempty"`

	// ProxyEnabled Enable proxy routing for this session
	ProxyEnabled *bool `json:"proxy_enabled,omitempty"`

	// ProxyModelOverride Model identifier for proxy routing
	ProxyModelOverride *string `json:"proxy_model_override,omitempty"`

	// Query Initial query for Claude
	Query string `json:"query"`

	// SystemPrompt Override system prompt
	SystemPrompt *string `json:"system_prompt,omitempty"`

	// Title Optional title for the session
	Title *string `json:"title,omitempty"`

	// Verbose Enable verbose output
	Verbose *bool `json:"verbose,omitempty"`

	// WorkingDir Working directory for the session
	WorkingDir *string `json:"working_dir,omitempty"`
}

// CreateSessionRequestModel Model to use for the session
type CreateSessionRequestModel string

// CreateSessionResponse defines model for CreateSessionResponse.
type CreateSessionResponse struct {
	Data struct {
		// RunId Created run ID
		RunId string `json:"run_id"`

		// SessionId Created session ID
		SessionId string `json:"session_id"`
	} `json:"data"`
}

// DebugInfoResponse defines model for DebugInfoResponse.
type DebugInfoResponse struct {
	// CliCommand CLI command configured for MCP servers
	CliCommand string `json:"cli_command"`

	// LastModified Last modification time of the database file
	LastModified *time.Time `json:"last_modified,omitempty"`

	// Path Path to the SQLite database file
	Path string `json:"path"`

	// Size Size of the database file in bytes
	Size int64 `json:"size"`

	// Stats Database statistics
	Stats map[string]int64 `json:"stats"`

	// TableCount Number of tables in the database
	TableCount int `json:"table_count"`
}

// DecideApprovalRequest defines model for DecideApprovalRequest.
type DecideApprovalRequest struct {
	// Comment Optional comment (required for deny)
	Comment *string `json:"comment,omitempty"`

	// Decision Approval decision
	Decision DecideApprovalRequestDecision `json:"decision"`
}

// DecideApprovalRequestDecision Approval decision
type DecideApprovalRequestDecision string

// DecideApprovalResponse defines model for DecideApprovalResponse.
type DecideApprovalResponse struct {
	Data struct {
		// Error Error message if failed
		Error   *string `json:"error,omitempty"`
		Success bool    `json:"success"`
	} `json:"data"`
}

// DirectoryNotFoundResponse defines model for DirectoryNotFoundResponse.
type DirectoryNotFoundResponse struct {
	// Error Error code
	Error string `json:"error"`

	// Message Human-readable error message
	Message string `json:"message"`

	// Path The directory path that does not exist
	Path string `json:"path"`

	// RequiresCreation Indicates that directory creation is required
	RequiresCreation bool `json:"requiresCreation"`
}

// ErrorDetail defines model for ErrorDetail.
type ErrorDetail struct {
	// Code Error code (e.g., HLD-101)
	Code string `json:"code"`

	// Details Additional error context
	Details *map[string]interface{} `json:"details,omitempty"`

	// Message Human-readable error message
	Message string `json:"message"`
}

// ErrorResponse defines model for ErrorResponse.
type ErrorResponse struct {
	Error ErrorDetail `json:"error"`
}

// Event defines model for Event.
type Event struct {
	// Data Event-specific data
	Data map[string]interface{} `json:"data"`

	// Timestamp Event timestamp
	Timestamp time.Time `json:"timestamp"`

	// Type Type of system event
	Type EventType `json:"type"`
}

// EventType Type of system event
type EventType string

// FileMatch defines model for FileMatch.
type FileMatch struct {
	// DisplayPath Relative path for display (relative to first search path if applicable)
	DisplayPath string `json:"displayPath"`

	// IsDirectory True if this is a directory, false for files
	IsDirectory bool `json:"isDirectory"`

	// MatchedIndexes Character positions of matched query characters
	MatchedIndexes []int `json:"matchedIndexes"`

	// Path Absolute path to matched file or folder
	Path string `json:"path"`

	// Score Match quality score (higher is better)
	Score int `json:"score"`
}

// FileSnapshot defines model for FileSnapshot.
type FileSnapshot struct {
	// Content File content at snapshot time
	Content   string    `json:"content"`
	CreatedAt time.Time `json:"created_at"`

	// FilePath Path to the file
	FilePath string `json:"file_path"`

	// ToolId Tool invocation that created snapshot
	ToolId string `json:"tool_id"`
}

// FuzzySearchFilesRequest defines model for FuzzySearchFilesRequest.
type FuzzySearchFilesRequest struct {
	// FilesOnly Return only files, exclude directories
	FilesOnly *bool `json:"filesOnly,omitempty"`

	// Limit Maximum number of results to return
	Limit *int `json:"limit,omitempty"`

	// Paths Directory paths to search within
	Paths []string `json:"paths"`

	// Query Fuzzy search pattern
	Query string `json:"query"`

	// RespectGitignore Filter out files/folders matching .gitignore patterns
	RespectGitignore *bool `json:"respectGitignore,omitempty"`
}

// FuzzySearchFilesResponse defines model for FuzzySearchFilesResponse.
type FuzzySearchFilesResponse struct {
	Metadata SearchMetadata `json:"metadata"`

	// Results Matched files/folders sorted by relevance
	Results []FileMatch `json:"results"`
}

// HealthResponse defines model for HealthResponse.
type HealthResponse struct {
	Dependencies *struct {
		Claude *struct {
			// Available Whether Claude binary is available
			Available bool `json:"available"`

			// Error Error message if Claude is not available
			Error *string `json:"error"`

			// Path Path to Claude binary if available
			Path *string `json:"path"`

			// Version Claude binary version (e.g., "1.0.110")
			Version *string `json:"version"`

			// VersionError Error message if version check failed
			VersionError *string `json:"version_error"`
		} `json:"claude,omitempty"`
	} `json:"dependencies,omitempty"`
	Status  HealthResponseStatus `json:"status"`
	Version string               `json:"version"`
}

// HealthResponseStatus defines model for HealthResponse.Status.
type HealthResponseStatus string

// InterruptSessionResponse defines model for InterruptSessionResponse.
type InterruptSessionResponse struct {
	Data struct {
		SessionId string                             `json:"session_id"`
		Status    InterruptSessionResponseDataStatus `json:"status"`
		Success   bool                               `json:"success"`
	} `json:"data"`
}

// InterruptSessionResponseDataStatus defines model for InterruptSessionResponse.Data.Status.
type InterruptSessionResponseDataStatus string

// MCPConfig defines model for MCPConfig.
type MCPConfig struct {
	// McpServers Map of server name to configuration
	McpServers *map[string]MCPServer `json:"mcpServers,omitempty"`
}

// MCPServer defines model for MCPServer.
type MCPServer struct {
	// Args Command arguments (for stdio servers)
	Args *[]string `json:"args,omitempty"`

	// Command Command to execute (for stdio servers)
	Command *string `json:"command,omitempty"`

	// Env Environment variables (for stdio servers)
	Env *map[string]string `json:"env,omitempty"`

	// Headers HTTP headers to include (for HTTP servers)
	Headers *map[string]string `json:"headers,omitempty"`

	// Type Server type (http for HTTP servers, omit for stdio)
	Type *string `json:"type,omitempty"`

	// Url HTTP endpoint URL (for HTTP servers)
	Url *string `json:"url,omitempty"`
}

// RecentPath defines model for RecentPath.
type RecentPath struct {
	// LastUsed Last time this path was used
	LastUsed time.Time `json:"last_used"`

	// Path Directory path
	Path string `json:"path"`

	// UsageCount Number of times used
	UsageCount int `json:"usage_count"`
}

// RecentPathsResponse defines model for RecentPathsResponse.
type RecentPathsResponse struct {
	Data []RecentPath `json:"data"`
}

// SearchMetadata defines model for SearchMetadata.
type SearchMetadata struct {
	// DurationMs Search duration in milliseconds
	DurationMs int `json:"durationMs"`

	// TimedOut True if search was terminated due to timeout
	TimedOut bool `json:"timedOut"`

	// TotalMatches Total matches found before applying limit
	TotalMatches int `json:"totalMatches"`

	// TotalScanned Total number of files/folders scanned
	TotalScanned int `json:"totalScanned"`
}

// Session defines model for Session.
type Session struct {
	// AdditionalDirectories Additional directories Claude can access
	AdditionalDirectories *[]string `json:"additional_directories,omitempty"`

	// Archived Whether session is archived
	Archived *bool `json:"archived,omitempty"`

	// AutoAcceptEdits Whether edit tools are auto-accepted
	AutoAcceptEdits *bool `json:"auto_accept_edits,omitempty"`

	// CacheCreationInputTokens Number of cache creation input tokens
	CacheCreationInputTokens *int `json:"cache_creation_input_tokens"`

	// CacheReadInputTokens Number of cache read input tokens
	CacheReadInputTokens *int `json:"cache_read_input_tokens"`

	// ClaudeSessionId Claude's internal session ID
	ClaudeSessionId *string `json:"claude_session_id,omitempty"`

	// CompletedAt Session completion timestamp
	CompletedAt *time.Time `json:"completed_at"`

	// ContextLimit Context window limit for the model
	ContextLimit *int `json:"context_limit"`

	// CostUsd Total cost in USD
	CostUsd *float32 `json:"cost_usd"`

	// CreatedAt Session creation timestamp
	CreatedAt time.Time `json:"created_at"`

	// DangerouslySkipPermissions When true, all tool calls are automatically approved without user consent
	DangerouslySkipPermissions *bool `json:"dangerously_skip_permissions,omitempty"`

	// DangerouslySkipPermissionsExpiresAt ISO timestamp when dangerously skip permissions mode expires (optional)
	DangerouslySkipPermissionsExpiresAt *time.Time `json:"dangerously_skip_permissions_expires_at"`

	// DurationMs Session duration in milliseconds
	DurationMs *int `json:"duration_ms"`

	// EditorState JSON blob of editor state for draft sessions
	EditorState *string `json:"editor_state"`

	// EffectiveContextTokens Total tokens counting toward context window limit
	EffectiveContextTokens *int `json:"effective_context_tokens"`

	// ErrorMessage Error message if session failed
	ErrorMessage *string `json:"error_message,omitempty"`

	// Id Unique session identifier
	Id string `json:"id"`

	// InputTokens Number of input tokens
	InputTokens *int `json:"input_tokens"`

	// LastActivityAt Last activity timestamp
	LastActivityAt time.Time `json:"last_activity_at"`

	// Model Model used for this session
	Model *string `json:"model,omitempty"`

	// ModelId Full model identifier
	ModelId *string `json:"model_id,omitempty"`

	// OutputTokens Number of output tokens
	OutputTokens *int `json:"output_tokens"`

	// ParentSessionId Parent session ID if this is a forked session
	ParentSessionId *string `json:"parent_session_id,omitempty"`

	// ProxyBaseUrl Base URL of the proxy server
	ProxyBaseUrl *string `json:"proxy_base_url,omitempty"`

	// ProxyEnabled Whether proxy is enabled for this session
	ProxyEnabled *bool `json:"proxy_enabled,omitempty"`

	// ProxyModelOverride Model to use with the proxy
	ProxyModelOverride *string `json:"proxy_model_override,omitempty"`

	// Query Initial query that started the session
	Query string `json:"query"`

	// RunId Unique run identifier
	RunId string `json:"run_id"`

	// Status Current status of the session
	Status SessionStatus `json:"status"`

	// Summary AI-generated summary of the session
	Summary *string `json:"summary,omitempty"`

	// Title User-editable session title
	Title *string `json:"title,omitempty"`

	// WorkingDir Working directory for the session
	WorkingDir *string `json:"working_dir,omitempty"`
}

// SessionResponse defines model for SessionResponse.
type SessionResponse struct {
	Data Session `json:"data"`
}

// SessionSearchResponse defines model for SessionSearchResponse.
type SessionSearchResponse struct {
	Data []Session `json:"data"`
}

// SessionStatus Current status of the session
type SessionStatus string

// SessionsResponse defines model for SessionsResponse.
type SessionsResponse struct {
	// Counts Session counts by category
	Counts *struct {
		// Archived Number of archived sessions
		Archived *int `json:"archived,omitempty"`

		// Draft Number of draft sessions
		Draft *int `json:"draft,omitempty"`

		// Normal Number of normal (non-archived, non-draft) sessions
		Normal *int `json:"normal,omitempty"`
	} `json:"counts,omitempty"`
	Data []Session `json:"data"`
}

// SlashCommand defines model for SlashCommand.
type SlashCommand struct {
	// Name Command name including slash prefix
	Name string `json:"name"`

	// Source Source of the command - local (repo) or global (user home)
	Source SlashCommandSource `json:"source"`
}

// SlashCommandSource Source of the command - local (repo) or global (user home)
type SlashCommandSource string

// SlashCommandsResponse defines model for SlashCommandsResponse.
type SlashCommandsResponse struct {
	Data []SlashCommand `json:"data"`
}

// SnapshotsResponse defines model for SnapshotsResponse.
type SnapshotsResponse struct {
	Data []FileSnapshot `json:"data"`
}

// UpdateConfigRequest defines model for UpdateConfigRequest.
type UpdateConfigRequest struct {
	// ClaudePath Path to Claude binary (empty string for auto-detection)
	ClaudePath *string `json:"claude_path"`
}

// UpdateSessionRequest defines model for UpdateSessionRequest.
type UpdateSessionRequest struct {
	// AdditionalDirectories Update additional directories Claude can access
	AdditionalDirectories *[]string `json:"additional_directories,omitempty"`

	// Archived Archive/unarchive the session
	Archived *bool `json:"archived,omitempty"`

	// AutoAcceptEdits Enable/disable auto-accept for edit tools
	AutoAcceptEdits *bool `json:"auto_accept_edits,omitempty"`

	// DangerouslySkipPermissions Enable or disable dangerously skip permissions mode
	DangerouslySkipPermissions *bool `json:"dangerously_skip_permissions,omitempty"`

	// DangerouslySkipPermissionsTimeoutMs Optional timeout in milliseconds for dangerously skip permissions mode
	DangerouslySkipPermissionsTimeoutMs *int64 `json:"dangerously_skip_permissions_timeout_ms"`

	// EditorState JSON blob of editor state for draft sessions
	EditorState *string `json:"editor_state,omitempty"`

	// Model Model to use (opus, sonnet, or empty for default)
	Model *string `json:"model,omitempty"`

	// ModelId Full model identifier
	ModelId *string `json:"model_id,omitempty"`

	// ProxyApiKey API key for proxy authentication
	ProxyApiKey *string `json:"proxy_api_key,omitempty"`

	// ProxyBaseUrl Base URL for proxy service
	ProxyBaseUrl *string `json:"proxy_base_url,omitempty"`

	// ProxyEnabled Enable proxy routing for this session
	ProxyEnabled *bool `json:"proxy_enabled,omitempty"`

	// ProxyModelOverride Model identifier for proxy routing
	ProxyModelOverride *string `json:"proxy_model_override,omitempty"`

	// Status Current status of the session
	Status *SessionStatus `json:"status,omitempty"`

	// Title Update session title
	Title *string `json:"title,omitempty"`

	// WorkingDir Update the working directory for the session
	WorkingDir *string `json:"working_dir,omitempty"`
}

// UpdateUserSettingsRequest defines model for UpdateUserSettingsRequest.
type UpdateUserSettingsRequest struct {
	// AdvancedProviders Enable or disable advanced provider options
	AdvancedProviders *bool `json:"advanced_providers,omitempty"`

	// OptInTelemetry Opt-in or opt-out of performance and error reporting
	OptInTelemetry *bool `json:"opt_in_telemetry,omitempty"`
}

// UserSettings defines model for UserSettings.
type UserSettings struct {
	// AdvancedProviders Enable advanced provider options like OpenRouter
	AdvancedProviders bool      `json:"advanced_providers"`
	CreatedAt         time.Time `json:"created_at"`

	// OptInTelemetry Opt-in for performance and error reporting
	OptInTelemetry *bool     `json:"opt_in_telemetry,omitempty"`
	UpdatedAt      time.Time `json:"updated_at"`
}

// UserSettingsResponse defines model for UserSettingsResponse.
type UserSettingsResponse struct {
	Data UserSettings `json:"data"`
}

// ValidateDirectoryRequest defines model for ValidateDirectoryRequest.
type ValidateDirectoryRequest struct {
	// Path Directory path to validate
	Path string `json:"path"`
}

// ValidateDirectoryResponse defines model for ValidateDirectoryResponse.
type ValidateDirectoryResponse struct {
	// CanCreate Whether the directory can be created (only set if exists is false)
	CanCreate *bool `json:"canCreate,omitempty"`

	// Error Error message if path validation failed
	Error *string `json:"error,omitempty"`

	// Exists Whether the directory exists
	Exists bool `json:"exists"`

	// ExpandedPath The expanded path with ~ resolved
	ExpandedPath string `json:"expandedPath"`

	// IsDirectory Whether the path is a directory (only set if exists is true)
	IsDirectory *bool `json:"isDirectory,omitempty"`
}

// ApprovalId defines model for approvalId.
type ApprovalId = string

// SessionId defines model for sessionId.
type SessionId = string

// BadRequest defines model for BadRequest.
type BadRequest = ErrorResponse

// InternalError defines model for InternalError.
type InternalError = ErrorResponse

// NotFound defines model for NotFound.
type NotFound = ErrorResponse

// DiscoverAgentsJSONBody defines parameters for DiscoverAgents.
type DiscoverAgentsJSONBody struct {
	// WorkingDir Session working directory for local agent discovery
	WorkingDir string `json:"workingDir"`
}

// ListApprovalsParams defines parameters for ListApprovals.
type ListApprovalsParams struct {
	// SessionId Filter by session ID
	SessionId *string `form:"sessionId,omitempty" json:"sessionId,omitempty"`
}

// CreateDirectoryJSONBody defines parameters for CreateDirectory.
type CreateDirectoryJSONBody struct {
	// Path The directory path to create
	Path string `json:"path"`
}

// GetRecentPathsParams defines parameters for GetRecentPaths.
type GetRecentPathsParams struct {
	// Limit Maximum number of paths to return
	Limit *int `form:"limit,omitempty" json:"limit,omitempty"`
}

// ListSessionsParams defines parameters for ListSessions.
type ListSessionsParams struct {
	// LeavesOnly Return only leaf sessions (sessions with no children)
	LeavesOnly *bool `form:"leavesOnly,omitempty" json:"leavesOnly,omitempty"`

	// Filter Filter sessions by type
	Filter *ListSessionsParamsFilter `form:"filter,omitempty" json:"filter,omitempty"`
}

// ListSessionsParamsFilter defines parameters for ListSessions.
type ListSessionsParamsFilter string

// SearchSessionsParams defines parameters for SearchSessions.
type SearchSessionsParams struct {
	// Query Search query for title matching (uses SQL LIKE)
	Query *string `form:"query,omitempty" json:"query,omitempty"`

	// Limit Maximum number of results to return
	Limit *int `form:"limit,omitempty" json:"limit,omitempty"`
}

// LaunchDraftSessionJSONBody defines parameters for LaunchDraftSession.
type LaunchDraftSessionJSONBody struct {
	// CreateDirectoryIfNotExists Create working directory if it doesn't exist
	CreateDirectoryIfNotExists *bool `json:"createDirectoryIfNotExists,omitempty"`

	// Prompt Initial prompt to send to Claude
	Prompt string `json:"prompt"`
}

// GetSlashCommandsParams defines parameters for GetSlashCommands.
type GetSlashCommandsParams struct {
	// WorkingDir Working directory to search for commands
	WorkingDir string `form:"working_dir" json:"working_dir"`

	// Query Fuzzy search query
	Query *string `form:"query,omitempty" json:"query,omitempty"`
}

// DiscoverAgentsJSONRequestBody defines body for DiscoverAgents for application/json ContentType.
type DiscoverAgentsJSONRequestBody DiscoverAgentsJSONBody

// CreateApprovalJSONRequestBody defines body for CreateApproval for application/json ContentType.
type CreateApprovalJSONRequestBody = CreateApprovalRequest

// DecideApprovalJSONRequestBody defines body for DecideApproval for application/json ContentType.
type DecideApprovalJSONRequestBody = DecideApprovalRequest

// UpdateConfigJSONRequestBody defines body for UpdateConfig for application/json ContentType.
type UpdateConfigJSONRequestBody = UpdateConfigRequest

// CreateDirectoryJSONRequestBody defines body for CreateDirectory for application/json ContentType.
type CreateDirectoryJSONRequestBody CreateDirectoryJSONBody

// FuzzySearchFilesJSONRequestBody defines body for FuzzySearchFiles for application/json ContentType.
type FuzzySearchFilesJSONRequestBody = FuzzySearchFilesRequest

// CreateSessionJSONRequestBody defines body for CreateSession for application/json ContentType.
type CreateSessionJSONRequestBody = CreateSessionRequest

// BulkArchiveSessionsJSONRequestBody defines body for BulkArchiveSessions for application/json ContentType.
type BulkArchiveSessionsJSONRequestBody = BulkArchiveRequest

// BulkRestoreDraftsJSONRequestBody defines body for BulkRestoreDrafts for application/json ContentType.
type BulkRestoreDraftsJSONRequestBody = BulkRestoreDraftsRequest

// UpdateSessionJSONRequestBody defines body for UpdateSession for application/json ContentType.
type UpdateSessionJSONRequestBody = UpdateSessionRequest

// ContinueSessionJSONRequestBody defines body for ContinueSession for application/json ContentType.
type ContinueSessionJSONRequestBody = ContinueSessionRequest

// LaunchDraftSessionJSONRequestBody defines body for LaunchDraftSession for application/json ContentType.
type LaunchDraftSessionJSONRequestBody LaunchDraftSessionJSONBody

// UpdateUserSettingsJSONRequestBody defines body for UpdateUserSettings for application/json ContentType.
type UpdateUserSettingsJSONRequestBody = UpdateUserSettingsRequest

// ValidateDirectoryJSONRequestBody defines body for ValidateDirectory for application/json ContentType.
type ValidateDirectoryJSONRequestBody = ValidateDirectoryRequest

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Discover available agents
	// (POST /agents/discover)
	DiscoverAgents(c *gin.Context)
	// List approval requests
	// (GET /approvals)
	ListApprovals(c *gin.Context, params ListApprovalsParams)
	// Create approval request
	// (POST /approvals)
	CreateApproval(c *gin.Context)
	// Get approval details
	// (GET /approvals/{id})
	GetApproval(c *gin.Context, id ApprovalId)
	// Decide on approval request
	// (POST /approvals/{id}/decide)
	DecideApproval(c *gin.Context, id ApprovalId)
	// Get daemon configuration
	// (GET /config)
	GetConfig(c *gin.Context)
	// Update daemon configuration
	// (PATCH /config)
	UpdateConfig(c *gin.Context)
	// Get debug information
	// (GET /debug-info)
	GetDebugInfo(c *gin.Context)
	// Create a directory
	// (POST /directories)
	CreateDirectory(c *gin.Context)
	// Fuzzy search for files and folders
	// (POST /fuzzy-search/files)
	FuzzySearchFiles(c *gin.Context)
	// Health check
	// (GET /health)
	GetHealth(c *gin.Context)
	// Get recent working directories
	// (GET /recent-paths)
	GetRecentPaths(c *gin.Context, params GetRecentPathsParams)
	// List sessions
	// (GET /sessions)
	ListSessions(c *gin.Context, params ListSessionsParams)
	// Launch a new session
	// (POST /sessions)
	CreateSession(c *gin.Context)
	// Bulk archive/unarchive sessions
	// (POST /sessions/archive)
	BulkArchiveSessions(c *gin.Context)
	// Restore multiple discarded draft sessions
	// (POST /sessions/restore)
	BulkRestoreDrafts(c *gin.Context)
	// Search sessions by title
	// (GET /sessions/search)
	SearchSessions(c *gin.Context, params SearchSessionsParams)
	// Get session details
	// (GET /sessions/{id})
	GetSession(c *gin.Context, id SessionId)
	// Update session settings
	// (PATCH /sessions/{id})
	UpdateSession(c *gin.Context, id SessionId)
	// Continue or fork a session
	// (POST /sessions/{id}/continue)
	ContinueSession(c *gin.Context, id SessionId)
	// Permanently delete an empty draft session
	// (DELETE /sessions/{id}/hard-delete-empty)
	HardDeleteEmptyDraftSession(c *gin.Context, id SessionId)
	// Interrupt a running session
	// (POST /sessions/{id}/interrupt)
	InterruptSession(c *gin.Context, id SessionId)
	// Delete a draft session
	// (DELETE /sessions/{id}/launch)
	DeleteDraftSession(c *gin.Context, id SessionId)
	// Launch a draft session
	// (POST /sessions/{id}/launch)
	LaunchDraftSession(c *gin.Context, id SessionId)
	// Get conversation messages
	// (GET /sessions/{id}/messages)
	GetSessionMessages(c *gin.Context, id SessionId)
	// Get file snapshots
	// (GET /sessions/{id}/snapshots)
	GetSessionSnapshots(c *gin.Context, id SessionId)
	// Get available slash commands
	// (GET /slash-commands)
	GetSlashCommands(c *gin.Context, params GetSlashCommandsParams)
	// Get user settings
	// (GET /user-settings)
	GetUserSettings(c *gin.Context)
	// Update user settings
	// (PATCH /user-settings)
	UpdateUserSettings(c *gin.Context)
	// Validate directory existence
	// (POST /validate-directory)
	ValidateDirectory(c *gin.Context)
}

// ServerInterfaceWrapper converts contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler            ServerInterface
	HandlerMiddlewares []MiddlewareFunc
	ErrorHandler       func(*gin.Context, error, int)
}

type MiddlewareFunc func(c *gin.Context)

// DiscoverAgents operation middleware
func (siw *ServerInterfaceWrapper) DiscoverAgents(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.DiscoverAgents(c)
}

// ListApprovals operation middleware
func (siw *ServerInterfaceWrapper) ListApprovals(c *gin.Context) {

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params ListApprovalsParams

	// ------------- Optional query parameter "sessionId" -------------

	err = runtime.BindQueryParameter("form", true, false, "sessionId", c.Request.URL.Query(), &params.SessionId)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter sessionId: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.ListApprovals(c, params)
}

// CreateApproval operation middleware
func (siw *ServerInterfaceWrapper) CreateApproval(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.CreateApproval(c)
}

// GetApproval operation middleware
func (siw *ServerInterfaceWrapper) GetApproval(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id ApprovalId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetApproval(c, id)
}

// DecideApproval operation middleware
func (siw *ServerInterfaceWrapper) DecideApproval(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id ApprovalId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.DecideApproval(c, id)
}

// GetConfig operation middleware
func (siw *ServerInterfaceWrapper) GetConfig(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetConfig(c)
}

// UpdateConfig operation middleware
func (siw *ServerInterfaceWrapper) UpdateConfig(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.UpdateConfig(c)
}

// GetDebugInfo operation middleware
func (siw *ServerInterfaceWrapper) GetDebugInfo(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetDebugInfo(c)
}

// CreateDirectory operation middleware
func (siw *ServerInterfaceWrapper) CreateDirectory(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.CreateDirectory(c)
}

// FuzzySearchFiles operation middleware
func (siw *ServerInterfaceWrapper) FuzzySearchFiles(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.FuzzySearchFiles(c)
}

// GetHealth operation middleware
func (siw *ServerInterfaceWrapper) GetHealth(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetHealth(c)
}

// GetRecentPaths operation middleware
func (siw *ServerInterfaceWrapper) GetRecentPaths(c *gin.Context) {

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetRecentPathsParams

	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", c.Request.URL.Query(), &params.Limit)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter limit: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetRecentPaths(c, params)
}

// ListSessions operation middleware
func (siw *ServerInterfaceWrapper) ListSessions(c *gin.Context) {

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params ListSessionsParams

	// ------------- Optional query parameter "leavesOnly" -------------

	err = runtime.BindQueryParameter("form", true, false, "leavesOnly", c.Request.URL.Query(), &params.LeavesOnly)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter leavesOnly: %w", err), http.StatusBadRequest)
		return
	}

	// ------------- Optional query parameter "filter" -------------

	err = runtime.BindQueryParameter("form", true, false, "filter", c.Request.URL.Query(), &params.Filter)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter filter: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.ListSessions(c, params)
}

// CreateSession operation middleware
func (siw *ServerInterfaceWrapper) CreateSession(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.CreateSession(c)
}

// BulkArchiveSessions operation middleware
func (siw *ServerInterfaceWrapper) BulkArchiveSessions(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.BulkArchiveSessions(c)
}

// BulkRestoreDrafts operation middleware
func (siw *ServerInterfaceWrapper) BulkRestoreDrafts(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.BulkRestoreDrafts(c)
}

// SearchSessions operation middleware
func (siw *ServerInterfaceWrapper) SearchSessions(c *gin.Context) {

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params SearchSessionsParams

	// ------------- Optional query parameter "query" -------------

	err = runtime.BindQueryParameter("form", true, false, "query", c.Request.URL.Query(), &params.Query)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter query: %w", err), http.StatusBadRequest)
		return
	}

	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", c.Request.URL.Query(), &params.Limit)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter limit: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.SearchSessions(c, params)
}

// GetSession operation middleware
func (siw *ServerInterfaceWrapper) GetSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetSession(c, id)
}

// UpdateSession operation middleware
func (siw *ServerInterfaceWrapper) UpdateSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.UpdateSession(c, id)
}

// ContinueSession operation middleware
func (siw *ServerInterfaceWrapper) ContinueSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.ContinueSession(c, id)
}

// HardDeleteEmptyDraftSession operation middleware
func (siw *ServerInterfaceWrapper) HardDeleteEmptyDraftSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.HardDeleteEmptyDraftSession(c, id)
}

// InterruptSession operation middleware
func (siw *ServerInterfaceWrapper) InterruptSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.InterruptSession(c, id)
}

// DeleteDraftSession operation middleware
func (siw *ServerInterfaceWrapper) DeleteDraftSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.DeleteDraftSession(c, id)
}

// LaunchDraftSession operation middleware
func (siw *ServerInterfaceWrapper) LaunchDraftSession(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.LaunchDraftSession(c, id)
}

// GetSessionMessages operation middleware
func (siw *ServerInterfaceWrapper) GetSessionMessages(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetSessionMessages(c, id)
}

// GetSessionSnapshots operation middleware
func (siw *ServerInterfaceWrapper) GetSessionSnapshots(c *gin.Context) {

	var err error

	// ------------- Path parameter "id" -------------
	var id SessionId

	err = runtime.BindStyledParameterWithOptions("simple", "id", c.Param("id"), &id, runtime.BindStyledParameterOptions{Explode: false, Required: true})
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter id: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetSessionSnapshots(c, id)
}

// GetSlashCommands operation middleware
func (siw *ServerInterfaceWrapper) GetSlashCommands(c *gin.Context) {

	var err error

	// Parameter object where we will unmarshal all parameters from the context
	var params GetSlashCommandsParams

	// ------------- Required query parameter "working_dir" -------------

	if paramValue := c.Query("working_dir"); paramValue != "" {

	} else {
		siw.ErrorHandler(c, fmt.Errorf("Query argument working_dir is required, but not found"), http.StatusBadRequest)
		return
	}

	err = runtime.BindQueryParameter("form", true, true, "working_dir", c.Request.URL.Query(), &params.WorkingDir)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter working_dir: %w", err), http.StatusBadRequest)
		return
	}

	// ------------- Optional query parameter "query" -------------

	err = runtime.BindQueryParameter("form", true, false, "query", c.Request.URL.Query(), &params.Query)
	if err != nil {
		siw.ErrorHandler(c, fmt.Errorf("Invalid format for parameter query: %w", err), http.StatusBadRequest)
		return
	}

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetSlashCommands(c, params)
}

// GetUserSettings operation middleware
func (siw *ServerInterfaceWrapper) GetUserSettings(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.GetUserSettings(c)
}

// UpdateUserSettings operation middleware
func (siw *ServerInterfaceWrapper) UpdateUserSettings(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.UpdateUserSettings(c)
}

// ValidateDirectory operation middleware
func (siw *ServerInterfaceWrapper) ValidateDirectory(c *gin.Context) {

	for _, middleware := range siw.HandlerMiddlewares {
		middleware(c)
		if c.IsAborted() {
			return
		}
	}

	siw.Handler.ValidateDirectory(c)
}

// GinServerOptions provides options for the Gin server.
type GinServerOptions struct {
	BaseURL      string
	Middlewares  []MiddlewareFunc
	ErrorHandler func(*gin.Context, error, int)
}

// RegisterHandlers creates http.Handler with routing matching OpenAPI spec.
func RegisterHandlers(router gin.IRouter, si ServerInterface) {
	RegisterHandlersWithOptions(router, si, GinServerOptions{})
}

// RegisterHandlersWithOptions creates http.Handler with additional options
func RegisterHandlersWithOptions(router gin.IRouter, si ServerInterface, options GinServerOptions) {
	errorHandler := options.ErrorHandler
	if errorHandler == nil {
		errorHandler = func(c *gin.Context, err error, statusCode int) {
			c.JSON(statusCode, gin.H{"msg": err.Error()})
		}
	}

	wrapper := ServerInterfaceWrapper{
		Handler:            si,
		HandlerMiddlewares: options.Middlewares,
		ErrorHandler:       errorHandler,
	}

	router.POST(options.BaseURL+"/agents/discover", wrapper.DiscoverAgents)
	router.GET(options.BaseURL+"/approvals", wrapper.ListApprovals)
	router.POST(options.BaseURL+"/approvals", wrapper.CreateApproval)
	router.GET(options.BaseURL+"/approvals/:id", wrapper.GetApproval)
	router.POST(options.BaseURL+"/approvals/:id/decide", wrapper.DecideApproval)
	router.GET(options.BaseURL+"/config", wrapper.GetConfig)
	router.PATCH(options.BaseURL+"/config", wrapper.UpdateConfig)
	router.GET(options.BaseURL+"/debug-info", wrapper.GetDebugInfo)
	router.POST(options.BaseURL+"/directories", wrapper.CreateDirectory)
	router.POST(options.BaseURL+"/fuzzy-search/files", wrapper.FuzzySearchFiles)
	router.GET(options.BaseURL+"/health", wrapper.GetHealth)
	router.GET(options.BaseURL+"/recent-paths", wrapper.GetRecentPaths)
	router.GET(options.BaseURL+"/sessions", wrapper.ListSessions)
	router.POST(options.BaseURL+"/sessions", wrapper.CreateSession)
	router.POST(options.BaseURL+"/sessions/archive", wrapper.BulkArchiveSessions)
	router.POST(options.BaseURL+"/sessions/restore", wrapper.BulkRestoreDrafts)
	router.GET(options.BaseURL+"/sessions/search", wrapper.SearchSessions)
	router.GET(options.BaseURL+"/sessions/:id", wrapper.GetSession)
	router.PATCH(options.BaseURL+"/sessions/:id", wrapper.UpdateSession)
	router.POST(options.BaseURL+"/sessions/:id/continue", wrapper.ContinueSession)
	router.DELETE(options.BaseURL+"/sessions/:id/hard-delete-empty", wrapper.HardDeleteEmptyDraftSession)
	router.POST(options.BaseURL+"/sessions/:id/interrupt", wrapper.InterruptSession)
	router.DELETE(options.BaseURL+"/sessions/:id/launch", wrapper.DeleteDraftSession)
	router.POST(options.BaseURL+"/sessions/:id/launch", wrapper.LaunchDraftSession)
	router.GET(options.BaseURL+"/sessions/:id/messages", wrapper.GetSessionMessages)
	router.GET(options.BaseURL+"/sessions/:id/snapshots", wrapper.GetSessionSnapshots)
	router.GET(options.BaseURL+"/slash-commands", wrapper.GetSlashCommands)
	router.GET(options.BaseURL+"/user-settings", wrapper.GetUserSettings)
	router.PATCH(options.BaseURL+"/user-settings", wrapper.UpdateUserSettings)
	router.POST(options.BaseURL+"/validate-directory", wrapper.ValidateDirectory)
}

type BadRequestJSONResponse ErrorResponse

type InternalErrorJSONResponse ErrorResponse

type NotFoundJSONResponse ErrorResponse

type DiscoverAgentsRequestObject struct {
	Body *DiscoverAgentsJSONRequestBody
}

type DiscoverAgentsResponseObject interface {
	VisitDiscoverAgentsResponse(w http.ResponseWriter) error
}

type DiscoverAgents200JSONResponse struct {
	Agents []Agent `json:"agents"`
}

func (response DiscoverAgents200JSONResponse) VisitDiscoverAgentsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DiscoverAgents400JSONResponse struct{ BadRequestJSONResponse }

func (response DiscoverAgents400JSONResponse) VisitDiscoverAgentsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DiscoverAgents500JSONResponse struct{ InternalErrorJSONResponse }

func (response DiscoverAgents500JSONResponse) VisitDiscoverAgentsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ListApprovalsRequestObject struct {
	Params ListApprovalsParams
}

type ListApprovalsResponseObject interface {
	VisitListApprovalsResponse(w http.ResponseWriter) error
}

type ListApprovals200JSONResponse ApprovalsResponse

func (response ListApprovals200JSONResponse) VisitListApprovalsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListApprovals500JSONResponse struct{ InternalErrorJSONResponse }

func (response ListApprovals500JSONResponse) VisitListApprovalsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateApprovalRequestObject struct {
	Body *CreateApprovalJSONRequestBody
}

type CreateApprovalResponseObject interface {
	VisitCreateApprovalResponse(w http.ResponseWriter) error
}

type CreateApproval201JSONResponse CreateApprovalResponse

func (response CreateApproval201JSONResponse) VisitCreateApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(201)

	return json.NewEncoder(w).Encode(response)
}

type CreateApproval400JSONResponse struct{ BadRequestJSONResponse }

func (response CreateApproval400JSONResponse) VisitCreateApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type CreateApproval500JSONResponse struct{ InternalErrorJSONResponse }

func (response CreateApproval500JSONResponse) VisitCreateApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetApprovalRequestObject struct {
	Id ApprovalId `json:"id"`
}

type GetApprovalResponseObject interface {
	VisitGetApprovalResponse(w http.ResponseWriter) error
}

type GetApproval200JSONResponse ApprovalResponse

func (response GetApproval200JSONResponse) VisitGetApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetApproval404JSONResponse struct{ NotFoundJSONResponse }

func (response GetApproval404JSONResponse) VisitGetApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetApproval500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetApproval500JSONResponse) VisitGetApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DecideApprovalRequestObject struct {
	Id   ApprovalId `json:"id"`
	Body *DecideApprovalJSONRequestBody
}

type DecideApprovalResponseObject interface {
	VisitDecideApprovalResponse(w http.ResponseWriter) error
}

type DecideApproval200JSONResponse DecideApprovalResponse

func (response DecideApproval200JSONResponse) VisitDecideApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type DecideApproval400JSONResponse ErrorResponse

func (response DecideApproval400JSONResponse) VisitDecideApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DecideApproval404JSONResponse struct{ NotFoundJSONResponse }

func (response DecideApproval404JSONResponse) VisitDecideApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DecideApproval500JSONResponse struct{ InternalErrorJSONResponse }

func (response DecideApproval500JSONResponse) VisitDecideApprovalResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetConfigRequestObject struct {
}

type GetConfigResponseObject interface {
	VisitGetConfigResponse(w http.ResponseWriter) error
}

type GetConfig200JSONResponse ConfigResponse

func (response GetConfig200JSONResponse) VisitGetConfigResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetConfig500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetConfig500JSONResponse) VisitGetConfigResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateConfigRequestObject struct {
	Body *UpdateConfigJSONRequestBody
}

type UpdateConfigResponseObject interface {
	VisitUpdateConfigResponse(w http.ResponseWriter) error
}

type UpdateConfig200JSONResponse ConfigResponse

func (response UpdateConfig200JSONResponse) VisitUpdateConfigResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateConfig400JSONResponse struct{ BadRequestJSONResponse }

func (response UpdateConfig400JSONResponse) VisitUpdateConfigResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type UpdateConfig500JSONResponse struct{ InternalErrorJSONResponse }

func (response UpdateConfig500JSONResponse) VisitUpdateConfigResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetDebugInfoRequestObject struct {
}

type GetDebugInfoResponseObject interface {
	VisitGetDebugInfoResponse(w http.ResponseWriter) error
}

type GetDebugInfo200JSONResponse DebugInfoResponse

func (response GetDebugInfo200JSONResponse) VisitGetDebugInfoResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateDirectoryRequestObject struct {
	Body *CreateDirectoryJSONRequestBody
}

type CreateDirectoryResponseObject interface {
	VisitCreateDirectoryResponse(w http.ResponseWriter) error
}

type CreateDirectory200JSONResponse struct {
	// Created Whether the directory was created
	Created *bool `json:"created,omitempty"`

	// Path The created directory path
	Path *string `json:"path,omitempty"`
}

func (response CreateDirectory200JSONResponse) VisitCreateDirectoryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type CreateDirectory500JSONResponse struct{ InternalErrorJSONResponse }

func (response CreateDirectory500JSONResponse) VisitCreateDirectoryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type FuzzySearchFilesRequestObject struct {
	Body *FuzzySearchFilesJSONRequestBody
}

type FuzzySearchFilesResponseObject interface {
	VisitFuzzySearchFilesResponse(w http.ResponseWriter) error
}

type FuzzySearchFiles200JSONResponse FuzzySearchFilesResponse

func (response FuzzySearchFiles200JSONResponse) VisitFuzzySearchFilesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type FuzzySearchFiles400JSONResponse struct{ BadRequestJSONResponse }

func (response FuzzySearchFiles400JSONResponse) VisitFuzzySearchFilesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type FuzzySearchFiles500JSONResponse struct{ InternalErrorJSONResponse }

func (response FuzzySearchFiles500JSONResponse) VisitFuzzySearchFilesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetHealthRequestObject struct {
}

type GetHealthResponseObject interface {
	VisitGetHealthResponse(w http.ResponseWriter) error
}

type GetHealth200JSONResponse HealthResponse

func (response GetHealth200JSONResponse) VisitGetHealthResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetRecentPathsRequestObject struct {
	Params GetRecentPathsParams
}

type GetRecentPathsResponseObject interface {
	VisitGetRecentPathsResponse(w http.ResponseWriter) error
}

type GetRecentPaths200JSONResponse RecentPathsResponse

func (response GetRecentPaths200JSONResponse) VisitGetRecentPathsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetRecentPaths500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetRecentPaths500JSONResponse) VisitGetRecentPathsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ListSessionsRequestObject struct {
	Params ListSessionsParams
}

type ListSessionsResponseObject interface {
	VisitListSessionsResponse(w http.ResponseWriter) error
}

type ListSessions200JSONResponse SessionsResponse

func (response ListSessions200JSONResponse) VisitListSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ListSessions500JSONResponse struct{ InternalErrorJSONResponse }

func (response ListSessions500JSONResponse) VisitListSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type CreateSessionRequestObject struct {
	Body *CreateSessionJSONRequestBody
}

type CreateSessionResponseObject interface {
	VisitCreateSessionResponse(w http.ResponseWriter) error
}

type CreateSession201JSONResponse CreateSessionResponse

func (response CreateSession201JSONResponse) VisitCreateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(201)

	return json.NewEncoder(w).Encode(response)
}

type CreateSession400JSONResponse struct{ BadRequestJSONResponse }

func (response CreateSession400JSONResponse) VisitCreateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type CreateSession422JSONResponse DirectoryNotFoundResponse

func (response CreateSession422JSONResponse) VisitCreateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(422)

	return json.NewEncoder(w).Encode(response)
}

type CreateSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response CreateSession500JSONResponse) VisitCreateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type BulkArchiveSessionsRequestObject struct {
	Body *BulkArchiveSessionsJSONRequestBody
}

type BulkArchiveSessionsResponseObject interface {
	VisitBulkArchiveSessionsResponse(w http.ResponseWriter) error
}

type BulkArchiveSessions200JSONResponse BulkArchiveResponse

func (response BulkArchiveSessions200JSONResponse) VisitBulkArchiveSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type BulkArchiveSessions207JSONResponse BulkArchiveResponse

func (response BulkArchiveSessions207JSONResponse) VisitBulkArchiveSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(207)

	return json.NewEncoder(w).Encode(response)
}

type BulkArchiveSessions400JSONResponse struct{ BadRequestJSONResponse }

func (response BulkArchiveSessions400JSONResponse) VisitBulkArchiveSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type BulkArchiveSessions500JSONResponse struct{ InternalErrorJSONResponse }

func (response BulkArchiveSessions500JSONResponse) VisitBulkArchiveSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type BulkRestoreDraftsRequestObject struct {
	Body *BulkRestoreDraftsJSONRequestBody
}

type BulkRestoreDraftsResponseObject interface {
	VisitBulkRestoreDraftsResponse(w http.ResponseWriter) error
}

type BulkRestoreDrafts200JSONResponse BulkRestoreDraftsResponse

func (response BulkRestoreDrafts200JSONResponse) VisitBulkRestoreDraftsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type BulkRestoreDrafts207JSONResponse BulkRestoreDraftsResponse

func (response BulkRestoreDrafts207JSONResponse) VisitBulkRestoreDraftsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(207)

	return json.NewEncoder(w).Encode(response)
}

type BulkRestoreDrafts400JSONResponse struct{ BadRequestJSONResponse }

func (response BulkRestoreDrafts400JSONResponse) VisitBulkRestoreDraftsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type BulkRestoreDrafts500JSONResponse struct{ InternalErrorJSONResponse }

func (response BulkRestoreDrafts500JSONResponse) VisitBulkRestoreDraftsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type SearchSessionsRequestObject struct {
	Params SearchSessionsParams
}

type SearchSessionsResponseObject interface {
	VisitSearchSessionsResponse(w http.ResponseWriter) error
}

type SearchSessions200JSONResponse SessionSearchResponse

func (response SearchSessions200JSONResponse) VisitSearchSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type SearchSessions400JSONResponse struct{ BadRequestJSONResponse }

func (response SearchSessions400JSONResponse) VisitSearchSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type SearchSessions500JSONResponse struct{ InternalErrorJSONResponse }

func (response SearchSessions500JSONResponse) VisitSearchSessionsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionRequestObject struct {
	Id SessionId `json:"id"`
}

type GetSessionResponseObject interface {
	VisitGetSessionResponse(w http.ResponseWriter) error
}

type GetSession200JSONResponse SessionResponse

func (response GetSession200JSONResponse) VisitGetSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSession404JSONResponse struct{ NotFoundJSONResponse }

func (response GetSession404JSONResponse) VisitGetSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetSession500JSONResponse) VisitGetSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSessionRequestObject struct {
	Id   SessionId `json:"id"`
	Body *UpdateSessionJSONRequestBody
}

type UpdateSessionResponseObject interface {
	VisitUpdateSessionResponse(w http.ResponseWriter) error
}

type UpdateSession200JSONResponse SessionResponse

func (response UpdateSession200JSONResponse) VisitUpdateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSession400JSONResponse ErrorResponse

func (response UpdateSession400JSONResponse) VisitUpdateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSession404JSONResponse struct{ NotFoundJSONResponse }

func (response UpdateSession404JSONResponse) VisitUpdateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type UpdateSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response UpdateSession500JSONResponse) VisitUpdateSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ContinueSessionRequestObject struct {
	Id   SessionId `json:"id"`
	Body *ContinueSessionJSONRequestBody
}

type ContinueSessionResponseObject interface {
	VisitContinueSessionResponse(w http.ResponseWriter) error
}

type ContinueSession201JSONResponse ContinueSessionResponse

func (response ContinueSession201JSONResponse) VisitContinueSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(201)

	return json.NewEncoder(w).Encode(response)
}

type ContinueSession404JSONResponse struct{ NotFoundJSONResponse }

func (response ContinueSession404JSONResponse) VisitContinueSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type ContinueSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response ContinueSession500JSONResponse) VisitContinueSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type HardDeleteEmptyDraftSessionRequestObject struct {
	Id SessionId `json:"id"`
}

type HardDeleteEmptyDraftSessionResponseObject interface {
	VisitHardDeleteEmptyDraftSessionResponse(w http.ResponseWriter) error
}

type HardDeleteEmptyDraftSession204Response struct {
}

func (response HardDeleteEmptyDraftSession204Response) VisitHardDeleteEmptyDraftSessionResponse(w http.ResponseWriter) error {
	w.WriteHeader(204)
	return nil
}

type HardDeleteEmptyDraftSession400JSONResponse ErrorResponse

func (response HardDeleteEmptyDraftSession400JSONResponse) VisitHardDeleteEmptyDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type HardDeleteEmptyDraftSession404JSONResponse struct{ NotFoundJSONResponse }

func (response HardDeleteEmptyDraftSession404JSONResponse) VisitHardDeleteEmptyDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type HardDeleteEmptyDraftSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response HardDeleteEmptyDraftSession500JSONResponse) VisitHardDeleteEmptyDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type InterruptSessionRequestObject struct {
	Id SessionId `json:"id"`
}

type InterruptSessionResponseObject interface {
	VisitInterruptSessionResponse(w http.ResponseWriter) error
}

type InterruptSession200JSONResponse InterruptSessionResponse

func (response InterruptSession200JSONResponse) VisitInterruptSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type InterruptSession400JSONResponse ErrorResponse

func (response InterruptSession400JSONResponse) VisitInterruptSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type InterruptSession404JSONResponse struct{ NotFoundJSONResponse }

func (response InterruptSession404JSONResponse) VisitInterruptSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type InterruptSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response InterruptSession500JSONResponse) VisitInterruptSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDraftSessionRequestObject struct {
	Id SessionId `json:"id"`
}

type DeleteDraftSessionResponseObject interface {
	VisitDeleteDraftSessionResponse(w http.ResponseWriter) error
}

type DeleteDraftSession204Response struct {
}

func (response DeleteDraftSession204Response) VisitDeleteDraftSessionResponse(w http.ResponseWriter) error {
	w.WriteHeader(204)
	return nil
}

type DeleteDraftSession400JSONResponse ErrorResponse

func (response DeleteDraftSession400JSONResponse) VisitDeleteDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDraftSession404JSONResponse struct{ NotFoundJSONResponse }

func (response DeleteDraftSession404JSONResponse) VisitDeleteDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type DeleteDraftSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response DeleteDraftSession500JSONResponse) VisitDeleteDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type LaunchDraftSessionRequestObject struct {
	Id   SessionId `json:"id"`
	Body *LaunchDraftSessionJSONRequestBody
}

type LaunchDraftSessionResponseObject interface {
	VisitLaunchDraftSessionResponse(w http.ResponseWriter) error
}

type LaunchDraftSession200JSONResponse SessionResponse

func (response LaunchDraftSession200JSONResponse) VisitLaunchDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type LaunchDraftSession400JSONResponse ErrorResponse

func (response LaunchDraftSession400JSONResponse) VisitLaunchDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type LaunchDraftSession404JSONResponse struct{ NotFoundJSONResponse }

func (response LaunchDraftSession404JSONResponse) VisitLaunchDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type LaunchDraftSession422JSONResponse DirectoryNotFoundResponse

func (response LaunchDraftSession422JSONResponse) VisitLaunchDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(422)

	return json.NewEncoder(w).Encode(response)
}

type LaunchDraftSession500JSONResponse struct{ InternalErrorJSONResponse }

func (response LaunchDraftSession500JSONResponse) VisitLaunchDraftSessionResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionMessagesRequestObject struct {
	Id SessionId `json:"id"`
}

type GetSessionMessagesResponseObject interface {
	VisitGetSessionMessagesResponse(w http.ResponseWriter) error
}

type GetSessionMessages200JSONResponse ConversationResponse

func (response GetSessionMessages200JSONResponse) VisitGetSessionMessagesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionMessages404JSONResponse struct{ NotFoundJSONResponse }

func (response GetSessionMessages404JSONResponse) VisitGetSessionMessagesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionMessages500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetSessionMessages500JSONResponse) VisitGetSessionMessagesResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionSnapshotsRequestObject struct {
	Id SessionId `json:"id"`
}

type GetSessionSnapshotsResponseObject interface {
	VisitGetSessionSnapshotsResponse(w http.ResponseWriter) error
}

type GetSessionSnapshots200JSONResponse SnapshotsResponse

func (response GetSessionSnapshots200JSONResponse) VisitGetSessionSnapshotsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionSnapshots404JSONResponse struct{ NotFoundJSONResponse }

func (response GetSessionSnapshots404JSONResponse) VisitGetSessionSnapshotsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(404)

	return json.NewEncoder(w).Encode(response)
}

type GetSessionSnapshots500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetSessionSnapshots500JSONResponse) VisitGetSessionSnapshotsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetSlashCommandsRequestObject struct {
	Params GetSlashCommandsParams
}

type GetSlashCommandsResponseObject interface {
	VisitGetSlashCommandsResponse(w http.ResponseWriter) error
}

type GetSlashCommands200JSONResponse SlashCommandsResponse

func (response GetSlashCommands200JSONResponse) VisitGetSlashCommandsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetSlashCommands400JSONResponse struct{ BadRequestJSONResponse }

func (response GetSlashCommands400JSONResponse) VisitGetSlashCommandsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type GetSlashCommands500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetSlashCommands500JSONResponse) VisitGetSlashCommandsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type GetUserSettingsRequestObject struct {
}

type GetUserSettingsResponseObject interface {
	VisitGetUserSettingsResponse(w http.ResponseWriter) error
}

type GetUserSettings200JSONResponse UserSettingsResponse

func (response GetUserSettings200JSONResponse) VisitGetUserSettingsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type GetUserSettings500JSONResponse struct{ InternalErrorJSONResponse }

func (response GetUserSettings500JSONResponse) VisitGetUserSettingsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type UpdateUserSettingsRequestObject struct {
	Body *UpdateUserSettingsJSONRequestBody
}

type UpdateUserSettingsResponseObject interface {
	VisitUpdateUserSettingsResponse(w http.ResponseWriter) error
}

type UpdateUserSettings200JSONResponse UserSettingsResponse

func (response UpdateUserSettings200JSONResponse) VisitUpdateUserSettingsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type UpdateUserSettings400JSONResponse struct{ BadRequestJSONResponse }

func (response UpdateUserSettings400JSONResponse) VisitUpdateUserSettingsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(400)

	return json.NewEncoder(w).Encode(response)
}

type UpdateUserSettings500JSONResponse struct{ InternalErrorJSONResponse }

func (response UpdateUserSettings500JSONResponse) VisitUpdateUserSettingsResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

type ValidateDirectoryRequestObject struct {
	Body *ValidateDirectoryJSONRequestBody
}

type ValidateDirectoryResponseObject interface {
	VisitValidateDirectoryResponse(w http.ResponseWriter) error
}

type ValidateDirectory200JSONResponse ValidateDirectoryResponse

func (response ValidateDirectory200JSONResponse) VisitValidateDirectoryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(200)

	return json.NewEncoder(w).Encode(response)
}

type ValidateDirectory500JSONResponse struct{ InternalErrorJSONResponse }

func (response ValidateDirectory500JSONResponse) VisitValidateDirectoryResponse(w http.ResponseWriter) error {
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(500)

	return json.NewEncoder(w).Encode(response)
}

// StrictServerInterface represents all server handlers.
type StrictServerInterface interface {
	// Discover available agents
	// (POST /agents/discover)
	DiscoverAgents(ctx context.Context, request DiscoverAgentsRequestObject) (DiscoverAgentsResponseObject, error)
	// List approval requests
	// (GET /approvals)
	ListApprovals(ctx context.Context, request ListApprovalsRequestObject) (ListApprovalsResponseObject, error)
	// Create approval request
	// (POST /approvals)
	CreateApproval(ctx context.Context, request CreateApprovalRequestObject) (CreateApprovalResponseObject, error)
	// Get approval details
	// (GET /approvals/{id})
	GetApproval(ctx context.Context, request GetApprovalRequestObject) (GetApprovalResponseObject, error)
	// Decide on approval request
	// (POST /approvals/{id}/decide)
	DecideApproval(ctx context.Context, request DecideApprovalRequestObject) (DecideApprovalResponseObject, error)
	// Get daemon configuration
	// (GET /config)
	GetConfig(ctx context.Context, request GetConfigRequestObject) (GetConfigResponseObject, error)
	// Update daemon configuration
	// (PATCH /config)
	UpdateConfig(ctx context.Context, request UpdateConfigRequestObject) (UpdateConfigResponseObject, error)
	// Get debug information
	// (GET /debug-info)
	GetDebugInfo(ctx context.Context, request GetDebugInfoRequestObject) (GetDebugInfoResponseObject, error)
	// Create a directory
	// (POST /directories)
	CreateDirectory(ctx context.Context, request CreateDirectoryRequestObject) (CreateDirectoryResponseObject, error)
	// Fuzzy search for files and folders
	// (POST /fuzzy-search/files)
	FuzzySearchFiles(ctx context.Context, request FuzzySearchFilesRequestObject) (FuzzySearchFilesResponseObject, error)
	// Health check
	// (GET /health)
	GetHealth(ctx context.Context, request GetHealthRequestObject) (GetHealthResponseObject, error)
	// Get recent working directories
	// (GET /recent-paths)
	GetRecentPaths(ctx context.Context, request GetRecentPathsRequestObject) (GetRecentPathsResponseObject, error)
	// List sessions
	// (GET /sessions)
	ListSessions(ctx context.Context, request ListSessionsRequestObject) (ListSessionsResponseObject, error)
	// Launch a new session
	// (POST /sessions)
	CreateSession(ctx context.Context, request CreateSessionRequestObject) (CreateSessionResponseObject, error)
	// Bulk archive/unarchive sessions
	// (POST /sessions/archive)
	BulkArchiveSessions(ctx context.Context, request BulkArchiveSessionsRequestObject) (BulkArchiveSessionsResponseObject, error)
	// Restore multiple discarded draft sessions
	// (POST /sessions/restore)
	BulkRestoreDrafts(ctx context.Context, request BulkRestoreDraftsRequestObject) (BulkRestoreDraftsResponseObject, error)
	// Search sessions by title
	// (GET /sessions/search)
	SearchSessions(ctx context.Context, request SearchSessionsRequestObject) (SearchSessionsResponseObject, error)
	// Get session details
	// (GET /sessions/{id})
	GetSession(ctx context.Context, request GetSessionRequestObject) (GetSessionResponseObject, error)
	// Update session settings
	// (PATCH /sessions/{id})
	UpdateSession(ctx context.Context, request UpdateSessionRequestObject) (UpdateSessionResponseObject, error)
	// Continue or fork a session
	// (POST /sessions/{id}/continue)
	ContinueSession(ctx context.Context, request ContinueSessionRequestObject) (ContinueSessionResponseObject, error)
	// Permanently delete an empty draft session
	// (DELETE /sessions/{id}/hard-delete-empty)
	HardDeleteEmptyDraftSession(ctx context.Context, request HardDeleteEmptyDraftSessionRequestObject) (HardDeleteEmptyDraftSessionResponseObject, error)
	// Interrupt a running session
	// (POST /sessions/{id}/interrupt)
	InterruptSession(ctx context.Context, request InterruptSessionRequestObject) (InterruptSessionResponseObject, error)
	// Delete a draft session
	// (DELETE /sessions/{id}/launch)
	DeleteDraftSession(ctx context.Context, request DeleteDraftSessionRequestObject) (DeleteDraftSessionResponseObject, error)
	// Launch a draft session
	// (POST /sessions/{id}/launch)
	LaunchDraftSession(ctx context.Context, request LaunchDraftSessionRequestObject) (LaunchDraftSessionResponseObject, error)
	// Get conversation messages
	// (GET /sessions/{id}/messages)
	GetSessionMessages(ctx context.Context, request GetSessionMessagesRequestObject) (GetSessionMessagesResponseObject, error)
	// Get file snapshots
	// (GET /sessions/{id}/snapshots)
	GetSessionSnapshots(ctx context.Context, request GetSessionSnapshotsRequestObject) (GetSessionSnapshotsResponseObject, error)
	// Get available slash commands
	// (GET /slash-commands)
	GetSlashCommands(ctx context.Context, request GetSlashCommandsRequestObject) (GetSlashCommandsResponseObject, error)
	// Get user settings
	// (GET /user-settings)
	GetUserSettings(ctx context.Context, request GetUserSettingsRequestObject) (GetUserSettingsResponseObject, error)
	// Update user settings
	// (PATCH /user-settings)
	UpdateUserSettings(ctx context.Context, request UpdateUserSettingsRequestObject) (UpdateUserSettingsResponseObject, error)
	// Validate directory existence
	// (POST /validate-directory)
	ValidateDirectory(ctx context.Context, request ValidateDirectoryRequestObject) (ValidateDirectoryResponseObject, error)
}

type StrictHandlerFunc = strictgin.StrictGinHandlerFunc
type StrictMiddlewareFunc = strictgin.StrictGinMiddlewareFunc

func NewStrictHandler(ssi StrictServerInterface, middlewares []StrictMiddlewareFunc) ServerInterface {
	return &strictHandler{ssi: ssi, middlewares: middlewares}
}

type strictHandler struct {
	ssi         StrictServerInterface
	middlewares []StrictMiddlewareFunc
}

// DiscoverAgents operation middleware
func (sh *strictHandler) DiscoverAgents(ctx *gin.Context) {
	var request DiscoverAgentsRequestObject

	var body DiscoverAgentsJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.DiscoverAgents(ctx, request.(DiscoverAgentsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DiscoverAgents")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(DiscoverAgentsResponseObject); ok {
		if err := validResponse.VisitDiscoverAgentsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// ListApprovals operation middleware
func (sh *strictHandler) ListApprovals(ctx *gin.Context, params ListApprovalsParams) {
	var request ListApprovalsRequestObject

	request.Params = params

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.ListApprovals(ctx, request.(ListApprovalsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListApprovals")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(ListApprovalsResponseObject); ok {
		if err := validResponse.VisitListApprovalsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateApproval operation middleware
func (sh *strictHandler) CreateApproval(ctx *gin.Context) {
	var request CreateApprovalRequestObject

	var body CreateApprovalJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.CreateApproval(ctx, request.(CreateApprovalRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateApproval")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(CreateApprovalResponseObject); ok {
		if err := validResponse.VisitCreateApprovalResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetApproval operation middleware
func (sh *strictHandler) GetApproval(ctx *gin.Context, id ApprovalId) {
	var request GetApprovalRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetApproval(ctx, request.(GetApprovalRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetApproval")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetApprovalResponseObject); ok {
		if err := validResponse.VisitGetApprovalResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// DecideApproval operation middleware
func (sh *strictHandler) DecideApproval(ctx *gin.Context, id ApprovalId) {
	var request DecideApprovalRequestObject

	request.Id = id

	var body DecideApprovalJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.DecideApproval(ctx, request.(DecideApprovalRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DecideApproval")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(DecideApprovalResponseObject); ok {
		if err := validResponse.VisitDecideApprovalResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetConfig operation middleware
func (sh *strictHandler) GetConfig(ctx *gin.Context) {
	var request GetConfigRequestObject

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetConfig(ctx, request.(GetConfigRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetConfig")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetConfigResponseObject); ok {
		if err := validResponse.VisitGetConfigResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateConfig operation middleware
func (sh *strictHandler) UpdateConfig(ctx *gin.Context) {
	var request UpdateConfigRequestObject

	var body UpdateConfigJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateConfig(ctx, request.(UpdateConfigRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateConfig")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(UpdateConfigResponseObject); ok {
		if err := validResponse.VisitUpdateConfigResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetDebugInfo operation middleware
func (sh *strictHandler) GetDebugInfo(ctx *gin.Context) {
	var request GetDebugInfoRequestObject

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetDebugInfo(ctx, request.(GetDebugInfoRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetDebugInfo")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetDebugInfoResponseObject); ok {
		if err := validResponse.VisitGetDebugInfoResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateDirectory operation middleware
func (sh *strictHandler) CreateDirectory(ctx *gin.Context) {
	var request CreateDirectoryRequestObject

	var body CreateDirectoryJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.CreateDirectory(ctx, request.(CreateDirectoryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateDirectory")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(CreateDirectoryResponseObject); ok {
		if err := validResponse.VisitCreateDirectoryResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// FuzzySearchFiles operation middleware
func (sh *strictHandler) FuzzySearchFiles(ctx *gin.Context) {
	var request FuzzySearchFilesRequestObject

	var body FuzzySearchFilesJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.FuzzySearchFiles(ctx, request.(FuzzySearchFilesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "FuzzySearchFiles")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(FuzzySearchFilesResponseObject); ok {
		if err := validResponse.VisitFuzzySearchFilesResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetHealth operation middleware
func (sh *strictHandler) GetHealth(ctx *gin.Context) {
	var request GetHealthRequestObject

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetHealth(ctx, request.(GetHealthRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetHealth")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetHealthResponseObject); ok {
		if err := validResponse.VisitGetHealthResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetRecentPaths operation middleware
func (sh *strictHandler) GetRecentPaths(ctx *gin.Context, params GetRecentPathsParams) {
	var request GetRecentPathsRequestObject

	request.Params = params

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetRecentPaths(ctx, request.(GetRecentPathsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetRecentPaths")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetRecentPathsResponseObject); ok {
		if err := validResponse.VisitGetRecentPathsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// ListSessions operation middleware
func (sh *strictHandler) ListSessions(ctx *gin.Context, params ListSessionsParams) {
	var request ListSessionsRequestObject

	request.Params = params

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.ListSessions(ctx, request.(ListSessionsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ListSessions")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(ListSessionsResponseObject); ok {
		if err := validResponse.VisitListSessionsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// CreateSession operation middleware
func (sh *strictHandler) CreateSession(ctx *gin.Context) {
	var request CreateSessionRequestObject

	var body CreateSessionJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.CreateSession(ctx, request.(CreateSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "CreateSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(CreateSessionResponseObject); ok {
		if err := validResponse.VisitCreateSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// BulkArchiveSessions operation middleware
func (sh *strictHandler) BulkArchiveSessions(ctx *gin.Context) {
	var request BulkArchiveSessionsRequestObject

	var body BulkArchiveSessionsJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.BulkArchiveSessions(ctx, request.(BulkArchiveSessionsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "BulkArchiveSessions")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(BulkArchiveSessionsResponseObject); ok {
		if err := validResponse.VisitBulkArchiveSessionsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// BulkRestoreDrafts operation middleware
func (sh *strictHandler) BulkRestoreDrafts(ctx *gin.Context) {
	var request BulkRestoreDraftsRequestObject

	var body BulkRestoreDraftsJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.BulkRestoreDrafts(ctx, request.(BulkRestoreDraftsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "BulkRestoreDrafts")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(BulkRestoreDraftsResponseObject); ok {
		if err := validResponse.VisitBulkRestoreDraftsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// SearchSessions operation middleware
func (sh *strictHandler) SearchSessions(ctx *gin.Context, params SearchSessionsParams) {
	var request SearchSessionsRequestObject

	request.Params = params

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.SearchSessions(ctx, request.(SearchSessionsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "SearchSessions")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(SearchSessionsResponseObject); ok {
		if err := validResponse.VisitSearchSessionsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSession operation middleware
func (sh *strictHandler) GetSession(ctx *gin.Context, id SessionId) {
	var request GetSessionRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetSession(ctx, request.(GetSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetSessionResponseObject); ok {
		if err := validResponse.VisitGetSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateSession operation middleware
func (sh *strictHandler) UpdateSession(ctx *gin.Context, id SessionId) {
	var request UpdateSessionRequestObject

	request.Id = id

	var body UpdateSessionJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateSession(ctx, request.(UpdateSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(UpdateSessionResponseObject); ok {
		if err := validResponse.VisitUpdateSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// ContinueSession operation middleware
func (sh *strictHandler) ContinueSession(ctx *gin.Context, id SessionId) {
	var request ContinueSessionRequestObject

	request.Id = id

	var body ContinueSessionJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.ContinueSession(ctx, request.(ContinueSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ContinueSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(ContinueSessionResponseObject); ok {
		if err := validResponse.VisitContinueSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// HardDeleteEmptyDraftSession operation middleware
func (sh *strictHandler) HardDeleteEmptyDraftSession(ctx *gin.Context, id SessionId) {
	var request HardDeleteEmptyDraftSessionRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.HardDeleteEmptyDraftSession(ctx, request.(HardDeleteEmptyDraftSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "HardDeleteEmptyDraftSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(HardDeleteEmptyDraftSessionResponseObject); ok {
		if err := validResponse.VisitHardDeleteEmptyDraftSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// InterruptSession operation middleware
func (sh *strictHandler) InterruptSession(ctx *gin.Context, id SessionId) {
	var request InterruptSessionRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.InterruptSession(ctx, request.(InterruptSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "InterruptSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(InterruptSessionResponseObject); ok {
		if err := validResponse.VisitInterruptSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// DeleteDraftSession operation middleware
func (sh *strictHandler) DeleteDraftSession(ctx *gin.Context, id SessionId) {
	var request DeleteDraftSessionRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.DeleteDraftSession(ctx, request.(DeleteDraftSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "DeleteDraftSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(DeleteDraftSessionResponseObject); ok {
		if err := validResponse.VisitDeleteDraftSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// LaunchDraftSession operation middleware
func (sh *strictHandler) LaunchDraftSession(ctx *gin.Context, id SessionId) {
	var request LaunchDraftSessionRequestObject

	request.Id = id

	var body LaunchDraftSessionJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.LaunchDraftSession(ctx, request.(LaunchDraftSessionRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "LaunchDraftSession")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(LaunchDraftSessionResponseObject); ok {
		if err := validResponse.VisitLaunchDraftSessionResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSessionMessages operation middleware
func (sh *strictHandler) GetSessionMessages(ctx *gin.Context, id SessionId) {
	var request GetSessionMessagesRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetSessionMessages(ctx, request.(GetSessionMessagesRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSessionMessages")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetSessionMessagesResponseObject); ok {
		if err := validResponse.VisitGetSessionMessagesResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSessionSnapshots operation middleware
func (sh *strictHandler) GetSessionSnapshots(ctx *gin.Context, id SessionId) {
	var request GetSessionSnapshotsRequestObject

	request.Id = id

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetSessionSnapshots(ctx, request.(GetSessionSnapshotsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSessionSnapshots")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetSessionSnapshotsResponseObject); ok {
		if err := validResponse.VisitGetSessionSnapshotsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetSlashCommands operation middleware
func (sh *strictHandler) GetSlashCommands(ctx *gin.Context, params GetSlashCommandsParams) {
	var request GetSlashCommandsRequestObject

	request.Params = params

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetSlashCommands(ctx, request.(GetSlashCommandsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetSlashCommands")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetSlashCommandsResponseObject); ok {
		if err := validResponse.VisitGetSlashCommandsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// GetUserSettings operation middleware
func (sh *strictHandler) GetUserSettings(ctx *gin.Context) {
	var request GetUserSettingsRequestObject

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.GetUserSettings(ctx, request.(GetUserSettingsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "GetUserSettings")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(GetUserSettingsResponseObject); ok {
		if err := validResponse.VisitGetUserSettingsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// UpdateUserSettings operation middleware
func (sh *strictHandler) UpdateUserSettings(ctx *gin.Context) {
	var request UpdateUserSettingsRequestObject

	var body UpdateUserSettingsJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.UpdateUserSettings(ctx, request.(UpdateUserSettingsRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "UpdateUserSettings")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(UpdateUserSettingsResponseObject); ok {
		if err := validResponse.VisitUpdateUserSettingsResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// ValidateDirectory operation middleware
func (sh *strictHandler) ValidateDirectory(ctx *gin.Context) {
	var request ValidateDirectoryRequestObject

	var body ValidateDirectoryJSONRequestBody
	if err := ctx.ShouldBindJSON(&body); err != nil {
		ctx.Status(http.StatusBadRequest)
		ctx.Error(err)
		return
	}
	request.Body = &body

	handler := func(ctx *gin.Context, request interface{}) (interface{}, error) {
		return sh.ssi.ValidateDirectory(ctx, request.(ValidateDirectoryRequestObject))
	}
	for _, middleware := range sh.middlewares {
		handler = middleware(handler, "ValidateDirectory")
	}

	response, err := handler(ctx, request)

	if err != nil {
		ctx.Error(err)
		ctx.Status(http.StatusInternalServerError)
	} else if validResponse, ok := response.(ValidateDirectoryResponseObject); ok {
		if err := validResponse.VisitValidateDirectoryResponse(ctx.Writer); err != nil {
			ctx.Error(err)
		}
	} else if response != nil {
		ctx.Error(fmt.Errorf("unexpected response type: %T", response))
	}
}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+R9a28bOZboXyF0L9A2IFm243R6fHGBm9jpbt91HhOnZ3a3HQhUFSVxXCKrSZZtdZD5",
	"7QseklVkFeshPzO7+RSr+Dg8PDw8b34dJXydc0aYkqPjr6McC7wmigj4C+e54Nc4O0v1XymRiaC5opyN",
	"jkev7Td0djoaj8gtXucZGR1Dn9nt5s9XP/1lNB5R3TTHajUajxhe6wY0HY1HgvxRUEHS0bESBRmPZLIi",
	"a6xnUZtct5JKULYcffs2HkkiJeUsBsSF+VSHQfeY4XmSksXB4Yujlz8+CCTfdGOZcyYJYOcNTj+RPwoi",
	"lf4r4UwRpizaMppgDeP0H1ID+rUC7uuICMGF6ZLqCX49P5282D8YjUdrIiVe6t/eUSkpWyIHHVpQkqXo",
	"hz8KIjY/GLSUgP5vQRaj49H/mlZ7OTVf5fStnuyTBdssIkThG5zCLHoZ38ajM6aIYDh7WwF5n3UdwbpS",
	"ojDNAGlK4ITMaKopZZ4cHL7Qk1brdtMjScQ1EciM+YDLbZlgPHrP1c+8YOn913ywfxjspSNSxhVawBQP",
	"uJ5PRPJCJCQ6OmD89dIuJRc8J0JRQ73BMPVz9QH+gzPk/YwWgq/Rf7x+d67/x9QaK0XEaFw/J3rpTHf4",
	"TG5Vc2j9K1IcFZKgBRfINpbBAf5/WAM90UidY0kmGU+w4tHJzFlucCfdH+lvrWBXsw2ZxmC5OdHfV0St",
	"iEAAMKLSTKcHyhAXaJnxuUYjFSRRXGz0vKxYj45/H0Gb0Xhkmoy+jCOsr2JOv5uFhsgtwao68/k/SAIn",
	"2THo5tYnfL22NBHj6UT8IJFr4+PJfk7RDVUrlOACukWQlQiCFUlnODLHif6myUnRNZEKr/PReLTgYq0b",
	"j1KsyER/iQ1LIzfAb4z+URDkbipEU42fBa1tMdxKluFERjZ8PW0B2Z2/fpBZkWV4rmc0l0lzooLNYst4",
	"LSVPqEYaEkXjPtO9yiu1SZqGv/SNKzvuypQszC3ZHFxhVcg+NuVo7cK0/jYeKc6zGWV5YbhomlLDUT56",
	"lGhwVGMPnGcI+iFPFhn7PFeTJtaMeiTWaCIWaKrW+VTZC6xxDgCSOJeAyezlp29bR0UBgsgtSQpFZm7a",
	"vnNqpAqzz8HmlMgMDogPYIC2rjNd3ghNto4VHrpbDdChc9e8FyU11A51IYTmf2aBiC+QWpEAnZbp5YSl",
	"GmljK1uSFMQDRkka4YDVxLJ/xVSRtRy+9HIyLATeDEfFmyK7ei2SFb0mnvQXgoTN98h5/CwKom8/22KM",
	"FjiT8EvB7G8Vgc05zwhm4RmXrVKw9Aae+sOVtPy7Oe2GCcJ/9an/Mq5w17zLKTszHw96MOaDOK5Q0IvD",
	"vn0Nf11gmpF0ZifrRMYKK2SaA35zzagj2NBctRMF4arHI1kkCZEykAQDdl/uWx1DtmMTJdsQ3yciFRfk",
	"VOCFkq0k2Ekw0NddCEA2wgxqpJeUygSLVN8ZjmE9PQkNXP4TUY/Fz784+ZxwtqDLdqQlGS5SMsPXmFox",
	"pk3cPYGWWt4tGyOsgOsnMEmhlVarbjfZmZ0oJYok+h6Ehk3hpVB8jRVNcJZtkGvs5tZ90M4ab1BKFwsi",
	"DO1Ws+9GJVMzcXw+e4tlG38N3my9V78/+riJzZYtUZQVxBJe+5WSZfyGpDMtIETo9rX5jOAzyqjUgsVw",
	"msS5vphnciMVWc9ywdd5XD0gDI6DaYhswxieC6n4ekaZVKJIVPywnUAjFDSKjJVS2bP607LFXRGwxrcz",
	"VYgYlO/wraaHayKkVVygHfA1utZiTcXWKFNkScCesE7ymSGjPpnk3clHczB1t5yINTVc0GAX1hyB6uQj",
	"rBV06KpTFIFgNGoO8Z7cIPikdzSxdAi6XSD/vuc3CKepsZSgFWZppmVlxeG0mwGjmkM3MX24JkLQlPTR",
	"Uu2ImbUMOknbXQ32tIbKlGcjqD7PkhXN0tiSc6z5R+sY0Nm0adNDi2Yv/RvM2Kahdc0GHaOTtV69vvbS",
	"REpskfe6kMpz9fY6aqdySkSfeosDe3SvIl4OK1tUmtK+bXUafc7gwOnbSA5UacCywDMrB/cCtQUNthCQ",
	"Z7ms8QtjjkSuQa/VZphJhuhNm5mfG7rOJidaFQyYJ3TwsOfMpFb11ch1/xdEFhkYuYBD6J9XlF3pmb+0",
	"WodKbB0cvjjyrDSUqR+PRjFGTaVW7fOMKKewLbCe9xhUs3GLAFSSAlphiQRJiNZ2UAlzU+ax5waWVkgS",
	"peeP0MYMXkiCzk6B7hiRmsQd5TXZBo/Jam7L9Ve0Y2yt5hfYBLnrbUMhwWCGpaRSYeZh/UuU5fxREBYz",
	"h17YL4gV6zkRiLJg+/2L5WVsMzqZWbv9zphN0hYLD2XX3JjwNUJ3ypNcoaFlQJYXauas/uHA///iw3tk",
	"2oO5ozJbleMDMfdO0mGZAvP1lsMZApy18gFr8tKNuniBP9aCi3bcAlBnp0itqHTjUuCWwwxloX3M0VXA",
	"WALO1HeLPJCdqHkx3dlgBAZvUlnuWgT8NsvwJzAHm+unZlMbaB9+aFPsNhbW95qErTlQPYa1tRRVtrCi",
	"1ndkO0GxUyAxQ9elkZofgpGbISKZP9E9RCyAqFe9LKli5nxVMT/h6HXZDnntnJKcYIawMVIEhpJ/TvdW",
	"xRqzDG+ImGZ8qb9PrzH8f7re4DzfzobSow/+fUUV0TqgJr1AMwzhEgSnswXNNM3cCKqI+ePLw6vOzuuJ",
	"h6vQuFB8prGZqxlJqZL9wslbZgwxheIT0xP4hu5dLj9ijAEKOXUuyrPFe67e3lI5ZEZDXXC8b7jQslnl",
	"60R0gahCKScSvNPk1mjlEQjuaC2A1RnaixoOMFsSwQuZbWbyiuYzX0/uXdo5LliyKt1m4PP0RkR6RF/z",
	"RgSwn0ZX2AXKTAvXvFABSH/Z1//G7X55aIdsVy1nrWmWUUkSzlKDmC5gRxHRuEU98aSzfkvMmwwnV+7k",
	"pTWzTHj46px+q1OXCrxQg8nT7SFlKDWmb6V/1luqkZfBTmvardOSt4PdFiK6LtZxK1GlkOw/kslozVMS",
	"sxDpn/1ICzDXGEx4kj/PwcAvOWNEn84VpldFVOq/p2nKsrqoApMLfruZ4ZzOrkjEUvX64xm6IhszoG6q",
	"WdyKMGUjc9qHnGNJZoWIQPkGS4J++3TuDSqJuKZJYOQfrZTK5fF0ynPCBC8UEXuYTnFOp9cH7dM6VjCU",
	"Y5v59fiaCs1mUentVkSdhIlg72fc2tLaiKAKivBWa2cLVqtXiel0mavJ0RaWxDNGFcWZtSYGTLka+1eS",
	"5WhNEFy0CKOPG7XizBoQNZ3mgmvRAZ1c/A3pe1g+olVxPFJUxZTmksPC99i5KRek4fxoYNa7dtFqCb0m",
	"Ys4lGUwNtj3ihdIibGz37WWrhbWI+NO4ibuWMV3xNZkWkohpLjiIjfcwwobS5naSdZsK5ITqlsgYRm4G",
	"mUbjg3aFxQwU1GO207sL7KdkXizP2IJ3+eloeW02F3Z+huxH34+lSUBzZhP3GIbbrbJNNOgtw1JpFqNZ",
	"R2SmcywVMp+TKqbLqXt6gZr9IitgV9Md7h8eTfYPJgcvPx/sH7/YP97f/8/BQWBx191HrFbOJXHx13PN",
	"Ydrn9yje10tSTNac7aXzKCnRP2PmLvpnfL1a1JhvFKlJAEc/vXz14yCrpJZQZLu+/nXIGDUnmYNPD02l",
	"okktrsrpm3J0fPDSWmDk6PjwxavyJMnR8dFhNMhKM65ZwouYzem9sQVqPOlmUiPHx1iPVbB2cKx3FTYk",
	"nNhhbRwckPgZS2jab5NpDZQsbwnbAu1Ugdpa8iZssxuQ3DnnVxJJvCDlTUeiLqSUJFRGY3JLh0TZpBLi",
	"rOfBOB42/bGk5RBDkLMdEy8jomtXG3gPnQGaLmxsRfSoPV+ARKkEu2jw9tV3rhOiwf39L6/iGeNqZuK0",
	"o5HTNmi8Puyvmk1NBMEpSAjEx2YwUVMLD/Vv5DE/Rm4mrVd+G6f9rA9uOTgEYUCsTEPNj/LbnintJkkX",
	"JBwTNVN92RAboVNBkri4YrBD270eb0lBZlPHnlfKcpsGYDHqgb0/hVyHGC+JyecVuaAdsrfcGyOTQXAQ",
	"so8qrSDCMMrciuGmXc+MRywETJmI8saq7k+TzQSI3kAac37cYK3IHnA8e7Mr7IbFSSE6c9xR7djh8F2A",
	"gSYyJ4mWoOA6jJrXy6jzJvlcg7tw60h657DtRI4e+7NuWEeN9cr407Zy1GqUVv+wVdXqnmFGbmaei6C0",
	"hpce9Uq+Ny76WbLCbAkffEvMzER+Bu2J0qpv1SNm7viZZuQdVskqstVU5hnefIwyyE8kw4pe2wA1EAdM",
	"cy0k2E+KowUVUiFJsEhWpildIJttNM9IeP6lSKYQeUOEnC6KP//cXEDHvSWPJkrI8iJrCUGmC2NhoBLh",
	"iom6cGQNtNPASyCsxhqzjKlkRdIzlpLbmM/gZIUFThQRKOeSGsMtXyDbzRoNEtcotBIevhi/OBi/+HH8",
	"4tX4xU/jF3+JWAk9ibduJmyJK5xLnhXK7pDiJSggueu18yytJZBMf5Ma9ym5dlrydMtNkQkXMQuNnhv9",
	"UeCMqg2CRmhnRZcrIvTuzIlSRATU8NNgGdmnUwdAY79CcomdYX0SLhjO5YpHheQWV7Pu5nzMCCsk7RCo",
	"jSvdJQBFb9msXyfs0gHdfq4xZXv55l7xBSCUJM604HDmT1zGfwyxLLh5/XVWQT69jvGfK6LUm9EeLQ6H",
	"/QPLNv02qk9EFYIhzrKN4RFjRG6TrEiJ7xGMGq0yuqah0f6w4eFwtnRW6owmqMBGqeu5gYRvrR0dnCTd",
	"ZnWNtWjQqC/EwviWG99QtaLMjx/t4gNROR7fupD3/c4A+FaTKmyddz0oIkKzneE80Mwg5JywpT4Ghy9/",
	"hCnd3wct+W4kUb9QRZesZEt2U2Kiys800wycF8ps+tSwSGlYp1Y49pZuMAdujAiihkS3RcNIuE3iWxOF",
	"h2Q/mcHeudYGG5rCWnizvReqJUsu9Omeb5AgGbnGJmBlUFhJJVP0hZM4mMbVumLo+ZXgTK06dHSSE5YS",
	"lti/YzGvkWiAwQkAc8qw2AR5ANGjP9QqUOUVaGXBH7M3eLL7EqjBu9hubC1MRtXRcFjbzKlyl6ODvf29",
	"g4P9y9HuFrPMhiLLTZesSHJVGVR65qlHmXSkJ8QsfVW8bOlBvAK701Lg1IjSnj/patSNzarp/t7B3n6/",
	"qd0lJLkxYocCcvxFkas7+iHuGITYxAx1gNiY1Wqo4Mtj2MDimad3t4xVHucm403yC+tU6LBX97izzQhN",
	"q/U7nIOOaKo1QESkyVYAv0YjqNSKMiZ0FTIxl1KvawJ2iomWWvTyqhTidZJPzOATr2eE8r/FkWLhjqSA",
	"LmOqkPXLYLEs1hoFJrxTqpRy55nZDcMkfMjHnti6XbxEu7fIQqQ4sgEZfSC1oCwWHM6uuygiYsoKnaHX",
	"VHAG5vVrLKhxHfQA93V0+vbNb79oOVsUJJoPviI47aHVHsh+/fz5I7LDaMRRZuRfgA0+xkH794llSJOz",
	"U8tO9B+2CErT7hO1mhiCQ/oj2lkplaP6rGPE19REfgGidhsBDbHNigZJwLCEpTmnTEG0RPcaYfTj6RRq",
	"W6y4VMevXr16ZcMlpuskjzL4xso/kYQw5cwr4cECn2QhW/2R4IIE2wZo9zdYImh9P/9iqCz0aJLShjTG",
	"sKzv7gF+MromJdyV/3Cw4l8hKZzySyeyHyrJ3tu+O0dN16T0JkCW+b+LJvGC1uSa1IPjQpT+GFMZNf7T",
	"D4Vqt545VRFLpIhYUwYaf2qy+11A3xDrmeIKZ0bRkDH7gsKZtU9JYzxHc7LQWhbO82yjNS+jVntzHR1G",
	"16SHukgwY9HCBDBRpXXXVB7bLcDc0YtXvfQYTFpb7NjfRA/ncXKQTmT81w5cDipDDEk0KmMXJSo7x+jo",
	"DuHCbooqPhhhEYQPt8yV4GRFZs7jZvNkFL8isejIiqtBN89RB6kFtlsQJrE/JBjVAAEh3NsBoLu0Tv7S",
	"hN0OmD6WqxdTDn+QiFZFx6LBRoMS+2yKWrRCkfOw2VaDyiv1ZyMan+DMM9uFkiN8RjeUpfzGcKEy0MzE",
	"pPqb+uNPQxHL4e5q5VH6u2bpv10ESNzf23/prXSRcSiu0zKfYXR9tapKtN69ZtX9YtD/viIMAeAIZ5mX",
	"f1oe1Ko+Avarc/FCafEBHLsyyPEaGpRObnMqiIzi5eziQ4UKdKOB7IyM19SA7IBoh9vgmd07U6a7N2br",
	"9hIeg67/o5cDiVKzSC7A0UhakgHnGZ9rJmOa2hBzcP8F1VaCg//10hnzL0fH8H/JM7KX8eXO5eXlaEWy",
	"jOv/7P6fy9H4cpQUQnLx0XrRLkfHh0ffhuCLLBYkUfSazNyZbuOV5oiZrwhkRpPrf4NF6oIEghMf8M6D",
	"gawbDFyz1sCChqHLsc32mKGO0nDlBRqvDBerFdocfuAF03GlDUIMyO1YbxVVm+jRAx3HtbgDP+pMFtAa",
	"Qyz63MOWSxOIDxy9Bn8ussxcCG17YO6/Cc8LOTmaHEwO9w9f7v+0/zI2jwmKHrAXpmH8ih+yF9FiDtF0",
	"7epWD/3qCy6uqgjjJtV1loIYnL9gw0+rFIYach85g8EJkWZ+WqZBPXwWg01lgUSscsVt6QtcysnB4f78",
	"zlkM4MmVCoOvpy123uU0CLLAWqUwC7bRS4OLP1pGJYpWJtVTAHJQjUZ7L1YlGmWxXuMYIl6fTZaEEWGc",
	"2KaVI7MYFj7Z1ZO0lpejT32RkS3SL36TREz0DQohZe5gmcb+lO826Gydc6EwU+gzllE/w/MmSdTqQDrH",
	"hXN5BiUgG3y/Qwe+X+1Hp0hvYYgxZAP2jgcyEJVA3N065NPywHKUzdw3k0UImyOsJ0YUjJn/VUVBxqNS",
	"8Kj5bco/4eMNpvp3m3kO4Temjl40vsyVmutI89Dyl+zS9vR3NN+gBCuyNOWFh1airC5K18YXUSPJBFXG",
	"ZXyYhpjbHINpESXrGsS0QDuMs4mDa4z0XzD8btf4MUvyE5NlhuXqpHK1hHsRr5DgHDDg2jKeBM2WpB4K",
	"5YIs6G3IiQzjmOUZZtsUqr4wZcLtWXAJQhNbqnpHkJzvehWrd0B71Fxvt7NmdQWY+zaoinVH3WofiQ9l",
	"kQ425u7ba+O5HgqqIK7uzlD9BuGtrrRjWyZLV93DeIzEDlnnauNq3OjLEQyDpgwj5Sx0/EwLKYzbZzqn",
	"bJq4/M/+YISWBT1UxQozGsLfo/03ELrqhXtrd9Zgi28zoXSaUnmXwhD9tqtI8qqJd4b/9tqE7lwqIWr4",
	"8VJ371YUwcF0h8oI37V9aDsjgFWzdrQ2PkZG4R/rbTX8wOS3gUa4+3SmgReTlxMzweRw//DoYP/w8HHq",
	"CHjruZpwMdnb2/u+qwvcpZpAT0jRIxUXwEytBM9pMnWbuuc29QG12jbF0lwD7RqlaZCCMone47j1rFOj",
	"tFPEa+F0KpcmpvgffMV6QwjaL0w9yIVNbOm4NSFeNZ3lgl9TFwfTx8hdL+R6IWPDj18bPFczymaKZGRN",
	"VMzA8CFXE8r0DDxXE82q+UIzYmC8LCFIi6Ymn0zLpSKMkvND35q48LBwr+W3rhll9IqgDzlhn+DEdtRU",
	"2i6VYTDebF2VLbE1HtlEqC2AqseKNtFXM2R4U3zp2Z372TGCfR4sK/8NZzT1i121HpQhYUD6qry2I94p",
	"4TUWvDMQ7FabAWamskV76LYKMni16DsnZc7KDiR2SKIQXZhUXjBmg+l3916h3YAxi65uZw7xio/1L8C2",
	"joJ2m2OWkvRjayaza2GDxahaoX8iL8PwLknMndl3/hpM1l+QgdeGf31R7/bnU5S4CFYeifoFn9aCu/wt",
	"nKjKQmESe8+1yoMuilxzlJGNDywFlkor2kvJdTNE8tPbi89Ii1sQLliNZ2psIE2xQAVybPkr2Dzs5bzG",
	"DC/JmjA1vmRlJUV9py4yfiPHwPAEwRlwLZM4qvVUgtd6mATneE4zqo/E3iXoTkYm8Bd2agBxcHoR5ccQ",
	"tb9vODJhOKej49ELG51e5hJN4cEvqVWrhLsIYC5VtDg9tJD2jbCULCizaZDwZMGeEYfsiLUsqhJTZ6k3",
	"FjxvJm1eOpHqDU83Ax6uq96cC5mGFVdOY1KNMzbGRRpjPbILs8BtehmdN1+cNsNHGesPLx7u799jsQbN",
	"w18MWg6p/moHja+mhlATob8o4FELizOSIjvEt/HoyKwvBlWJh6n3+uS38ejlkC7h247ffBdQSVn+ex6O",
	"yBQ2QfSW6r7ontNSmp+BxD/9WjlKv0Gwr+H8Gr/QvCou83W0JDHPNpWqqptqCVsanuxCRqpIAMhHM4JO",
	"eET0MOWrUaZcffmi6e9f42lt800YmQVvhTpHjWWK1SukXW+EfrknqQ55u0p2vQd57qqelih4COqI741P",
	"GuV0X7T6GGWEthgjRozcNAYDbgK3ChLkmpKbxsaGVXvvwfs66z5HizUP4kkHjwZE+26XNYGs+PZc3MNt",
	"bW1TWwgk4AfTrzT91soUfiH6wlTmHSYtsWidRZ9TPNdqI0Zl9YzI3CH9/EKURzw1thBbetVk6j2E/CRH",
	"fNCeu8ovsOdH/RtYvnD7EDuuNwbXIRm63dMUSky1y0z2pVFka2khzPr3Nyxbdf8tfnjmEq869ggCzzZA",
	"tBPaqS0ShgRJOLixK+7yIKAMeKwZ9MWy4pmmh5IOcCYITjfI0FL6PMfAYBNxtg3vq2r8RnneJ6IEJdcE",
	"JTaMwSpNQdKj5yoO3XY2A6jB+2z25iNSVu11uch+ngQrEHadKZKeSPxg3CmGNW9TSuPRF5P0laxaLbqi",
	"YKBoRvdBFskKYTlkF3xP7SPJLzFn8BMzmG3JwJoMG0TwHHKM3fDhpKOPc0rmxXLizCkdYsy8WEZkGFMJ",
	"EyasznTqF+uUxuBhqbAOVeOklwVkR496jdSr1EZvkPqS28588/TWu/r4ty8TGeyHzv8e1aOyXkAaNtsg",
	"RjQY5swabtthfzkJn0p4MAPM8FKL3Ir6dzUmP7Z1xSkiA423N1iWukv80aw2xDiDdVrPzO11mEXoNKwi",
	"+Rg3UpMCPYKGyjaWnqGQ2MSkl05NEbZWsv5onEASQaeqFo8xkBjHkEnhtDWOTGUjpzR52DOmUlPbSZb5",
	"ppFKN/btf1etbZKRa5KhFV2uMrpcgcPZO7R7l+wSAlZJoqRfImi+cUEEe8im67p4yxLKl8gFboBnC0C7",
	"ZDkWEKXtykKZcHAb8QG+CGPzDQ9uvYzQI12/bQW3nvgKbi2aFDNHhtj/Pu7hoPpVWY3Qo2fZcnpWUA+p",
	"9R4+gUo5dBFcuhLZoF8Y34ywiV2sptjSY96qtXJO0e2CKBINtYM0RJ0ZwtQEarszBSToT0pnRrcaYlpn",
	"G5MeVPcDUGICq/4oaHJVBdE1kOeVGeizyjZrwJUV2soKcDETrUtIq3AdFJrzi8Z114x7VBtPrN5CZKNN",
	"M7PyB9OJzFbG9jAQb20kmiEW/7H0DsN9llUPyoc2+9JWv4felGzfMXRTSDAjuMzyk5dsJxyJcQTv2ArC",
	"dvV1oXT7a1Ow8P+aiqWKoyUJoYhdAxrUiyrQrpMK/UKHAXyoA7w2yizhjZNnW2mnFn9FOf98g2wx3tis",
	"BvG1Gf3hJjbe/hi1xNt7ezIp8wSOmxkDgCXdBnod10Ia7VdIZuZrqpSew+3/6/NzD7OMV+Sye+nnatjc",
	"AS+E1uUkRKrdP+b5beRtdHhhyrPzYE4YP/+heV77XC8sNSlt1gljbRYnPPUD02Iqz0X59fG8LrWI72dx",
	"utRzrKI3sFcU4GHkpaPDw4dTzFufMOhUfGqvBEBGCiEpXLpVeNDD0LF5WM+QoBfg3n39TO2573Aa2Lh5",
	"LlAVRL8uMkXzKpcQHh/BSFK2zEgVh9Ig+zdFdmUH9C6MxyB+b6ZnUhcCCNqJRTerMFZpDJooDvdfPTU4",
	"H60i6CoePpOqAljBjeSNbj4dELYgUtkavHHC/mQaVLRcJhbWL9o5Tq70ia1eOSxklLTtkKe63WMSdjDP",
	"M5J3DY4O72qWGezBa9YmqbnO4R+a2AcD952Q/GB6HED8Rsdv1S0uKhNASeSFeW7vr+fo/Ozf3kK6vlZC",
	"8RJTJo093T7eR0mWemYtxXNPJhUphF3NN6iefY00DISlWmW5ZOdaq4QnTNHhPlpzqSqN2L2NVg1bi82O",
	"KSFmTUPVEIuB6mlFs7bS1rdTSCJLbLQpIO7Piii9iuGgDzfMpl/vVJl9S738wNfLXz6nWh7Pc283mLkC",
	"3c90Bi0UgSZoc1r6jtwDBdy0KQy/EFVpC9vFYFQxdk+x1UOE/GePsZE1QNrUvk4HthvEvXtTOq39hFAo",
	"0sWFp9yD+LB3yT5ASHrpMwC2KtENzTKtGlj/bYzTBZm896aGx/KW30XvfBZi7PGUP21Mjq2toQRmJt1U",
	"046X3mHSQp7l3LRQ/UDWONV4pKwgA9zJngZrn36xfW1oP2ZGn/ayG8aXjLIVEdT4ypQMnw1fUS1bbWKn",
	"6cSO/f2epxqEz2XJqUPRTszvvf0LQmifmmQdzOb1KXGlL9rBlhGg2hUW6SQlWiOfQKa2IVv9d9RxvMbM",
	"yLCmDcJWdjdpn1acL8PtNTEHj9zSBaLKZiZlG5MbvnfJXvv1ahPOJDVStskdN51WWCLG0ZpgRtlyUWTl",
	"I1E7jBspZqwbgBQ5Lh0GkI0MH/wM+t3YSfkVi/QUlvVWzwuK1aPIJEeRvDdYaaAHQY2BEN1PH0t5Ue0L",
	"mPkATC7MOysG3mlVsOhZDkGMKpmFNEDo0DNRlmdqZ+UXBOKAUNkUSbqEIhIc4dIx7Hg3SrDRPqFuxiVz",
	"NjC0FDghcCHH6LH+IMn3Khi3PpzSRU9VCaznFUz8V0Ypq7YOSnI8Cz2X6GxS0lAKzsBW3sXKT0P2HUgj",
	"htMqNCeEITMUSdGGxILn9ShPyihPA3gtW/w+SMjySMo8Qyp5rgDz2PZu5/0rHS7BGGNPdrcsDa5500jx",
	"2glquNJh0AelmIeIpEzCCM2zxXuu3nr55F2lTK1Y38x0NXJLyolkP1QPXEfLpqxz1V5Z1Hw3Lw2aN3dO",
	"XJ2snmBOM/BThHM+kK5acpv/Zgf6f6ir9k7il5cC3BNiBk+0FlkW1YVN7bmKbZVR8pfMzTD2SuOb8gDw",
	"t7XRxkSyykr5zkH5nQplJx5KerIqKtSVqH82w2USBWcg5biXcweQDgQ6l+1RgnNVCHiKB+oWejWXxkiu",
	"+A3QDfwKBdjcUzfwQLEzbcNzVxApoOiadJNPWRTyu7V2N6pWRojn5wCLz0c14W52kEuG5Wpiq5gOoBJT",
	"TtW194oc6D3WxFBatxu3f3Tv/RqlfR68ZqXp6qlhzdqSapyY98yvOVa/7LtKEYw7nxR2kwxzFj5pfF20",
	"/mtXkF2wt8/lkIOE6JKsajC10zFUrZlCCRtXKqOQREykV8Osm7ShUG8uyIIIwhIbJe/ZvBvEG5TOesSN",
	"jBb7iuyjble5ph45K7TwJ7tbOuh2CG8W53vU1M9YFcAn1hKG7rtr8z1mgA4gk29QCdgUZpukfsWvFqeR",
	"yz3BjeJlQEE3NkGOqlpNtgZJNcrBPRJFtVbLe2KCai9/16knec5Iowg8CIE4YOqbSMwz8I2kJN3ZvY7c",
	"EA3OoXyWTUQq326pSq21PaUKEqOdqmHRhkwfmx3kQr5VIct3XGV109usoKasUKrxdEGSTQIBR64om9e9",
	"Cm9vvBxbrDGbUDZRKzLJOM9Rs5BbNdBrr1pR86JrKfRWdX97bUtnxSvUmpK05fKNPpnBFit6TZBfzdKO",
	"+BHelokmYBBkXjx2kpQp3n9Nly6Q2A5hKKA5xOuwWBr0jyHXVtv69uXbfwUAAP//hJb016W/AAA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
