import globals from 'globals'
import js from '@eslint/js'
import tseslint from 'typescript-eslint'
import eslintConfigPrettier from 'eslint-config-prettier/flat'
import reactHooks from 'eslint-plugin-react-hooks'

export default [
  {
    ignores: ['dist/**/*', 'src-tauri/target/**/*', 'storybook-static/**/*', '.storybook/**/*'],
  },
  {
    files: ['**/*.{js,mjs,cjs,ts,tsx}'],
    ...js.configs.recommended,
  },
  {
    files: ['src/**/*.{ts,tsx}', 'testing-library.ts'],
    languageOptions: {
      parser: tseslint.parser,
      parserOptions: {
        project: './tsconfig.json',
        ecmaFeatures: {
          jsx: true,
        },
      },
      globals: {
        ...globals.browser,
        expect: 'readonly',
        NodeJS: 'readonly',
      },
    },
    plugins: {
      '@typescript-eslint': tseslint.plugin,
      'react-hooks': reactHooks,
    },
    rules: {
      ...tseslint.configs.recommended.rules,
      ...reactHooks.configs['recommended-latest'].rules,
      'no-undef': 'error',
      '@typescript-eslint/no-unused-vars': 'error',
      'react/react-in-jsx-scope': 'off',
      // Per docs, no-unused-vars needs to be off when we're using `typescript-eslint`'s no-unused-vars
      'no-unused-vars': 'off',
      // Disable exhaustive-deps rule for React hooks
      'react-hooks/exhaustive-deps': 'off',
    },
  },
  {
    files: ['*.config.{ts,js}', '.prettierrc.js'],
    languageOptions: {
      parser: tseslint.parser,
      globals: {
        ...globals.node,
      },
    },
    rules: {
      'no-undef': 'error',
    },
  },
  eslintConfigPrettier,
]
