/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { SessionStatus } from './SessionStatus';
import {
    SessionStatusFromJSON,
    SessionStatusFromJSONTyped,
    SessionStatusToJSON,
    SessionStatusToJSONTyped,
} from './SessionStatus';

/**
 * 
 * @export
 * @interface UpdateSessionRequest
 */
export interface UpdateSessionRequest {
    /**
     * Enable/disable auto-accept for edit tools
     * @type {boolean}
     * @memberof UpdateSessionRequest
     */
    autoAcceptEdits?: boolean;
    /**
     * Enable or disable dangerously skip permissions mode
     * @type {boolean}
     * @memberof UpdateSessionRequest
     */
    dangerouslySkipPermissions?: boolean;
    /**
     * Optional timeout in milliseconds for dangerously skip permissions mode
     * @type {number}
     * @memberof UpdateSessionRequest
     */
    dangerouslySkipPermissionsTimeoutMs?: number;
    /**
     * Archive/unarchive the session
     * @type {boolean}
     * @memberof UpdateSessionRequest
     */
    archived?: boolean;
    /**
     * Update session title
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    title?: string;
    /**
     * Model to use (opus, sonnet, or empty for default)
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    model?: string;
    /**
     * Full model identifier
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    modelId?: string;
    /**
     * Enable proxy routing for this session
     * @type {boolean}
     * @memberof UpdateSessionRequest
     */
    proxyEnabled?: boolean;
    /**
     * Base URL for proxy service
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    proxyBaseUrl?: string;
    /**
     * Model identifier for proxy routing
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    proxyModelOverride?: string;
    /**
     * API key for proxy authentication
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    proxyApiKey?: string;
    /**
     * Update additional directories Claude can access
     * @type {Array<string>}
     * @memberof UpdateSessionRequest
     */
    additionalDirectories?: Array<string>;
    /**
     * Update the working directory for the session
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    workingDir?: string;
    /**
     * JSON blob of editor state for draft sessions
     * @type {string}
     * @memberof UpdateSessionRequest
     */
    editorState?: string;
    /**
     * Update session status (only draft ↔ discarded transitions allowed)
     * @type {SessionStatus}
     * @memberof UpdateSessionRequest
     */
    status?: SessionStatus;
}



/**
 * Check if a given object implements the UpdateSessionRequest interface.
 */
export function instanceOfUpdateSessionRequest(value: object): value is UpdateSessionRequest {
    return true;
}

export function UpdateSessionRequestFromJSON(json: any): UpdateSessionRequest {
    return UpdateSessionRequestFromJSONTyped(json, false);
}

export function UpdateSessionRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): UpdateSessionRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'autoAcceptEdits': json['auto_accept_edits'] == null ? undefined : json['auto_accept_edits'],
        'dangerouslySkipPermissions': json['dangerously_skip_permissions'] == null ? undefined : json['dangerously_skip_permissions'],
        'dangerouslySkipPermissionsTimeoutMs': json['dangerously_skip_permissions_timeout_ms'] == null ? undefined : json['dangerously_skip_permissions_timeout_ms'],
        'archived': json['archived'] == null ? undefined : json['archived'],
        'title': json['title'] == null ? undefined : json['title'],
        'model': json['model'] == null ? undefined : json['model'],
        'modelId': json['model_id'] == null ? undefined : json['model_id'],
        'proxyEnabled': json['proxy_enabled'] == null ? undefined : json['proxy_enabled'],
        'proxyBaseUrl': json['proxy_base_url'] == null ? undefined : json['proxy_base_url'],
        'proxyModelOverride': json['proxy_model_override'] == null ? undefined : json['proxy_model_override'],
        'proxyApiKey': json['proxy_api_key'] == null ? undefined : json['proxy_api_key'],
        'additionalDirectories': json['additional_directories'] == null ? undefined : json['additional_directories'],
        'workingDir': json['working_dir'] == null ? undefined : json['working_dir'],
        'editorState': json['editor_state'] == null ? undefined : json['editor_state'],
        'status': json['status'] == null ? undefined : SessionStatusFromJSON(json['status']),
    };
}

export function UpdateSessionRequestToJSON(json: any): UpdateSessionRequest {
    return UpdateSessionRequestToJSONTyped(json, false);
}

export function UpdateSessionRequestToJSONTyped(value?: UpdateSessionRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'auto_accept_edits': value['autoAcceptEdits'],
        'dangerously_skip_permissions': value['dangerouslySkipPermissions'],
        'dangerously_skip_permissions_timeout_ms': value['dangerouslySkipPermissionsTimeoutMs'],
        'archived': value['archived'],
        'title': value['title'],
        'model': value['model'],
        'model_id': value['modelId'],
        'proxy_enabled': value['proxyEnabled'],
        'proxy_base_url': value['proxyBaseUrl'],
        'proxy_model_override': value['proxyModelOverride'],
        'proxy_api_key': value['proxyApiKey'],
        'additional_directories': value['additionalDirectories'],
        'working_dir': value['workingDir'],
        'editor_state': value['editorState'],
        'status': SessionStatusToJSON(value['status']),
    };
}

