/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { MCPConfig } from './MCPConfig';
import {
    MCPConfigFromJSON,
    MCPConfigFromJSONTyped,
    MCPConfigToJSON,
    MCPConfigToJSONTyped,
} from './MCPConfig';

/**
 * 
 * @export
 * @interface CreateSessionRequest
 */
export interface CreateSessionRequest {
    /**
     * Initial query for Claude
     * @type {string}
     * @memberof CreateSessionRequest
     */
    query: string;
    /**
     * Optional title for the session
     * @type {string}
     * @memberof CreateSessionRequest
     */
    title?: string;
    /**
     * Model to use for the session
     * @type {string}
     * @memberof CreateSessionRequest
     */
    model?: CreateSessionRequestModelEnum;
    /**
     * 
     * @type {MCPConfig}
     * @memberof CreateSessionRequest
     */
    mcpConfig?: MCPConfig;
    /**
     * MCP tool for permission prompts
     * @type {string}
     * @memberof CreateSessionRequest
     */
    permissionPromptTool?: string;
    /**
     * Working directory for the session
     * @type {string}
     * @memberof CreateSessionRequest
     */
    workingDir?: string;
    /**
     * Maximum conversation turns
     * @type {number}
     * @memberof CreateSessionRequest
     */
    maxTurns?: number;
    /**
     * Override system prompt
     * @type {string}
     * @memberof CreateSessionRequest
     */
    systemPrompt?: string;
    /**
     * Text to append to system prompt
     * @type {string}
     * @memberof CreateSessionRequest
     */
    appendSystemPrompt?: string;
    /**
     * Whitelist of allowed tools
     * @type {Array<string>}
     * @memberof CreateSessionRequest
     */
    allowedTools?: Array<string>;
    /**
     * Blacklist of disallowed tools
     * @type {Array<string>}
     * @memberof CreateSessionRequest
     */
    disallowedTools?: Array<string>;
    /**
     * Additional directories Claude can access
     * @type {Array<string>}
     * @memberof CreateSessionRequest
     */
    additionalDirectories?: Array<string>;
    /**
     * Custom instructions for Claude
     * @type {string}
     * @memberof CreateSessionRequest
     */
    customInstructions?: string;
    /**
     * Enable auto-accept for edit tools
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    autoAcceptEdits?: boolean;
    /**
     * Launch session with dangerously skip permissions enabled
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    dangerouslySkipPermissions?: boolean;
    /**
     * Optional default timeout in milliseconds for dangerously skip permissions
     * @type {number}
     * @memberof CreateSessionRequest
     */
    dangerouslySkipPermissionsTimeout?: number;
    /**
     * Enable verbose output
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    verbose?: boolean;
    /**
     * Enable proxy routing for this session
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    proxyEnabled?: boolean;
    /**
     * Base URL for proxy service
     * @type {string}
     * @memberof CreateSessionRequest
     */
    proxyBaseUrl?: string;
    /**
     * Model identifier for proxy routing
     * @type {string}
     * @memberof CreateSessionRequest
     */
    proxyModelOverride?: string;
    /**
     * API key for proxy authentication
     * @type {string}
     * @memberof CreateSessionRequest
     */
    proxyApiKey?: string;
    /**
     * Create session in draft state without launching Claude
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    draft?: boolean;
    /**
     * Create the working directory if it does not exist
     * @type {boolean}
     * @memberof CreateSessionRequest
     */
    createDirectoryIfNotExists?: boolean;
}


/**
 * @export
 */
export const CreateSessionRequestModelEnum = {
    Opus: 'opus',
    Sonnet: 'sonnet',
    Haiku: 'haiku'
} as const;
export type CreateSessionRequestModelEnum = typeof CreateSessionRequestModelEnum[keyof typeof CreateSessionRequestModelEnum];


/**
 * Check if a given object implements the CreateSessionRequest interface.
 */
export function instanceOfCreateSessionRequest(value: object): value is CreateSessionRequest {
    if (!('query' in value) || value['query'] === undefined) return false;
    return true;
}

export function CreateSessionRequestFromJSON(json: any): CreateSessionRequest {
    return CreateSessionRequestFromJSONTyped(json, false);
}

export function CreateSessionRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): CreateSessionRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'query': json['query'],
        'title': json['title'] == null ? undefined : json['title'],
        'model': json['model'] == null ? undefined : json['model'],
        'mcpConfig': json['mcp_config'] == null ? undefined : MCPConfigFromJSON(json['mcp_config']),
        'permissionPromptTool': json['permission_prompt_tool'] == null ? undefined : json['permission_prompt_tool'],
        'workingDir': json['working_dir'] == null ? undefined : json['working_dir'],
        'maxTurns': json['max_turns'] == null ? undefined : json['max_turns'],
        'systemPrompt': json['system_prompt'] == null ? undefined : json['system_prompt'],
        'appendSystemPrompt': json['append_system_prompt'] == null ? undefined : json['append_system_prompt'],
        'allowedTools': json['allowed_tools'] == null ? undefined : json['allowed_tools'],
        'disallowedTools': json['disallowed_tools'] == null ? undefined : json['disallowed_tools'],
        'additionalDirectories': json['additional_directories'] == null ? undefined : json['additional_directories'],
        'customInstructions': json['custom_instructions'] == null ? undefined : json['custom_instructions'],
        'autoAcceptEdits': json['auto_accept_edits'] == null ? undefined : json['auto_accept_edits'],
        'dangerouslySkipPermissions': json['dangerously_skip_permissions'] == null ? undefined : json['dangerously_skip_permissions'],
        'dangerouslySkipPermissionsTimeout': json['dangerously_skip_permissions_timeout'] == null ? undefined : json['dangerously_skip_permissions_timeout'],
        'verbose': json['verbose'] == null ? undefined : json['verbose'],
        'proxyEnabled': json['proxy_enabled'] == null ? undefined : json['proxy_enabled'],
        'proxyBaseUrl': json['proxy_base_url'] == null ? undefined : json['proxy_base_url'],
        'proxyModelOverride': json['proxy_model_override'] == null ? undefined : json['proxy_model_override'],
        'proxyApiKey': json['proxy_api_key'] == null ? undefined : json['proxy_api_key'],
        'draft': json['draft'] == null ? undefined : json['draft'],
        'createDirectoryIfNotExists': json['createDirectoryIfNotExists'] == null ? undefined : json['createDirectoryIfNotExists'],
    };
}

export function CreateSessionRequestToJSON(json: any): CreateSessionRequest {
    return CreateSessionRequestToJSONTyped(json, false);
}

export function CreateSessionRequestToJSONTyped(value?: CreateSessionRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'query': value['query'],
        'title': value['title'],
        'model': value['model'],
        'mcp_config': MCPConfigToJSON(value['mcpConfig']),
        'permission_prompt_tool': value['permissionPromptTool'],
        'working_dir': value['workingDir'],
        'max_turns': value['maxTurns'],
        'system_prompt': value['systemPrompt'],
        'append_system_prompt': value['appendSystemPrompt'],
        'allowed_tools': value['allowedTools'],
        'disallowed_tools': value['disallowedTools'],
        'additional_directories': value['additionalDirectories'],
        'custom_instructions': value['customInstructions'],
        'auto_accept_edits': value['autoAcceptEdits'],
        'dangerously_skip_permissions': value['dangerouslySkipPermissions'],
        'dangerously_skip_permissions_timeout': value['dangerouslySkipPermissionsTimeout'],
        'verbose': value['verbose'],
        'proxy_enabled': value['proxyEnabled'],
        'proxy_base_url': value['proxyBaseUrl'],
        'proxy_model_override': value['proxyModelOverride'],
        'proxy_api_key': value['proxyApiKey'],
        'draft': value['draft'],
        'createDirectoryIfNotExists': value['createDirectoryIfNotExists'],
    };
}

