/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
import type { SessionStatus } from './SessionStatus';
import {
    SessionStatusFromJSON,
    SessionStatusFromJSONTyped,
    SessionStatusToJSON,
    SessionStatusToJSONTyped,
} from './SessionStatus';

/**
 * 
 * @export
 * @interface Session
 */
export interface Session {
    /**
     * Unique session identifier
     * @type {string}
     * @memberof Session
     */
    id: string;
    /**
     * Unique run identifier
     * @type {string}
     * @memberof Session
     */
    runId: string;
    /**
     * Claude's internal session ID
     * @type {string}
     * @memberof Session
     */
    claudeSessionId?: string;
    /**
     * Parent session ID if this is a forked session
     * @type {string}
     * @memberof Session
     */
    parentSessionId?: string;
    /**
     * 
     * @type {SessionStatus}
     * @memberof Session
     */
    status: SessionStatus;
    /**
     * Initial query that started the session
     * @type {string}
     * @memberof Session
     */
    query: string;
    /**
     * AI-generated summary of the session
     * @type {string}
     * @memberof Session
     */
    summary?: string;
    /**
     * User-editable session title
     * @type {string}
     * @memberof Session
     */
    title?: string;
    /**
     * Model used for this session
     * @type {string}
     * @memberof Session
     */
    model?: string;
    /**
     * Full model identifier
     * @type {string}
     * @memberof Session
     */
    modelId?: string;
    /**
     * Working directory for the session
     * @type {string}
     * @memberof Session
     */
    workingDir?: string;
    /**
     * Additional directories Claude can access
     * @type {Array<string>}
     * @memberof Session
     */
    additionalDirectories?: Array<string>;
    /**
     * Session creation timestamp
     * @type {Date}
     * @memberof Session
     */
    createdAt: Date;
    /**
     * Last activity timestamp
     * @type {Date}
     * @memberof Session
     */
    lastActivityAt: Date;
    /**
     * Session completion timestamp
     * @type {Date}
     * @memberof Session
     */
    completedAt?: Date;
    /**
     * Error message if session failed
     * @type {string}
     * @memberof Session
     */
    errorMessage?: string;
    /**
     * Total cost in USD
     * @type {number}
     * @memberof Session
     */
    costUsd?: number;
    /**
     * Number of input tokens
     * @type {number}
     * @memberof Session
     */
    inputTokens?: number;
    /**
     * Number of output tokens
     * @type {number}
     * @memberof Session
     */
    outputTokens?: number;
    /**
     * Number of cache creation input tokens
     * @type {number}
     * @memberof Session
     */
    cacheCreationInputTokens?: number;
    /**
     * Number of cache read input tokens
     * @type {number}
     * @memberof Session
     */
    cacheReadInputTokens?: number;
    /**
     * Total tokens counting toward context window limit
     * @type {number}
     * @memberof Session
     */
    effectiveContextTokens?: number;
    /**
     * Context window limit for the model
     * @type {number}
     * @memberof Session
     */
    contextLimit?: number;
    /**
     * Session duration in milliseconds
     * @type {number}
     * @memberof Session
     */
    durationMs?: number;
    /**
     * Whether edit tools are auto-accepted
     * @type {boolean}
     * @memberof Session
     */
    autoAcceptEdits?: boolean;
    /**
     * When true, all tool calls are automatically approved without user consent
     * @type {boolean}
     * @memberof Session
     */
    dangerouslySkipPermissions?: boolean;
    /**
     * ISO timestamp when dangerously skip permissions mode expires (optional)
     * @type {Date}
     * @memberof Session
     */
    dangerouslySkipPermissionsExpiresAt?: Date;
    /**
     * Whether session is archived
     * @type {boolean}
     * @memberof Session
     */
    archived?: boolean;
    /**
     * Whether proxy is enabled for this session
     * @type {boolean}
     * @memberof Session
     */
    proxyEnabled?: boolean;
    /**
     * Base URL of the proxy server
     * @type {string}
     * @memberof Session
     */
    proxyBaseUrl?: string;
    /**
     * Model to use with the proxy
     * @type {string}
     * @memberof Session
     */
    proxyModelOverride?: string;
    /**
     * JSON blob of editor state for draft sessions
     * @type {string}
     * @memberof Session
     */
    editorState?: string;
}



/**
 * Check if a given object implements the Session interface.
 */
export function instanceOfSession(value: object): value is Session {
    if (!('id' in value) || value['id'] === undefined) return false;
    if (!('runId' in value) || value['runId'] === undefined) return false;
    if (!('status' in value) || value['status'] === undefined) return false;
    if (!('query' in value) || value['query'] === undefined) return false;
    if (!('createdAt' in value) || value['createdAt'] === undefined) return false;
    if (!('lastActivityAt' in value) || value['lastActivityAt'] === undefined) return false;
    return true;
}

export function SessionFromJSON(json: any): Session {
    return SessionFromJSONTyped(json, false);
}

export function SessionFromJSONTyped(json: any, ignoreDiscriminator: boolean): Session {
    if (json == null) {
        return json;
    }
    return {
        
        'id': json['id'],
        'runId': json['run_id'],
        'claudeSessionId': json['claude_session_id'] == null ? undefined : json['claude_session_id'],
        'parentSessionId': json['parent_session_id'] == null ? undefined : json['parent_session_id'],
        'status': SessionStatusFromJSON(json['status']),
        'query': json['query'],
        'summary': json['summary'] == null ? undefined : json['summary'],
        'title': json['title'] == null ? undefined : json['title'],
        'model': json['model'] == null ? undefined : json['model'],
        'modelId': json['model_id'] == null ? undefined : json['model_id'],
        'workingDir': json['working_dir'] == null ? undefined : json['working_dir'],
        'additionalDirectories': json['additional_directories'] == null ? undefined : json['additional_directories'],
        'createdAt': (new Date(json['created_at'])),
        'lastActivityAt': (new Date(json['last_activity_at'])),
        'completedAt': json['completed_at'] == null ? undefined : (new Date(json['completed_at'])),
        'errorMessage': json['error_message'] == null ? undefined : json['error_message'],
        'costUsd': json['cost_usd'] == null ? undefined : json['cost_usd'],
        'inputTokens': json['input_tokens'] == null ? undefined : json['input_tokens'],
        'outputTokens': json['output_tokens'] == null ? undefined : json['output_tokens'],
        'cacheCreationInputTokens': json['cache_creation_input_tokens'] == null ? undefined : json['cache_creation_input_tokens'],
        'cacheReadInputTokens': json['cache_read_input_tokens'] == null ? undefined : json['cache_read_input_tokens'],
        'effectiveContextTokens': json['effective_context_tokens'] == null ? undefined : json['effective_context_tokens'],
        'contextLimit': json['context_limit'] == null ? undefined : json['context_limit'],
        'durationMs': json['duration_ms'] == null ? undefined : json['duration_ms'],
        'autoAcceptEdits': json['auto_accept_edits'] == null ? undefined : json['auto_accept_edits'],
        'dangerouslySkipPermissions': json['dangerously_skip_permissions'] == null ? undefined : json['dangerously_skip_permissions'],
        'dangerouslySkipPermissionsExpiresAt': json['dangerously_skip_permissions_expires_at'] == null ? undefined : (new Date(json['dangerously_skip_permissions_expires_at'])),
        'archived': json['archived'] == null ? undefined : json['archived'],
        'proxyEnabled': json['proxy_enabled'] == null ? undefined : json['proxy_enabled'],
        'proxyBaseUrl': json['proxy_base_url'] == null ? undefined : json['proxy_base_url'],
        'proxyModelOverride': json['proxy_model_override'] == null ? undefined : json['proxy_model_override'],
        'editorState': json['editor_state'] == null ? undefined : json['editor_state'],
    };
}

export function SessionToJSON(json: any): Session {
    return SessionToJSONTyped(json, false);
}

export function SessionToJSONTyped(value?: Session | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'id': value['id'],
        'run_id': value['runId'],
        'claude_session_id': value['claudeSessionId'],
        'parent_session_id': value['parentSessionId'],
        'status': SessionStatusToJSON(value['status']),
        'query': value['query'],
        'summary': value['summary'],
        'title': value['title'],
        'model': value['model'],
        'model_id': value['modelId'],
        'working_dir': value['workingDir'],
        'additional_directories': value['additionalDirectories'],
        'created_at': ((value['createdAt']).toISOString()),
        'last_activity_at': ((value['lastActivityAt']).toISOString()),
        'completed_at': value['completedAt'] == null ? undefined : ((value['completedAt']).toISOString()),
        'error_message': value['errorMessage'],
        'cost_usd': value['costUsd'],
        'input_tokens': value['inputTokens'],
        'output_tokens': value['outputTokens'],
        'cache_creation_input_tokens': value['cacheCreationInputTokens'],
        'cache_read_input_tokens': value['cacheReadInputTokens'],
        'effective_context_tokens': value['effectiveContextTokens'],
        'context_limit': value['contextLimit'],
        'duration_ms': value['durationMs'],
        'auto_accept_edits': value['autoAcceptEdits'],
        'dangerously_skip_permissions': value['dangerouslySkipPermissions'],
        'dangerously_skip_permissions_expires_at': value['dangerouslySkipPermissionsExpiresAt'] == null ? undefined : ((value['dangerouslySkipPermissionsExpiresAt']).toISOString()),
        'archived': value['archived'],
        'proxy_enabled': value['proxyEnabled'],
        'proxy_base_url': value['proxyBaseUrl'],
        'proxy_model_override': value['proxyModelOverride'],
        'editor_state': value['editorState'],
    };
}

