/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface ConversationEvent
 */
export interface ConversationEvent {
    /**
     * 
     * @type {number}
     * @memberof ConversationEvent
     */
    id: number;
    /**
     * 
     * @type {string}
     * @memberof ConversationEvent
     */
    sessionId: string;
    /**
     * 
     * @type {string}
     * @memberof ConversationEvent
     */
    claudeSessionId?: string;
    /**
     * Sequence number in conversation
     * @type {number}
     * @memberof ConversationEvent
     */
    sequence: number;
    /**
     * Type of conversation event
     * @type {string}
     * @memberof ConversationEvent
     */
    eventType: ConversationEventEventTypeEnum;
    /**
     * 
     * @type {Date}
     * @memberof ConversationEvent
     */
    createdAt: Date;
    /**
     * Message role (for message events)
     * @type {string}
     * @memberof ConversationEvent
     */
    role?: ConversationEventRoleEnum;
    /**
     * Message content
     * @type {string}
     * @memberof ConversationEvent
     */
    content?: string;
    /**
     * Tool invocation ID (for tool events)
     * @type {string}
     * @memberof ConversationEvent
     */
    toolId?: string;
    /**
     * Tool name (for tool_call events)
     * @type {string}
     * @memberof ConversationEvent
     */
    toolName?: string;
    /**
     * JSON string of tool input (for tool_call events)
     * @type {string}
     * @memberof ConversationEvent
     */
    toolInputJson?: string;
    /**
     * Parent tool use ID for nested calls
     * @type {string}
     * @memberof ConversationEvent
     */
    parentToolUseId?: string;
    /**
     * Tool call ID this result is for
     * @type {string}
     * @memberof ConversationEvent
     */
    toolResultForId?: string;
    /**
     * Tool result content
     * @type {string}
     * @memberof ConversationEvent
     */
    toolResultContent?: string;
    /**
     * Whether tool call has received result
     * @type {boolean}
     * @memberof ConversationEvent
     */
    isCompleted?: boolean;
    /**
     * Approval status for tool calls
     * @type {string}
     * @memberof ConversationEvent
     */
    approvalStatus?: ConversationEventApprovalStatusEnum;
    /**
     * Associated approval ID
     * @type {string}
     * @memberof ConversationEvent
     */
    approvalId?: string;
}


/**
 * @export
 */
export const ConversationEventEventTypeEnum = {
    Message: 'message',
    ToolCall: 'tool_call',
    ToolResult: 'tool_result',
    System: 'system',
    Thinking: 'thinking'
} as const;
export type ConversationEventEventTypeEnum = typeof ConversationEventEventTypeEnum[keyof typeof ConversationEventEventTypeEnum];

/**
 * @export
 */
export const ConversationEventRoleEnum = {
    User: 'user',
    Assistant: 'assistant',
    System: 'system'
} as const;
export type ConversationEventRoleEnum = typeof ConversationEventRoleEnum[keyof typeof ConversationEventRoleEnum];

/**
 * @export
 */
export const ConversationEventApprovalStatusEnum = {
    Pending: 'pending',
    Approved: 'approved',
    Denied: 'denied',
    Resolved: 'resolved'
} as const;
export type ConversationEventApprovalStatusEnum = typeof ConversationEventApprovalStatusEnum[keyof typeof ConversationEventApprovalStatusEnum];


/**
 * Check if a given object implements the ConversationEvent interface.
 */
export function instanceOfConversationEvent(value: object): value is ConversationEvent {
    if (!('id' in value) || value['id'] === undefined) return false;
    if (!('sessionId' in value) || value['sessionId'] === undefined) return false;
    if (!('sequence' in value) || value['sequence'] === undefined) return false;
    if (!('eventType' in value) || value['eventType'] === undefined) return false;
    if (!('createdAt' in value) || value['createdAt'] === undefined) return false;
    return true;
}

export function ConversationEventFromJSON(json: any): ConversationEvent {
    return ConversationEventFromJSONTyped(json, false);
}

export function ConversationEventFromJSONTyped(json: any, ignoreDiscriminator: boolean): ConversationEvent {
    if (json == null) {
        return json;
    }
    return {
        
        'id': json['id'],
        'sessionId': json['session_id'],
        'claudeSessionId': json['claude_session_id'] == null ? undefined : json['claude_session_id'],
        'sequence': json['sequence'],
        'eventType': json['event_type'],
        'createdAt': (new Date(json['created_at'])),
        'role': json['role'] == null ? undefined : json['role'],
        'content': json['content'] == null ? undefined : json['content'],
        'toolId': json['tool_id'] == null ? undefined : json['tool_id'],
        'toolName': json['tool_name'] == null ? undefined : json['tool_name'],
        'toolInputJson': json['tool_input_json'] == null ? undefined : json['tool_input_json'],
        'parentToolUseId': json['parent_tool_use_id'] == null ? undefined : json['parent_tool_use_id'],
        'toolResultForId': json['tool_result_for_id'] == null ? undefined : json['tool_result_for_id'],
        'toolResultContent': json['tool_result_content'] == null ? undefined : json['tool_result_content'],
        'isCompleted': json['is_completed'] == null ? undefined : json['is_completed'],
        'approvalStatus': json['approval_status'] == null ? undefined : json['approval_status'],
        'approvalId': json['approval_id'] == null ? undefined : json['approval_id'],
    };
}

export function ConversationEventToJSON(json: any): ConversationEvent {
    return ConversationEventToJSONTyped(json, false);
}

export function ConversationEventToJSONTyped(value?: ConversationEvent | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'id': value['id'],
        'session_id': value['sessionId'],
        'claude_session_id': value['claudeSessionId'],
        'sequence': value['sequence'],
        'event_type': value['eventType'],
        'created_at': ((value['createdAt']).toISOString()),
        'role': value['role'],
        'content': value['content'],
        'tool_id': value['toolId'],
        'tool_name': value['toolName'],
        'tool_input_json': value['toolInputJson'],
        'parent_tool_use_id': value['parentToolUseId'],
        'tool_result_for_id': value['toolResultForId'],
        'tool_result_content': value['toolResultContent'],
        'is_completed': value['isCompleted'],
        'approval_status': value['approvalStatus'],
        'approval_id': value['approvalId'],
    };
}

