/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ConfigResponse,
  ErrorResponse,
  UpdateConfigRequest,
  UpdateUserSettingsRequest,
  UserSettingsResponse,
} from '../models/index';
import {
    ConfigResponseFromJSON,
    ConfigResponseToJSON,
    ErrorResponseFromJSON,
    ErrorResponseToJSON,
    UpdateConfigRequestFromJSON,
    UpdateConfigRequestToJSON,
    UpdateUserSettingsRequestFromJSON,
    UpdateUserSettingsRequestToJSON,
    UserSettingsResponseFromJSON,
    UserSettingsResponseToJSON,
} from '../models/index';

export interface UpdateConfigOperationRequest {
    updateConfigRequest: UpdateConfigRequest;
}

export interface UpdateUserSettingsOperationRequest {
    updateUserSettingsRequest: UpdateUserSettingsRequest;
}

/**
 * SettingsApi - interface
 * 
 * @export
 * @interface SettingsApiInterface
 */
export interface SettingsApiInterface {
    /**
     * Retrieve current daemon configuration including Claude binary path
     * @summary Get daemon configuration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConfigResponse>>;

    /**
     * Retrieve current daemon configuration including Claude binary path
     * Get daemon configuration
     */
    getConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConfigResponse>;

    /**
     * Retrieve user preferences and settings
     * @summary Get user settings
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getUserSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSettingsResponse>>;

    /**
     * Retrieve user preferences and settings
     * Get user settings
     */
    getUserSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSettingsResponse>;

    /**
     * Update runtime daemon configuration such as Claude binary path
     * @summary Update daemon configuration
     * @param {UpdateConfigRequest} updateConfigRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    updateConfigRaw(requestParameters: UpdateConfigOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConfigResponse>>;

    /**
     * Update runtime daemon configuration such as Claude binary path
     * Update daemon configuration
     */
    updateConfig(requestParameters: UpdateConfigOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConfigResponse>;

    /**
     * Update user preferences and settings
     * @summary Update user settings
     * @param {UpdateUserSettingsRequest} updateUserSettingsRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    updateUserSettingsRaw(requestParameters: UpdateUserSettingsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSettingsResponse>>;

    /**
     * Update user preferences and settings
     * Update user settings
     */
    updateUserSettings(requestParameters: UpdateUserSettingsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSettingsResponse>;

}

/**
 * 
 */
export class SettingsApi extends runtime.BaseAPI implements SettingsApiInterface {

    /**
     * Retrieve current daemon configuration including Claude binary path
     * Get daemon configuration
     */
    async getConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConfigResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/config`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConfigResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve current daemon configuration including Claude binary path
     * Get daemon configuration
     */
    async getConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConfigResponse> {
        const response = await this.getConfigRaw(initOverrides);
        return await response.value();
    }

    /**
     * Retrieve user preferences and settings
     * Get user settings
     */
    async getUserSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSettingsResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};


        let urlPath = `/user-settings`;

        const response = await this.request({
            path: urlPath,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserSettingsResponseFromJSON(jsonValue));
    }

    /**
     * Retrieve user preferences and settings
     * Get user settings
     */
    async getUserSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSettingsResponse> {
        const response = await this.getUserSettingsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Update runtime daemon configuration such as Claude binary path
     * Update daemon configuration
     */
    async updateConfigRaw(requestParameters: UpdateConfigOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ConfigResponse>> {
        if (requestParameters['updateConfigRequest'] == null) {
            throw new runtime.RequiredError(
                'updateConfigRequest',
                'Required parameter "updateConfigRequest" was null or undefined when calling updateConfig().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/config`;

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateConfigRequestToJSON(requestParameters['updateConfigRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConfigResponseFromJSON(jsonValue));
    }

    /**
     * Update runtime daemon configuration such as Claude binary path
     * Update daemon configuration
     */
    async updateConfig(requestParameters: UpdateConfigOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ConfigResponse> {
        const response = await this.updateConfigRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Update user preferences and settings
     * Update user settings
     */
    async updateUserSettingsRaw(requestParameters: UpdateUserSettingsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UserSettingsResponse>> {
        if (requestParameters['updateUserSettingsRequest'] == null) {
            throw new runtime.RequiredError(
                'updateUserSettingsRequest',
                'Required parameter "updateUserSettingsRequest" was null or undefined when calling updateUserSettings().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/user-settings`;

        const response = await this.request({
            path: urlPath,
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: UpdateUserSettingsRequestToJSON(requestParameters['updateUserSettingsRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => UserSettingsResponseFromJSON(jsonValue));
    }

    /**
     * Update user preferences and settings
     * Update user settings
     */
    async updateUserSettings(requestParameters: UpdateUserSettingsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UserSettingsResponse> {
        const response = await this.updateUserSettingsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
