/* tslint:disable */
/* eslint-disable */
/**
 * HumanLayer Daemon REST API
 * REST API for HumanLayer daemon operations, providing session management, approval workflows, and real-time event streaming capabilities. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  DiscoverAgents200Response,
  DiscoverAgentsRequest,
  ErrorResponse,
} from '../models/index';
import {
    DiscoverAgents200ResponseFromJSON,
    DiscoverAgents200ResponseToJSON,
    DiscoverAgentsRequestFromJSON,
    DiscoverAgentsRequestToJSON,
    ErrorResponseFromJSON,
    ErrorResponseToJSON,
} from '../models/index';

export interface DiscoverAgentsOperationRequest {
    discoverAgentsRequest: DiscoverAgentsRequest;
}

/**
 * AgentsApi - interface
 * 
 * @export
 * @interface AgentsApiInterface
 */
export interface AgentsApiInterface {
    /**
     * Discovers agent definitions from .claude/agents directories
     * @summary Discover available agents
     * @param {DiscoverAgentsRequest} discoverAgentsRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AgentsApiInterface
     */
    discoverAgentsRaw(requestParameters: DiscoverAgentsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DiscoverAgents200Response>>;

    /**
     * Discovers agent definitions from .claude/agents directories
     * Discover available agents
     */
    discoverAgents(requestParameters: DiscoverAgentsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DiscoverAgents200Response>;

}

/**
 * 
 */
export class AgentsApi extends runtime.BaseAPI implements AgentsApiInterface {

    /**
     * Discovers agent definitions from .claude/agents directories
     * Discover available agents
     */
    async discoverAgentsRaw(requestParameters: DiscoverAgentsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DiscoverAgents200Response>> {
        if (requestParameters['discoverAgentsRequest'] == null) {
            throw new runtime.RequiredError(
                'discoverAgentsRequest',
                'Required parameter "discoverAgentsRequest" was null or undefined when calling discoverAgents().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';


        let urlPath = `/agents/discover`;

        const response = await this.request({
            path: urlPath,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: DiscoverAgentsRequestToJSON(requestParameters['discoverAgentsRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DiscoverAgents200ResponseFromJSON(jsonValue));
    }

    /**
     * Discovers agent definitions from .claude/agents directories
     * Discover available agents
     */
    async discoverAgents(requestParameters: DiscoverAgentsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DiscoverAgents200Response> {
        const response = await this.discoverAgentsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
