/**
 * Talisman stemmers/french/porter tests
 * ======================================
 *
 */
import assert from 'assert';
import porter from '../../../src/stemmers/french/porter';

describe('porter', function() {

  it('should properly stem French words.', function() {
    const tests = [
      ['abaisserai', 'abaiss'],
      ['acajou', 'acajou'],
      ['accomplissement', 'accompl'],
      ['accrédité', 'accred'],
      ['achevait', 'achev'],
      ['adjonction', 'adjonct'],
      ['administrés', 'administr'],
      ['adopter', 'adopt'],
      ['adorer', 'ador'],
      ['adoucissait', 'adouc'],
      ['adressant', 'adress'],
      ['affirmatif', 'affirm'],
      ['agenouillant', 'agenouill'],
      ['agissez', 'agiss'],
      ['aimerait', 'aim'],
      ['airs', 'air'],
      ['ajoutaient', 'ajout'],
      ['allusions', 'allus'],
      ['alphabet', 'alphabet'],
      ['ambition', 'ambit'],
      ['anciens', 'ancien'],
      ['anobli', 'anobl'],
      ['anodines', 'anodin'],
      ['antiquaires', 'antiquair'],
      ['apostat', 'apostat'],
      ['apparaît', 'apparaît'],
      ['appartenait', 'apparten'],
      ['apparut', 'apparut'],
      ['appui', 'appui'],
      ['appuyées', 'appui'],
      ['arbre', 'arbre'],
      ['armonica', 'armonic'],
      ['arrangements', 'arrang'],
      ['arrière', 'arrier'],
      ['arsenic', 'arsenic'],
      ['asie', 'asi'],
      ['assailli', 'assaill'],
      ['assis', 'assis'],
      ['assista', 'assist'],
      ['attachent', 'attachent'],
      ['attenant', 'atten'],
      ['attribuer', 'attribu'],
      ['aveuglement', 'aveugl'],
      ['avocats', 'avocat'],
      ['avoue', 'avou'],
      ['banni', 'bann'],
      ['bataillon', 'bataillon'],
      ['baylen', 'baylen'],
      ['beurre', 'beurr'],
      ['bielle', 'biel'],
      ['bluffs', 'bluff'],
      ['blushes', 'blush'],
      ['bourgeois', 'bourgeois'],
      ['boutonnière', 'boutonni'],
      ['brins', 'brin'],
      ['britannique', 'britann'],
      ['brouillaient', 'brouill'],
      ['brouillard', 'brouillard'],
      ['brouiller', 'brouill'],
      ['brouillé', 'brouill'],
      ['brune', 'brun'],
      ['bréviaire', 'bréviair'],
      ['bâtiment', 'bât'],
      ['cabane', 'caban'],
      ['caféiers', 'caféi'],
      ['caressant', 'caress'],
      ['caricature', 'caricatur'],
      ['causée', 'caus'],
      ['cellule', 'cellul'],
      ['cenis', 'cen'],
      ['cercles', 'cercl'],
      ['chantèrent', 'chant'],
      ['charrettes', 'charret'],
      ['charron', 'charron'],
      ['chicorée', 'chicor'],
      ['choisis', 'chois'],
      ['chrétien', 'chrétien'],
      ['châle', 'châl'],
      ['ciceri', 'cicer'],
      ['cimabué', 'cimabu'],
      ['circonstances', 'circonst'],
      ['clochers', 'clocher'],
      ['colifichet', 'colifichet'],
      ['coloniser', 'colonis'],
      ['colorié', 'colori'],
      ['colères', 'coler'],
      ['commencements', 'commenc'],
      ['commensal', 'commensal'],
      ['comment', 'comment'],
      ['comptent', 'comptent'],
      ['concourent', 'concourent'],
      ['concurrent', 'concurrent'],
      ['conduisez', 'conduis'],
      ['confident', 'confident'],
      ['confucius', 'confucius'],
      ['conjure', 'conjur'],
      ['consacré', 'consacr'],
      ['consentait', 'consent'],
      ['contemple', 'contempl'],
      ['contine', 'contin'],
      ['continueront', 'continu'],
      ['contourne', 'contourn'],
      ['contraventions', 'contravent'],
      ['copié', 'copi'],
      ['corrège', 'correg'],
      ['coupure', 'coupur'],
      ['courent', 'courent'],
      ['courtisanerie', 'courtisaner'],
      ['coûte', 'coût'],
      ['coûter', 'coût'],
      ['coûterait', 'coût'],
      ['croisés', 'crois'],
      ['cruauté', 'cruaut'],
      ['dante', 'dant'],
      ['de', 'de'],
      ['demander', 'demand'],
      ['demeurait', 'demeur'],
      ['descendait', 'descend'],
      ['deviendrait', 'deviendr'],
      ['devinées', 'devin'],
      ['diar', 'diar'],
      ['disparut', 'disparut'],
      ['distances', 'distanc'],
      ['domination', 'domin'],
      ['dommage', 'dommag'],
      ['dompter', 'dompt'],
      ['donna', 'don'],
      ['donnaient', 'don'],
      ['dormirai', 'dorm'],
      ['dorées', 'dor'],
      ['doubla', 'doubl'],
      ['douta', 'dout'],
      ['dragons', 'dragon'],
      ['débuter', 'début'],
      ['décharge', 'décharg'],
      ['décorée', 'décor'],
      ['décrit', 'decr'],
      ['déduire', 'déduir'],
      ['défait', 'def'],
      ['défiler', 'défil'],
      ['délibérons', 'délibéron'],
      ['dépeint', 'dépeint'],
      ['dépense', 'dépens'],
      ['déplut', 'déplut'],
      ['dépôt', 'dépôt'],
      ['déraisonner', 'déraison'],
      ['désoeuvrement', 'désoeuvr'],
      ['détendu', 'détendu'],
      ['déterminations', 'détermin'],
      ['détournaient', 'détourn'],
      ['dévoreront', 'dévor'],
      ['dévorés', 'dévor'],
      ['ego', 'ego'],
      ['elles', 'elle'],
      ['embarquait', 'embarqu'],
      ['embarrasse', 'embarr'],
      ['emparés', 'empar'],
      ['emphatique', 'emphat'],
      ['empoisonnaient', 'empoison'],
      ['emporterez', 'emport'],
      ['enchanteurs', 'enchanteur'],
      ['encombre', 'encombr'],
      ['endurci', 'endurc'],
      ['enferma', 'enferm'],
      ['enluminée', 'enlumin'],
      ['ennius', 'ennius'],
      ['ennuyé', 'ennui'],
      ['entonné', 'enton'],
      ['errant', 'errant'],
      ['estimé', 'estim'],
      ['etc', 'etc'],
      ['evening', 'evening'],
      ['exposez', 'expos'],
      ['exprima', 'exprim'],
      ['fa', 'fa'],
      ['fabricant', 'fabric'],
      ['farceurs', 'farceur'],
      ['farine', 'farin'],
      ['fatigante', 'fatig'],
      ['favorisa', 'favoris'],
      ['ferais', 'fer'],
      ['feringhea', 'feringh'],
      ['foc', 'foc'],
      ['formaliste', 'formal'],
      ['formose', 'formos'],
      ['fortifié', 'fortifi'],
      ['fosses', 'foss'],
      ['furtivement', 'furtiv'],
      ['gaie', 'gai'],
      ['galons', 'galon'],
      ['galopait', 'galop'],
      ['garnie', 'garn'],
      ['gestes', 'gest'],
      ['giration', 'girat'],
      ['grandis', 'grand'],
      ['graveur', 'graveur'],
      ['grillé', 'grill'],
      ['grêles', 'grêl'],
      ['guère', 'guer'],
      ['gâte', 'gât'],
      ['générales', 'général'],
      ['hangar', 'hangar'],
      ['herbe', 'herb'],
      ['hissa', 'hiss'],
      ['honorés', 'honor'],
      ['horreur', 'horreur'],
      ['impitoyable', 'impitoi'],
      ['importent', 'importent'],
      ['impossible', 'impossibl'],
      ['indien', 'indien'],
      ['inflammation', 'inflamm'],
      ['innocentes', 'innocent'],
      ['insectes', 'insect'],
      ['insistant', 'insist'],
      ['insultes', 'insult'],
      ['intelligenti', 'intelligent'],
      ['intendant', 'intend'],
      ['intense', 'intens'],
      ['intenses', 'intens'],
      ['interroger', 'interrog'],
      ['interrompre', 'interrompr'],
      ['interruption', 'interrupt'],
      ['interviendrais', 'interviendr'],
      ['introduite', 'introduit'],
      ['irrite', 'irrit'],
      ['irrégulièrement', 'irréguli'],
      ['jadis', 'jad'],
      ['jailli', 'jaill'],
      ['jest', 'jest'],
      ['jonglaient', 'jongl'],
      ['joseph', 'joseph'],
      ['juché', 'juch'],
      ['jugeant', 'jug'],
      ['jurisconsulte', 'jurisconsult'],
      ['jurés', 'jur'],
      ['justice', 'justic'],
      ['khajours', 'khajour'],
      ['labourée', 'labour'],
      ['laisserez', 'laiss'],
      ['lesseps', 'lessep'],
      ['lever', 'lev'],
      ['libérateur', 'liber'],
      ['liqueurs', 'liqueur'],
      ['lorsqu', 'lorsqu'],
      ['loyalement', 'loyal'],
      ['loyaux', 'loyal'],
      ['lugubre', 'lugubr'],
      ['lugubrement', 'lugubr'],
      ['lui', 'lui'],
      ['légation', 'légat'],
      ['lésineries', 'lésiner'],
      ['maintint', 'maintint'],
      ['maire', 'mair'],
      ['majesté', 'majest'],
      ['malheureuses', 'malheur'],
      ['maltraitées', 'maltrait'],
      ['manquerai', 'manqu'],
      ['manufacturiers', 'manufacturi'],
      ['marchent', 'marchent'],
      ['marchiez', 'march'],
      ['marchions', 'marchion'],
      ['margot', 'margot'],
      ['marque', 'marqu'],
      ['marteau', 'marteau'],
      ['matière', 'mati'],
      ['mener', 'men'],
      ['merveilleusement', 'merveil'],
      ['mettent', 'mettent'],
      ['mettrons', 'mettron'],
      ['michaud', 'michaud'],
      ['michelet', 'michelet'],
      ['mis', 'mis'],
      ['modéra', 'moder'],
      ['monghir', 'mongh'],
      ['monture', 'montur'],
      ['moquait', 'moqu'],
      ['moyen', 'moyen'],
      ['multicolores', 'multicolor'],
      ['mutilé', 'mutil'],
      ['mâchais', 'mâch'],
      ['mâle', 'mâl'],
      ['médiocrité', 'médiocr'],
      ['ménager', 'ménag'],
      ['naissent', 'naissent'],
      ['nefs', 'nef'],
      ['nier', 'ni'],
      ['notices', 'notic'],
      ['nourrissant', 'nourr'],
      ['nouvel', 'nouvel'],
      ['obligeantes', 'oblig'],
      ['obligé', 'oblig'],
      ['obéit', 'obéit'],
      ['occupaient', 'occup'],
      ['occupent', 'occupent'],
      ['oiseau', 'oiseau'],
      ['ordonnes', 'ordon'],
      ['organiser', 'organis'],
      ['ory', 'ory'],
      ['outrant', 'outr'],
      ['outrez', 'outr'],
      ['ouvrir', 'ouvr'],
      ['pall', 'pall'],
      ['paperasses', 'paper'],
      ['parcouru', 'parcouru'],
      ['pardessus', 'pardessus'],
      ['pardonnez', 'pardon'],
      ['parent', 'parent'],
      ['paresse', 'paress'],
      ['parlassent', 'parl'],
      ['parlement', 'parl'],
      ['parliez', 'parl'],
      ['part', 'part'],
      ['particulière', 'particuli'],
      ['parties', 'part'],
      ['partirons', 'part'],
      ['parviendront', 'parviendront'],
      ['paré', 'par'],
      ['pas', 'pas'],
      ['patinant', 'patin'],
      ['patriciens', 'patricien'],
      ['pendable', 'pendabl'],
      ['pendus', 'pendus'],
      ['perce', 'perc'],
      ['perdait', 'perd'],
      ['perfection', 'perfect'],
      ['permission', 'permiss'],
      ['persans', 'persan'],
      ['petitesses', 'petitess'],
      ['phileas', 'phil'],
      ['phrase', 'phras'],
      ['piécettes', 'piécet'],
      ['placerai', 'plac'],
      ['plafonds', 'plafond'],
      ['plairait', 'plair'],
      ['plaque', 'plaqu'],
      ['politique', 'polit'],
      ['pondéré', 'ponder'],
      ['portât', 'port'],
      ['positions', 'posit'],
      ['pourparlers', 'pourparler'],
      ['pourrais', 'pourr'],
      ['poursuivait', 'poursuiv'],
      ['praticable', 'pratic'],
      ['presqu', 'presqu'],
      ['prestigieux', 'prestigi'],
      ['pria', 'pri'],
      ['principale', 'principal'],
      ['prises', 'pris'],
      ['produisaient', 'produis'],
      ['produisait', 'produis'],
      ['proférant', 'profer'],
      ['protégera', 'proteg'],
      ['prouveraient', 'prouv'],
      ['provinciale', 'provincial'],
      ['précédés', 'préced'],
      ['présentera', 'présent'],
      ['présentée', 'présent'],
      ['prévoir', 'prévoir'],
      ['prêchant', 'prêch'],
      ['puits', 'puit'],
      ['punirmi', 'punirm'],
      ['pusillanimité', 'pusillanim'],
      ['quadrupède', 'quadruped'],
      ['quelles', 'quel'],
      ['queue', 'queu'],
      ['quittez', 'quitt'],
      ['radouci', 'radouc'],
      ['rafale', 'rafal'],
      ['ralluma', 'rallum'],
      ['rame', 'ram'],
      ['ramures', 'ramur'],
      ['rapporté', 'rapport'],
      ['rassasier', 'rassasi'],
      ['ravissants', 'rav'],
      ['ravit', 'rav'],
      ['rayonna', 'rayon'],
      ['recevra', 'recevr'],
      ['recrues', 'recru'],
      ['rectifiait', 'rectifi'],
      ['relise', 'relis'],
      ['remontent', 'remontent'],
      ['remords', 'remord'],
      ['rencontrent', 'rencontrent'],
      ['rendaient', 'rend'],
      ['renonce', 'renonc'],
      ['renoncé', 'renonc'],
      ['reporté', 'report'],
      ['reproché', 'reproch'],
      ['retirée', 'retir'],
      ['retomberait', 'retomb'],
      ['revenait', 'reven'],
      ['rhin', 'rhin'],
      ['rideau', 'rideau'],
      ['risquer', 'risqu'],
      ['ruiné', 'ruin'],
      ['râpé', 'râp'],
      ['réclame', 'réclam'],
      ['rédigerait', 'rédig'],
      ['réfugiez', 'réfug'],
      ['répondit', 'répond'],
      ['répétions', 'répet'],
      ['rétablie', 'rétabl'],
      ['rétrécir', 'rétrec'],
      ['rêverie', 'rêver'],
      ['sac', 'sac'],
      ['sacrifices', 'sacrific'],
      ['saillies', 'saill'],
      ['saule', 'saul'],
      ['sauterait', 'saut'],
      ['sauté', 'saut'],
      ['scies', 'sci'],
      ['secourez', 'secour'],
      ['sellé', 'sel'],
      ['semelle', 'semel'],
      ['semée', 'sem'],
      ['serrés', 'serr'],
      ['servaient', 'serv'],
      ['sheridan', 'sheridan'],
      ['signaler', 'signal'],
      ['signalé', 'signal'],
      ['sinistres', 'sinistr'],
      ['sixième', 'sixiem'],
      ['siècle', 'siecl'],
      ['solide', 'solid'],
      ['sombre', 'sombr'],
      ['sortant', 'sort'],
      ['sortiez', 'sort'],
      ['sortirez', 'sort'],
      ['sotte', 'sott'],
      ['souvenez', 'souven'],
      ['starke', 'stark'],
      ['stations', 'station'],
      ['street', 'street'],
      ['stricte', 'strict'],
      ['sucre', 'sucr'],
      ['suivait', 'suiv'],
      ['suivent', 'suivent'],
      ['surnaturelle', 'surnaturel'],
      ['surprendre', 'surprendr'],
      ['suspendus', 'suspendus'],
      ['séparant', 'sépar'],
      ['séparé', 'sépar'],
      ['série', 'ser'],
      ['sérénades', 'sérénad'],
      ['tableaux', 'tableau'],
      ['tact', 'tact'],
      ['tam', 'tam'],
      ['tandis', 'tand'],
      ['teint', 'teint'],
      ['thousands', 'thousand'],
      ['tiens', 'tien'],
      ['tilbury', 'tilbury'],
      ['tirage', 'tirag'],
      ['tiré', 'tir'],
      ['tirée', 'tir'],
      ['traite', 'trait'],
      ['transcrire', 'transcrir'],
      ['transforment', 'transforment'],
      ['transocéaniennes', 'transocéanien'],
      ['travailla', 'travaill'],
      ['tremper', 'tremp'],
      ['tromperai', 'tromp'],
      ['troublaient', 'troubl'],
      ['trouverait', 'trouv'],
      ['trouvés', 'trouv'],
      ['tyrannisait', 'tyrannis'],
      ['unissez', 'uniss'],
      ['univers', 'univer'],
      ['valenod', 'valenod'],
      ['velléités', 'velléit'],
      ['venue', 'venu'],
      ['veuf', 'veuf'],
      ['vexé', 'vex'],
      ['victime', 'victim'],
      ['vindicatif', 'vindiqu'],
      ['violer', 'viol'],
      ['visible', 'visibl'],
      ['visions', 'vision'],
      ['vivandières', 'vivandi'],
      ['vous', 'vous'],
      ['voyager', 'voyag'],
      ['voyagez', 'voyag'],
      ['vécût', 'vécût'],
      ['vêtus', 'vêtus'],
      ['xxv', 'xxv'],
      ['yacht', 'yacht'],
      ['yachts', 'yacht'],
      ['échelles', 'échel'],
      ['éclaircissant', 'éclairc'],
      ['écouler', 'écoul'],
      ['écrie', 'écri'],
      ['écu', 'écu'],
      ['écus', 'écus'],
      ['élançant', 'élanc'],
      ['éperdue', 'éperdu'],
      ['étais', 'étais'],
      ['éteindre', 'éteindr'],
      ['éteindrons', 'éteindron'],
      ['étendirent', 'étend'],
      ['étonnante', 'éton']
    ];

    tests.forEach(function([word, stem]) {
      assert.strictEqual(porter(word), stem, `${word} => ${stem}`);
    });
  });
});
