/**
 * Talisman stemmers/spanish/unine tests
 * ======================================
 *
 */
import assert from 'assert';
import unine, {minimal} from '../../../src/stemmers/spanish/unine';

describe('unine', function() {

  describe('minimal', function() {
    it('default export should be the minimal stemmer.', function() {
      assert(unine('primas'), minimal('primas'));
    });

    it('should correctly stem the given words.', function() {
      const tests = [
        ['duo', 'duo'],
        ['airbus', 'airbus'],
        ['ofertas', 'ofert'],
        ['primas', 'prim'],
        ['funcionalidad', 'funcionalidad'],
        ['empatados', 'empatad'],
        ['dimitri', 'dimitri'],
        ['clones', 'clon'],
        ['nacimiento', 'nacimient'],
        ['muchedumbre', 'muchedumbr'],
        ['cupón', 'cupon'],
        ['tríos', 'tri'],
        ['variedades', 'variedad'],
        ['sadomasoquistas', 'sadomasoquist'],
        ['arroyó', 'arroy'],
        ['virulentos', 'virulent'],
        ['jaguares', 'jaguar'],
        ['avanzaba', 'avanzab'],
        ['ordeñarás', 'ordeñar'],
        ['consultora', 'consultor'],
        ['intermedia', 'intermedi'],
        ['constitucionales', 'constitucional'],
        ['comparto', 'compart'],
        ['hilario', 'hilari'],
        ['igualada', 'igualad'],
        ['colosio', 'colosi'],
        ['conferencias', 'conferenci'],
        ['dañarse', 'dañars'],
        ['conmigo', 'conmig'],
        ['sergi', 'sergi'],
        ['cástulo', 'castul'],
        ['pensiones', 'pension'],
        ['impositivos', 'impositiv'],
        ['alija', 'alij'],
        ['preocupaciones', 'preocupacion'],
        ['dieron', 'dieron'],
        ['marcaba', 'marcab'],
        ['llamativa', 'llamativ'],
        ['diana', 'dian'],
        ['regrese', 'regres'],
        ['airways', 'airways'],
        ['tipifica', 'tipific'],
        ['evaluado', 'evaluad'],
        ['turística', 'turistic'],
        ['morelos', 'morel'],
        ['composición', 'composicion'],
        ['ocasionalmente', 'ocasionalment'],
        ['circulando', 'circuland'],
        ['norteños', 'norteñ'],
        ['centímetros', 'centimetr'],
        ['black', 'black'],
        ['humo', 'humo'],
        ['letra', 'letr'],
        ['fundamento', 'fundament'],
        ['engorrosos', 'engorros'],
        ['cura', 'cura'],
        ['coloso', 'colos'],
        ['multados', 'multad'],
        ['paraguayo', 'paraguay'],
        ['navajearon', 'navajearon'],
        ['artillería', 'artilleri'],
        ['defina', 'defin'],
        ['set', 'set'],
        ['sujeto', 'sujet'],
        ['anuncian', 'anuncian'],
        ['suelos', 'suel'],
        ['cuestionado', 'cuestionad'],
        ['impersonal', 'impersonal'],
        ['onceavo', 'onceav'],
        ['impondría', 'impondri'],
        ['ofenderá', 'ofender'],
        ['albiceleste', 'albicelest'],
        ['versiones', 'version'],
        ['amplia', 'ampli'],
        ['poste', 'post'],
        ['cornalina', 'cornalin'],
        ['caudalosos', 'caudalos'],
        ['milan', 'milan'],
        ['laureano', 'laurean'],
        ['maremoto', 'maremot'],
        ['apegada', 'apegad'],
        ['days', 'days'],
        ['biodegradable', 'biodegradabl'],
        ['descuidos', 'descuid'],
        ['saltaron', 'saltaron'],
        ['etnografía', 'etnografi'],
        ['concordia', 'concordi'],
        ['desacuerdo', 'desacuerd'],
        ['medallón', 'medallon'],
        ['etapa', 'etap'],
        ['estimula', 'estimul'],
        ['treviñada', 'treviñad'],
        ['comisiones', 'comision'],
        ['belleza', 'bellez'],
        ['subterráneo', 'subterrane'],
        ['tripulado', 'tripulad'],
        ['camisetas', 'camiset'],
        ['alcanza', 'alcanz'],
        ['incide', 'incid'],
        ['encontraban', 'encontraban'],
        ['colofón', 'colofon'],
        ['partícipes', 'particip'],
        ['aplasta', 'aplast'],
        ['relacionadas', 'relacionad'],
        ['kbytes', 'kbyt'],
        ['desangraba', 'desangrab'],
        ['rebobinar', 'rebobinar'],
        ['alzheimer', 'alzheimer'],
        ['incendiarias', 'incendiari'],
        ['lendl', 'lendl'],
        ['padrones', 'padron'],
        ['tomlinson', 'tomlinson'],
        ['liberó', 'liber'],
        ['lobo', 'lobo'],
        ['manejes', 'manej'],
        ['clasificar', 'clasificar'],
        ['revelaban', 'revelaban'],
        ['hedrick', 'hedrick'],
        ['enigmático', 'enigmatic'],
        ['demuestren', 'demuestren'],
        ['soberanía', 'soberani'],
        ['potente', 'potent'],
        ['corrían', 'corrian'],
        ['acciones', 'accion'],
        ['tregua', 'tregu'],
        ['barres', 'barr'],
        ['terminarse', 'terminars'],
        ['adoptó', 'adopt'],
        ['vendados', 'vendad'],
        ['contundentes', 'contundent'],
        ['indicando', 'indicand'],
        ['bancarias', 'bancari'],
        ['meneses', 'menes'],
        ['haga', 'haga'],
        ['newport', 'newport'],
        ['absurdo', 'absurd'],
        ['sincero', 'sincer'],
        ['gil', 'gil'],
        ['lamosa', 'lamos'],
        ['transformaciones', 'transformacion'],
        ['acuarios', 'acuari'],
        ['salas', 'sal'],
        ['peseras', 'peser'],
        ['colocando', 'colocand'],
        ['prosinecky', 'prosinecky'],
        ['indebidos', 'indebid'],
        ['depredadores', 'depredador'],
        ['confirmaron', 'confirmaron'],
        ['penúltimo', 'penultim'],
        ['archivo', 'archiv'],
        ['matineé', 'matine'],
        ['sumen', 'sumen'],
        ['atendamos', 'atendam'],
        ['entregándoles', 'entregandol'],
        ['hará', 'hará'],
        ['espectaculares', 'espectacular'],
        ['edificaciones', 'edificacion'],
        ['lesiona', 'lesion'],
        ['cobren', 'cobren'],
        ['ordene', 'orden'],
        ['muda', 'muda'],
        ['editados', 'editad'],
        ['grotewold', 'grotewold'],
        ['tragedia', 'tragedi'],
        ['regular', 'regular'],
        ['causar', 'causar'],
        ['garantiza', 'garantiz'],
        ['negoció', 'negoci'],
        ['unacolumna', 'unacolumn'],
        ['catamo', 'catam'],
        ['fresco', 'fresc'],
        ['titipuchal', 'titipuchal'],
        ['sobreposición', 'sobreposicion'],
        ['fonseca', 'fonsec'],
        ['arrebatar', 'arrebatar'],
        ['tisa', 'tisa'],
        ['establecidas', 'establecid'],
        ['boris', 'boris'],
        ['coyolxauhqui', 'coyolxauhqui'],
        ['convertidores', 'convertidor'],
        ['puesta', 'puest'],
        ['síndicos', 'sindic'],
        ['vaporosa', 'vaporos'],
        ['irrealizables', 'irrealizabl'],
        ['confirmada', 'confirmad'],
        ['dedeó', 'dede'],
        ['ilustraciones', 'ilustracion'],
        ['acumulado', 'acumulad'],
        ['caraqueña', 'caraqueñ'],
        ['concedían', 'concedian'],
        ['conocedores', 'conocedor'],
        ['canseco', 'cansec'],
        ['lidereados', 'lideread'],
        ['barinas', 'barin'],
        ['prohibida', 'prohibid'],
        ['buscarlo', 'buscarl'],
        ['declaraban', 'declaraban'],
        ['serio', 'seri'],
        ['mitológico', 'mitologic'],
        ['privilegio', 'privilegi']
      ];

      tests.forEach(function([word, stem]) {
        assert.strictEqual(unine(word), stem);
      });
    });
  });
});
