/**
 * Talisman stemmers/latin/schinke tests
 * ======================================
 *
 */
import assert from 'assert';
import schinke from '../../../src/stemmers/latin/schinke';

describe('schinke', function() {
  it('should correctly stem the given words.', function() {
    const tests = [
      ['aetheriis', 'aetheri', 'aetherii'],
      ['intermissione', 'intermission', 'intermissione'],
      ['circumsessum', 'circumsess', 'circumsessu'],
      ['receptu', 'recept', 'receptu'],
      ['convertunt', 'conuertu', 'conuerti'],
      ['ostenditur', 'ostenditur', 'ostendi'],
      ['fuisse', 'fuiss', 'fuisse'],
      ['sexto', 'sext', 'sexto'],
      ['eloquentem', 'eloquent', 'eloquente'],
      ['abunde', 'abund', 'abunde'],
      ['piceno', 'picen', 'piceno'],
      ['criminationi', 'crimination', 'criminationi'],
      ['adventu', 'aduent', 'aduentu'],
      ['contumeliam', 'contumeli', 'contumelia'],
      ['vallium', 'ualli', 'ualliu'],
      ['afluant', 'aflua', 'aflua'],
      ['vivet', 'uiuet', 'uiue'],
      ['iumentis', 'iument', 'iumen'],
      ['agrestes', 'agrest', 'agreste'],
      ['proferrem', 'proferr', 'proferre'],
      ['laeuaque', 'laeu', 'laeua'],
      ['debitorem', 'debitor', 'debitore'],
      ['repositum', 'reposit', 'repositu'],
      ['totos', 'tot', 'toto'],
      ['telum', 'tel', 'telu'],
      ['pugnantium', 'pugnanti', 'pugnantiu'],
      ['coacta', 'coact', 'coacta'],
      ['maximo', 'maxim', 'maximo'],
      ['contentionem', 'contention', 'contentione'],
      ['commeans', 'commeans', 'commea'],
      ['pertenderunt', 'pertenderu', 'pertendi'],
      ['communemque', 'commun', 'commune'],
      ['renovataeque', 'renouat', 'renouatae'],
      ['immineant', 'imminea', 'imminea'],
      ['codro', 'codr', 'codro'],
      ['fingebantur', 'fingebantur', 'fingeba'],
      ['uoluptas', 'uolupt', 'uolupta'],
      ['cogitaverim', 'cogitauerim', 'cogitaueri'],
      ['iurgium', 'iurgi', 'iurgiu'],
      ['brumisque', 'brum', 'brumi'],
      ['subveniat', 'subueniat', 'subuenia'],
      ['concipitur', 'concipitur', 'concipi'],
      ['iucundus', 'iucund', 'iucundu'],
      ['inaequalem', 'inaequal', 'inaequale'],
      ['perducta', 'perduct', 'perducta'],
      ['extraque', 'extr', 'extra'],
      ['quiritibusque', 'quirit', 'quiritibu'],
      ['fidenas', 'fiden', 'fidena'],
      ['aestus', 'aest', 'aestu'],
      ['reponi', 'repon', 'reponi'],
      ['privat', 'priuat', 'priua'],
      ['matutinis', 'matutin', 'matutini'],
      ['mandataque', 'mandat', 'mandata'],
      ['dextra', 'dextr', 'dextra'],
      ['patriam', 'patri', 'patria'],
      ['accedit', 'accedit', 'accedi'],
      ['adoperto', 'adopert', 'adoperto'],
      ['agraria', 'agrar', 'agraria'],
      ['tacita', 'tacit', 'tacita'],
      ['aether', 'aether', 'aethe'],
      ['ferocissimo', 'ferocissim', 'ferocissimo'],
      ['gravissime', 'grauissim', 'grauissime'],
      ['habituris', 'habitur', 'habitu'],
      ['eundemque', 'eund', 'eunde'],
      ['commigravit', 'commigrauit', 'commigraui'],
      ['finire', 'finir', 'finire'],
      ['valetudinis', 'ualetudin', 'ualetudini'],
      ['heroicis', 'heroic', 'heroici'],
      ['love', 'lou', 'loue'],
      ['corneliusque', 'cornel', 'corneliu'],
      ['consulibusque', 'consul', 'consulibu'],
      ['incuteret', 'incuteret', 'incutere'],
      ['propinqui', 'propinqu', 'propinqui'],
      ['declinauere', 'declinauer', 'declinauere'],
      ['interfectus', 'interfect', 'interfectu'],
      ['senatusque', 'senat', 'senatu'],
      ['plebesque', 'pleb', 'plebe'],
      ['hippolytum', 'hippolyt', 'hippolytu'],
      ['pepercissent', 'pepercisse', 'pepercisse'],
      ['uiuae', 'uiu', 'uiuae'],
      ['epulisque', 'epul', 'epuli'],
      ['stando', 'stand', 'stando'],
      ['accepissent', 'accepisse', 'accepisse'],
      ['propriis', 'propri', 'proprii'],
      ['funditus', 'fundit', 'funditu'],
      ['externiue', 'externiu', 'externiue'],
      ['laeserat', 'laeserat', 'laesera'],
      ['bestiae', 'besti', 'bestiae'],
      ['sancte', 'sanct', 'sancte'],
      ['credente', 'credent', 'credente'],
      ['verbum', 'uerb', 'uerbu'],
      ['insolitum', 'insolit', 'insolitu'],
      ['poenae', 'poen', 'poenae'],
      ['conversa', 'conuers', 'conuersa'],
      ['nocturnis', 'nocturn', 'nocturni'],
      ['depopulatos', 'depopulat', 'depopulato'],
      ['ostentauerant', 'ostentauera', 'ostentauera'],
      ['evocatorum', 'euocator', 'euocatoru'],
      ['contineat', 'contineat', 'continea'],
      ['iaceret', 'iaceret', 'iacere'],
      ['abducturum', 'abductur', 'abducturu'],
      ['latarum', 'latar', 'lataru'],
      ['quoniamque', 'quoni', 'quonia'],
      ['alienatione', 'alienation', 'alienatione'],
      ['patibilem', 'patibil', 'patibile'],
      ['decernitur', 'decernitur', 'decerni'],
      ['habetis', 'habet', 'habe'],
      ['immanes', 'imman', 'immane'],
      ['pedestri', 'pedestr', 'pedest'],
      ['agrestiumque', 'agresti', 'agrestiu'],
      ['inlitos', 'inlit', 'inlito'],
      ['simultates', 'simultat', 'simultate'],
      ['occultissime', 'occultissim', 'occultissime'],
      ['demetendi', 'demetend', 'demetendi'],
      ['paruere', 'paruer', 'paruere'],
      ['damno', 'damn', 'damno'],
      ['ambo', 'amb', 'ambi'],
      ['cernunt', 'cernu', 'cerni'],
      ['cohorsque', 'cohors', 'cohor'],
      ['accendisset', 'accendisset', 'accendisse'],
      ['adhibemus', 'adhibem', 'adhibe'],
      ['oppuguatione', 'oppuguation', 'oppuguatione'],
      ['doctrinae', 'doctrin', 'doctrinae'],
      ['exorsus', 'exors', 'exorsu'],
      ['captiuorum', 'captiuor', 'captiuoru'],
      ['tignisque', 'tign', 'tigni'],
      ['duumuir', 'duumuir', 'duumui'],
      ['recens', 'recens', 'rece'],
      ['ceperunt', 'ceperu', 'cepi'],
      ['democritum', 'democrit', 'democritu'],
      ['exspectate', 'exspectat', 'exspectate'],
      ['concoxerit', 'concoxerit', 'concoxeri'],
      ['superare', 'superar', 'superare'],
      ['pauidus', 'pauid', 'pauidu'],
      ['pertinaciter', 'pertinaciter', 'pertinacite'],
      ['absolui', 'absolu', 'absolui'],
      ['concresceret', 'concresceret', 'concrescere'],
      ['placidiorem', 'placidior', 'placidiore'],
      ['abnuit', 'abnuit', 'abnui'],
      ['vinci', 'uinc', 'uinci'],
      ['clamitatum', 'clamitat', 'clamitatu'],
      ['breuior', 'breuior', 'breuio'],
      ['regias', 'regi', 'regia'],
      ['genera', 'gener', 'genera'],
      ['praestantissimae', 'praestantissim', 'praestantissimae'],
      ['uersus', 'uers', 'uersu'],
      ['praeualens', 'praeualens', 'praeuale'],
      ['frequenter', 'frequenter', 'frequente'],
      ['dialem', 'dial', 'diale'],
      ['privatae', 'priuat', 'priuatae'],
      ['damnatum', 'damnat', 'damnatu'],
      ['tuendo', 'tuend', 'tuendo'],
      ['damnatumque', 'damnat', 'damnatu'],
      ['impediebantur', 'impediebantur', 'impedieba'],
      ['quarto', 'quart', 'quarto'],
      ['duaeque', 'du', 'duae'],
      ['muneri', 'muner', 'mune'],
      ['moliuntur', 'moliuntur', 'moli'],
      ['praemiaque', 'praem', 'praemia'],
      ['fluxisse', 'fluxiss', 'fluxisse'],
      ['transitu', 'transit', 'transitu'],
      ['sentitis', 'sentit', 'senti'],
      ['cycladibusque', 'cyclad', 'cycladibu'],
      ['convenisset', 'conuenisset', 'conuenisse'],
      ['virginem', 'uirgin', 'uirgine'],
      ['dubitationem', 'dubitation', 'dubitatione'],
      ['comparatam', 'comparat', 'comparata'],
      ['privatum', 'priuat', 'priuatu'],
      ['durior', 'durior', 'durio'],
      ['uirisque', 'uir', 'ui'],
      ['deseram', 'deser', 'desera'],
      ['stomachabatur', 'stomachabatur', 'stomachaba'],
      ['tumultuantibus', 'tumultuant', 'tumultuantibu'],
      ['interdiu', 'interdi', 'interdiu'],
      ['placandosque', 'placand', 'placando'],
      ['stephanen', 'stephanen', 'stephanen'],
      ['exspectari', 'exspectar', 'exspecta'],
      ['subrutam', 'subrut', 'subruta'],
      ['locatus', 'locat', 'locatu'],
      ['iuvaret', 'iuuaret', 'iuuare'],
      ['vires', 'uir', 'uire'],
      ['folius', 'fol', 'foliu'],
      ['conlucens', 'conlucens', 'conluce'],
      ['mirati', 'mirat', 'mirati'],
      ['coagmenta', 'coagment', 'coagmenta'],
      ['dubium', 'dubi', 'dubiu'],
      ['volcanus', 'uolcan', 'uolcanu'],
      ['constitisset', 'constitisset', 'constitisse'],
      ['uictum', 'uict', 'uictu'],
      ['aduersa', 'aduers', 'aduersa'],
      ['mandatur', 'mandatur', 'manda'],
      ['secuti', 'secut', 'secuti'],
      ['ostendens', 'ostendens', 'ostende'],
      ['saluti', 'salut', 'saluti'],
      ['tonitribus', 'tonitr', 'tonitribu'],
      ['adsuescunt', 'adsuescu', 'adsuesci'],
      ['alpinis', 'alpin', 'alpini'],
      ['tempestive', 'tempestiu', 'tempestiue'],
      ['sedando', 'sedand', 'sedando'],
      ['cedentes', 'cedent', 'cedente'],
      ['hercule', 'hercul', 'hercule'],
      ['sinceri', 'sincer', 'since'],
      ['indicantis', 'indicant', 'indican'],
      ['intentus', 'intent', 'intentu'],
      ['coli', 'col', 'coli'],
      ['remissis', 'remiss', 'remissi'],
      ['eloquentia', 'eloquent', 'eloquentia'],
      ['pomptinoque', 'pomptin', 'pomptino'],
      ['placandos', 'placand', 'placando'],
      ['auxiliaque', 'auxil', 'auxilia'],
      ['praestatis', 'praestat', 'praesta'],
      ['viget', 'uiget', 'uige'],
      ['capit', 'capit', 'capi'],
      ['saturnalia', 'saturnal', 'saturnalia'],
      ['laelianas', 'laelian', 'laeliana'],
      ['stramento', 'strament', 'stramento'],
      ['comprimerent', 'comprimere', 'comprimere'],
      ['inuiderunt', 'inuideru', 'inuidi'],
      ['defectiones', 'defection', 'defectione'],
      ['leuiorem', 'leuior', 'leuiore'],
      ['profundo', 'profund', 'profundo'],
      ['afuerat', 'afuerat', 'afuera'],
      ['superasse', 'superass', 'superasse'],
      ['arrepto', 'arrept', 'arrepto'],
      ['statione', 'station', 'statione'],
      ['miti', 'mit', 'miti'],
      ['veturium', 'ueturi', 'ueturiu'],
      ['cubiculum', 'cubicul', 'cubiculu'],
      ['territando', 'territand', 'territando'],
      ['profecerunt', 'profeceru', 'profeci'],
      ['refugiebant', 'refugieba', 'refugieba'],
      ['mansimus', 'mansim', 'mansi'],
      ['caluus', 'calu', 'caluu'],
      ['designati', 'designat', 'designati'],
      ['tardaret', 'tardaret', 'tardare'],
      ['mensium', 'mensi', 'mensiu'],
      ['gladio', 'gladi', 'gladio'],
      ['exigite', 'exigit', 'exigite'],
      ['partibus', 'part', 'partibu'],
      ['faciliora', 'facilior', 'faciliora'],
      ['repetere', 'repeter', 'repetere'],
      ['luxere', 'luxer', 'luxere'],
      ['gratulatione', 'gratulation', 'gratulatione'],
      ['senatui', 'senatu', 'senatui'],
      ['scripti', 'script', 'scripti'],
      ['pugnabant', 'pugnaba', 'pugnaba'],
      ['saeculum', 'saecul', 'saeculu'],
      ['adfirmat', 'adfirmat', 'adfirma'],
      ['platone', 'platon', 'platone'],
      ['dirimerentur', 'dirimerentur', 'dirimere'],
      ['religatus', 'religat', 'religatu'],
      ['ardeatium', 'ardeati', 'ardeatiu'],
      ['invocatae', 'inuocat', 'inuocatae'],
      ['impari', 'impar', 'impa'],
      ['horatiumque', 'horati', 'horatiu'],
      ['castelli', 'castell', 'castelli'],
      ['idoneo', 'idone', 'idoneo'],
      ['imponeret', 'imponeret', 'imponere'],
      ['suppliciis', 'supplici', 'supplicii'],
      ['diuisique', 'diuis', 'diuisi'],
      ['vertisset', 'uertisset', 'uertisse'],
      ['hippocentaurum', 'hippocentaur', 'hippocentauru'],
      ['errori', 'error', 'erro'],
      ['beneficiis', 'benefici', 'beneficii'],
      ['utebantur', 'utebantur', 'uteba'],
      ['dii', 'di', 'dii'],
      ['corvo', 'coru', 'coruo'],
      ['adductae', 'adduct', 'adductae'],
      ['omittamus', 'omittam', 'omitta'],
      ['planioribus', 'planior', 'planioribu'],
      ['solo', 'sol', 'solo'],
      ['visae', 'uis', 'uisae'],
      ['concitante', 'concitant', 'concitante'],
      ['ementita', 'ementit', 'ementita'],
      ['opprimi', 'opprim', 'opprimi'],
      ['sensisset', 'sensisset', 'sensisse'],
      ['civitatibus', 'ciuitat', 'ciuitatibu'],
      ['igitur', 'igitur', 'igi'],
      ['reicere', 'reicer', 'reicere'],
      ['claudiis', 'claudi', 'claudii'],
      ['omisso', 'omiss', 'omisso'],
      ['bullide', 'bullid', 'bullide'],
      ['deductam', 'deduct', 'deducta'],
      ['xenocraten', 'xenocraten', 'xenocraten'],
      ['remanserat', 'remanserat', 'remansera'],
      ['graius', 'gra', 'graiu'],
      ['conclusit', 'conclusit', 'conclusi'],
      ['loquimur', 'loquimur', 'loqui'],
      ['prosequentium', 'prosequenti', 'prosequentiu'],
      ['corrigi', 'corrig', 'corrigi'],
      ['gignendi', 'gignend', 'gignendi'],
      ['pristino', 'pristin', 'pristino'],
      ['diona', 'dion', 'diona'],
      ['circumsessa', 'circumsess', 'circumsessa'],
      ['perituros', 'peritur', 'perituro'],
      ['succedenti', 'succedent', 'succedenti'],
      ['statum', 'stat', 'statu'],
      ['impositos', 'imposit', 'imposito'],
      ['geminis', 'gemin', 'gemini'],
      ['speciesque', 'speci', 'specie'],
      ['infirmatis', 'infirmat', 'infirma'],
      ['spurillium', 'spurilli', 'spurilliu'],
      ['muniebant', 'munieba', 'munieba'],
      ['relinqui', 'relinqu', 'relinqui'],
      ['compulissent', 'compulisse', 'compulisse'],
      ['diceretilla', 'diceretill', 'diceretilla'],
      ['praetor', 'praetor', 'praeto'],
      ['perennem', 'perenn', 'perenne'],
      ['auentinum', 'auentin', 'auentinu'],
      ['calficiendum', 'calficiend', 'calficiendu'],
      ['fidenter', 'fidenter', 'fidente'],
      ['humanam', 'human', 'humana'],
      ['capiendum', 'capiend', 'capiendu'],
      ['potenti', 'potent', 'potenti'],
      ['innumerabilia', 'innumerabil', 'innumerabilia'],
      ['regebat', 'regebat', 'regeba'],
      ['penuria', 'penur', 'penuria'],
      ['inuecta', 'inuect', 'inuecta'],
      ['uetando', 'uetand', 'uetando'],
      ['supervacuaneum', 'superuacuane', 'superuacuaneu'],
      ['deducendas', 'deducend', 'deducenda'],
      ['vocataque', 'uocat', 'uocata'],
      ['clausas', 'claus', 'clausa'],
      ['ferebat', 'ferebat', 'fereba'],
      ['regentem', 'regent', 'regente'],
      ['mediterranei', 'mediterrane', 'mediterranei'],
      ['aluerint', 'alueri', 'alueri'],
      ['incohastis', 'incohast', 'incoha'],
      ['circumitio', 'circumiti', 'circumitio'],
      ['seruilis', 'seruil', 'seruili'],
      ['errabundi', 'errabund', 'errabundi'],
      ['mamillio', 'mamilli', 'mamillio'],
      ['apparitor', 'apparitor', 'apparito'],
      ['expugnavit', 'expugnauit', 'expugnaui'],
      ['abundans', 'abundans', 'abunda'],
      ['vendidit', 'uendidit', 'uendidi'],
      ['humanis', 'human', 'humani'],
      ['liberator', 'liberator', 'liberato'],
      ['conclamatione', 'conclamation', 'conclamatione'],
      ['regis', 'reg', 'regi'],
      ['altissimis', 'altissim', 'altissimi'],
      ['philosophari', 'philosophar', 'philosopha'],
      ['familiari', 'familiar', 'familia'],
      ['necessitatem', 'necessitat', 'necessitate'],
      ['invocans', 'inuocans', 'inuoca'],
      ['increparent', 'increpare', 'increpare'],
      ['arsippi', 'arsipp', 'arsippi'],
      ['nexos', 'nex', 'nexo'],
      ['uitiis', 'uiti', 'uitii'],
      ['timaeus', 'timae', 'timaeu'],
      ['accipias', 'accipi', 'accipia'],
      ['consularibus', 'consular', 'consularibu'],
      ['primo', 'prim', 'primo'],
      ['nominavi', 'nominau', 'nominaui'],
      ['turpem', 'turp', 'turpe'],
      ['pretii', 'preti', 'pretii'],
      ['compertum', 'compert', 'compertu'],
      ['metrodorum', 'metrodor', 'metrodoru'],
      ['traduxit', 'traduxit', 'traduxi'],
      ['hausto', 'haust', 'hausto'],
      ['decreverint', 'decreueri', 'decreueri'],
      ['legionariasque', 'legionari', 'legionaria'],
      ['iungeretur', 'iungeretur', 'iungere'],
      ['praetulit', 'praetulit', 'praetuli'],
      ['alites', 'alit', 'alite'],
      ['inferentibus', 'inferent', 'inferentibu'],
      ['uiolati', 'uiolat', 'uiolati'],
      ['animadvertis', 'animaduert', 'animaduer'],
      ['profectos', 'profect', 'profecto'],
      ['nocturnisque', 'nocturn', 'nocturni'],
      ['decertare', 'decertar', 'decertare'],
      ['conspiciuntur', 'conspiciuntur', 'conspici'],
      ['nostris', 'nostr', 'nost'],
      ['auruncum', 'aurunc', 'auruncu'],
      ['sufficiebat', 'sufficiebat', 'sufficieba'],
      ['intermiserant', 'intermisera', 'intermisera'],
      ['resistebant', 'resisteba', 'resisteba'],
      ['cedebat', 'cedebat', 'cedeba'],
      ['ueneno', 'uenen', 'ueneno'],
      ['cubilibus', 'cubil', 'cubilibu'],
      ['attus', 'att', 'attu'],
      ['obsiderent', 'obsidere', 'obsidere'],
      ['id', 'id', 'id'],
      ['obscurior', 'obscurior', 'obscurio'],
      ['praeconibus', 'praecon', 'praeconibu'],
      ['fugerat', 'fugerat', 'fugera'],
      ['euastata', 'euastat', 'euastata'],
      ['crastini', 'crastin', 'crastini'],
      ['suppleto', 'supplet', 'suppleto'],
      ['pabulo', 'pabul', 'pabulo'],
      ['admonemur', 'admonemur', 'admone'],
      ['elabitur', 'elabitur', 'elabi'],
      ['deceat', 'deceat', 'decea'],
      ['incipiant', 'incipia', 'incipia'],
      ['tabescit', 'tabescit', 'tabesci'],
      ['adhibito', 'adhibit', 'adhibito'],
      ['deliberare', 'deliberar', 'deliberare'],
      ['possedisset', 'possedisset', 'possedisse'],
      ['reprendenda', 'reprendend', 'reprendenda'],
      ['virorum', 'uiror', 'uiroru'],
      ['dementiam', 'dementi', 'dementia'],
      ['seruauit', 'seruauit', 'seruaui'],
      ['vastauerant', 'uastauera', 'uastauera'],
      ['seselis', 'sesel', 'seseli'],
      ['senatoris', 'senator', 'senato'],
      ['ingerit', 'ingerit', 'ingeri'],
      ['saeuiebatur', 'saeuiebatur', 'saeuieba'],
      ['possimus', 'possim', 'possi'],
      ['conservatur', 'conseruatur', 'conserua'],
      ['campestris', 'campestr', 'campest'],
      ['disciplinamque', 'disciplin', 'disciplina'],
      ['egredi', 'egred', 'egredi'],
      ['brute', 'brut', 'brute'],
      ['uictoriam', 'uictori', 'uictoria'],
      ['gomphensium', 'gomphensi', 'gomphensiu'],
      ['unicam', 'unic', 'unica'],
      ['conferret', 'conferret', 'conferre'],
      ['scrutantur', 'scrutantur', 'scruta'],
      ['crederetur', 'crederetur', 'credere'],
      ['frumentum', 'frument', 'frumentu'],
      ['cognominem', 'cognomin', 'cognomine'],
      ['aquam', 'aqu', 'aqua'],
      ['appellandi', 'appelland', 'appellandi'],
      ['tendendo', 'tendend', 'tendendo'],
      ['sursus', 'surs', 'sursu'],
      ['saeptis', 'saept', 'saep'],
      ['hippocentauro', 'hippocentaur', 'hippocentauro'],
      ['rursus', 'rurs', 'rursu'],
      ['appetisse', 'appetiss', 'appetisse'],
      ['crescebant', 'cresceba', 'cresceba'],
      ['uicum', 'uic', 'uicu'],
      ['pridem', 'prid', 'pride'],
      ['prohibuere', 'prohibuer', 'prohibuere'],
      ['timore', 'timor', 'timore'],
      ['ecquos', 'ecqu', 'ecquo'],
      ['certis', 'cert', 'cer'],
      ['mitterentur', 'mitterentur', 'mittere'],
      ['consequerentur', 'consequerentur', 'consequere'],
      ['adpulsus', 'adpuls', 'adpulsu'],
      ['scandet', 'scandet', 'scande'],
      ['mortalisque', 'mortal', 'mortali'],
      ['beatissimos', 'beatissim', 'beatissimo'],
      ['direptum', 'dirept', 'direptu'],
      ['veteremque', 'ueter', 'uetere'],
      ['attio', 'atti', 'attio'],
      ['pullos', 'pull', 'pullo'],
      ['iactabantur', 'iactabantur', 'iactaba'],
      ['expletus', 'explet', 'expletu'],
      ['intentiorque', 'intentior', 'intentio'],
      ['praesto', 'praest', 'praesto'],
      ['inventor', 'inuentor', 'inuento'],
      ['lucceio', 'luccei', 'lucceio'],
      ['praeciditur', 'praeciditur', 'praecidi'],
      ['humidum', 'humid', 'humidu'],
      ['castigantibus', 'castigant', 'castigantibu'],
      ['laborantis', 'laborant', 'laboran'],
      ['confirmandos', 'confirmand', 'confirmando'],
      ['portae', 'port', 'portae'],
      ['veritatemque', 'ueritat', 'ueritate'],
      ['occasiones', 'occasion', 'occasione'],
      ['obtectus', 'obtect', 'obtectu'],
      ['renovatum', 'renouat', 'renouatu'],
      ['responderunt', 'responderu', 'respondi'],
      ['signatum', 'signat', 'signatu'],
      ['contionis', 'contion', 'contioni'],
      ['uadis', 'uad', 'uadi'],
      ['auctionem', 'auction', 'auctione'],
      ['circumdedit', 'circumdedit', 'circumdedi'],
      ['imperium', 'imperi', 'imperiu'],
      ['valuit', 'ualuit', 'ualui'],
      ['coepimus', 'coepim', 'coepi'],
      ['concipiendum', 'concipiend', 'concipiendu'],
      ['generatam', 'generat', 'generata'],
      ['iurare', 'iurar', 'iurare'],
      ['seruauerant', 'seruauera', 'seruauera'],
      ['examen', 'examen', 'examen'],
      ['conlaudatis', 'conlaudat', 'conlauda'],
      ['uioler', 'uioler', 'uiole'],
      ['conscendissent', 'conscendisse', 'conscendisse'],
      ['censeat', 'censeat', 'censea'],
      ['aquitanis', 'aquitan', 'aquitani'],
      ['via', 'uia', 'uia'],
      ['munitiones', 'munition', 'munitione'],
      ['diuisae', 'diuis', 'diuisae'],
      ['digitorum', 'digitor', 'digitoru'],
      ['rutulique', 'rutul', 'rutuli'],
      ['stirpem', 'stirp', 'stirpe'],
      ['occultae', 'occult', 'occultae'],
      ['audiuit', 'audiuit', 'audiui'],
      ['commercio', 'commerci', 'commercio'],
      ['superanti', 'superant', 'superanti'],
      ['determinavit', 'determinauit', 'determinaui'],
      ['deligati', 'deligat', 'deligati'],
      ['serviebant', 'seruieba', 'seruieba'],
      ['putent', 'pute', 'pute'],
      ['praeeuntibus', 'praeeunt', 'praeeuntibu'],
      ['dicebat', 'dicebat', 'diceba'],
      ['clusini', 'clusin', 'clusini'],
      ['sublatum', 'sublat', 'sublatu'],
      ['curium', 'curi', 'curiu'],
      ['reconciliandi', 'reconciliand', 'reconciliandi']
    ];

    tests.forEach(function([word, nounStem, verbStem]) {
      const stems = schinke(word);

      assert.strictEqual(stems.noun, nounStem);
      assert.strictEqual(stems.verb, verbStem);
    });
  });
});
