/**
 * Talisman phonetics/doubleMetaphone tests
 * =========================================
 *
 */
import assert from 'assert';
import doubleMetaphone from '../../src/phonetics/doubleMetaphone';

describe('doubleMetaphone', function() {

  it('should throw if the given word is not a string.', function() {
    assert.throws(function() {
      doubleMetaphone([]);
    }, /string/);
  });

  it('should compute the doubleMetaphone code correctly.', function() {
    const tests = [
      [['SM0', 'XMT'], 'Smith'],
      [['XMT', 'SMT'], 'Schmidt'],
      [['TKXN', 'TKXN'], 'dictionary'],
      [['ANTL', 'ANTL'], 'entelechy'],
      [['NK', 'NK'], 'knock'],
      [['RNKL', 'RNKL'], 'wrangler'],
      [['ALMS', 'FLMS'], 'Williams'],
      [['AKTN', 'AKTN'], 'Yucatan'],
      [['HSTK', 'HSTK'], 'haystack'],
      [['AKSS', 'AKSS'], 'axis'],
      [['MJR', 'MJR'], 'mujer'],
      [['TJN', 'TJN'], 'tijuana'],
      [['AKSN', 'AKXN'], 'Occasionally'],
      [['ANTT', 'ANTT'], 'antidisestablishmentarianism'],
      [['APRS', 'APRX'], 'appreciated'],
      [['PJNN', 'PKNN'], 'beginning'],
      [['XNJN', 'XNKN'], 'changing'],
      [['XT', 'XT'], 'cheat'],
      [['TNJR', 'TNKR'], 'dangerous'],
      [['TFLP', 'TFLP'], 'development'],
      [['ATLJ', 'ATLK'], 'etiology'],
      [['AKSS', 'AKSS'], 'existence'],
      [['SMPL', 'SMPL'], 'simplicity'],
      [['SRKM', 'SRKM'], 'circumstances'],
      [['FR', 'FR'], 'fiery'],
      [['FPRR', 'FPRR'], 'february'],
      [['ALJT', 'ALKT'], 'illegitimate'],
      [['AMTT', 'AMTT'], 'immediately'],
      [['HPL', 'HPL'], 'happily'],
      [['JTKM', 'ATKM'], 'judgment'],
      [['NNK', 'NNK'], 'knowing'],
      [['KPR', 'KPR'], 'kipper'],
      [['JN', 'AN'], 'john'],
      [['LSN', 'LXN'], 'lesion'],
      [['SF', 'SFR'], 'Xavier'],
      [['TM', 'TM'], 'dumb'],
      [['SSR', 'SSR'], 'caesar'],
      [['KNT', 'KNT'], 'chianti'],
      [['MKL', 'MXL'], 'michael'],
      [['KMST', 'KMST'], 'chemistry'],
      [['KRS', 'KRS'], 'chorus'],
      [['ARKT', 'ARKT'], 'architect'],
      [['ARX', 'ARK'], 'arch'],
      [['ARKS', 'ARKS'], 'orchestra'],
      [['ARKT', 'ARKT'], 'orchid'],
      [['AKTL', 'FKTL'], 'wachtler'],
      [['AKSL', 'FKSL'], 'wechsler'],
      [['TXNR', 'TKNR'], 'tichner'],
      [['MK', 'MK'], 'McHugh'],
      [['SRN', 'XRN'], 'czerny'],
      [['FKX', 'FKX'], 'focaccia'],
      [['PLX', 'PLX'], 'bellocchio'],
      [['PKS', 'PKS'], 'bacchus'],
      [['AKST', 'AKST'], 'accident'],
      [['AKST', 'AKST'], 'accede'],
      [['SKST', 'SKST'], 'succeed'],
      [['PRTX', 'PRTX'], 'bertucci'],
      [['MKFR', 'MKFR'], 'mac caffrey'],
      [['MKRK', 'MKRK'], 'mac gregor'],
      [['AJ', 'AJ'], 'edge'],
      [['ATKR', 'ATKR'], 'edgar'],
      [['JLN', 'JLN'], 'ghislane'],
      [['JRTL', 'JRTL'], 'ghiradelli'],
      [['H', 'H'], 'hugh'],
      [['P', 'P'], 'bough'],
      [['PRTN', 'PRTN'], 'broughton'],
      [['LF', 'LF'], 'laugh'],
      [['MKLF', 'MKLF'], 'McLaughlin'],
      [['KF', 'KF'], 'cough'],
      [['KF', 'KF'], 'gough'],
      [['RF', 'RF'], 'rough'],
      [['TF', 'TF'], 'tough'],
      [['KKN', 'KKN'], 'cagney'],
      [['TKLR', 'TLR'], 'tagliaro'],
      [['PJ', 'PK'], 'biaggi'],
      [['SNHS', 'SNHS'], 'san jacinto'],
      [['ANKL', 'ANKL'], 'Yankelovich'],
      [['JNKL', 'ANKL'], 'Jankelowicz'],
      [['PJTR', 'PHTR'], 'bajador'],
      [['KPRL', 'KPR'], 'cabrillo'],
      [['KLKS', 'KKS'], 'gallegos'],
      [['TM', 'TM'], 'dumb'],
      [['0M', 'TM'], 'thumb'],
      [['KMPL', 'KMPL'], 'campbell'],
      [['RSPR', 'RSPR'], 'raspberry'],
      [['HKMR', 'HKMR'], 'hochmeier'],
      [['ALNT', 'ALNT'], 'island'],
      [['AL', 'AL'], 'isle'],
      [['KRLL', 'KRLL'], 'carlisle'],
      [['KRLL', 'KRLL'], 'carlysle'],
      [['SNTR', 'XNTR'], 'snider'],
      [['XNTR', 'SNTR'], 'schneider'],
      [['SKL', 'SKL'], 'school'],
      [['SKNR', 'SKNR'], 'schooner'],
      [['XRMR', 'SKRM'], 'schermerhorn'],
      [['XNKR', 'SKNK'], 'schenker'],
      [['RSN', 'RSNS'], 'resnais'],
      [['ART', 'ARTS'], 'artois'],
      [['TMS', 'TMS'], 'thomas'],
      [['ASRM', 'FSRM'], 'Wasserman'],
      [['FSRM', 'FSRM'], 'Vasserman'],
      [['AM', 'AM'], 'Uomo'],
      [['AM', 'FM'], 'Womo'],
      [['ARN', 'ARNF'], 'Arnow'],
      [['ARNF', 'ARNF'], 'Arnoff'],
      [['FLPT', 'FLPF'], 'filipowicz'],
      [['PR', 'PR'], 'breaux'],
      [['J', 'J'], 'zhao'],
      [['TMS', 'TMS'], 'thames'],
    ];

    tests.forEach(function([code, word]) {
      assert.deepEqual(doubleMetaphone(word), code, word);
    });
  });
});
