//    
//  PDCSSTypes.h
//  PonyDebuggerDerivedSources
//
//  Generated on 8/23/12
//
//  Licensed to Square, Inc. under one or more contributor license agreements.
//  See the LICENSE file distributed with this work for the terms under
//  which Square, Inc. licenses this file to you.
//
    
#import <PonyDebugger/PDObject.h>
#import <PonyDebugger/PDDebugger.h>
#import <PonyDebugger/PDDynamicDebuggerDomain.h>


@class PDCSSSourceRange;
@class PDCSSCSSStyle;


// This object identifies a CSS style in a unique way.
@interface PDCSSCSSStyleId : PDObject

// Enclosing stylesheet identifier.
@property (nonatomic, strong) NSString *styleSheetId;

// The style ordinal within the stylesheet.
// Type: integer
@property (nonatomic, strong) NSNumber *ordinal;

@end


// This object identifies a CSS rule in a unique way.
@interface PDCSSCSSRuleId : PDObject

// Enclosing stylesheet identifier.
@property (nonatomic, strong) NSString *styleSheetId;

// The rule ordinal within the stylesheet.
// Type: integer
@property (nonatomic, strong) NSNumber *ordinal;

@end


// CSS rule collection for a single pseudo style.
@interface PDCSSPseudoIdRules : PDObject

// Pseudo style identifier (see <code>enum PseudoId</code> in <code>RenderStyleConstants.h</code>).
// Type: integer
@property (nonatomic, strong) NSNumber *pseudoId;

// CSS rules applicable to the pseudo style.
// Type: array
@property (nonatomic, strong) NSArray *rules;

@end


// CSS rule collection for a single pseudo style.
@interface PDCSSInheritedStyleEntry : PDObject

// The ancestor node's inline style, if any, in the style inheritance chain.
@property (nonatomic, strong) PDCSSCSSStyle *inlineStyle;

// CSS rules matching the ancestor node in the style inheritance chain.
// Type: array
@property (nonatomic, strong) NSArray *matchedCSSRules;

@end


// CSS style information for a DOM style attribute.
@interface PDCSSCSSStyleAttribute : PDObject

// DOM attribute name (e.g. "width").
// Type: string
@property (nonatomic, strong) NSString *name;

// CSS style generated by the respective DOM attribute.
@property (nonatomic, strong) PDCSSCSSStyle *style;

@end


// CSS stylesheet metainformation.
@interface PDCSSCSSStyleSheetHeader : PDObject

// The stylesheet identifier.
@property (nonatomic, strong) NSString *styleSheetId;

// Owner frame identifier.
@property (nonatomic, strong) NSString *frameId;

// Stylesheet resource URL.
// Type: string
@property (nonatomic, strong) NSString *sourceURL;

// Stylesheet origin.
@property (nonatomic, strong) NSString *origin;

// Stylesheet title.
// Type: string
@property (nonatomic, strong) NSString *title;

// Denotes whether the stylesheet is disabled.
// Type: boolean
@property (nonatomic, strong) NSNumber *disabled;

@end


// CSS stylesheet contents.
@interface PDCSSCSSStyleSheetBody : PDObject

// The stylesheet identifier.
@property (nonatomic, strong) NSString *styleSheetId;

// Stylesheet resource URL.
// Type: array
@property (nonatomic, strong) NSArray *rules;

// Stylesheet resource contents (if available).
// Type: string
@property (nonatomic, strong) NSString *text;

@end


// CSS rule representation.
@interface PDCSSCSSRule : PDObject

// The CSS rule identifier (absent for user agent stylesheet and user-specified stylesheet rules).
@property (nonatomic, strong) PDCSSCSSRuleId *ruleId;

// Rule selector.
// Type: string
@property (nonatomic, strong) NSString *selectorText;

// Parent stylesheet resource URL (for regular rules).
// Type: string
@property (nonatomic, strong) NSString *sourceURL;

// Line ordinal of the rule selector start character in the resource.
// Type: integer
@property (nonatomic, strong) NSNumber *sourceLine;

// Parent stylesheet's origin.
@property (nonatomic, strong) NSString *origin;

// Associated style declaration.
@property (nonatomic, strong) PDCSSCSSStyle *style;

// The rule selector range in the underlying resource (if available).
@property (nonatomic, strong) PDCSSSourceRange *selectorRange;

// Media list array (for rules involving media queries). The array enumerates media queries starting with the innermost one, going outwards.
// Type: array
@property (nonatomic, strong) NSArray *media;

@end


// Text range within a resource.
@interface PDCSSSourceRange : PDObject

// Start of range (inclusive).
// Type: integer
@property (nonatomic, strong) NSNumber *start;

// End of range (exclusive).
// Type: integer
@property (nonatomic, strong) NSNumber *end;

@end


@interface PDCSSShorthandEntry : PDObject

// Shorthand name.
// Type: string
@property (nonatomic, strong) NSString *name;

// Shorthand value.
// Type: string
@property (nonatomic, strong) NSString *value;

@end


@interface PDCSSCSSPropertyInfo : PDObject

// Property name.
// Type: string
@property (nonatomic, strong) NSString *name;

// Longhand property names.
// Type: array
@property (nonatomic, strong) NSArray *longhands;

@end


@interface PDCSSCSSComputedStyleProperty : PDObject

// Computed style property name.
// Type: string
@property (nonatomic, strong) NSString *name;

// Computed style property value.
// Type: string
@property (nonatomic, strong) NSString *value;

@end


// CSS style representation.
@interface PDCSSCSSStyle : PDObject

// The CSS style identifier (absent for attribute styles).
@property (nonatomic, strong) PDCSSCSSStyleId *styleId;

// CSS properties in the style.
// Type: array
@property (nonatomic, strong) NSArray *cssProperties;

// Computed values for all shorthands found in the style.
// Type: array
@property (nonatomic, strong) NSArray *shorthandEntries;

// Style declaration text (if available).
// Type: string
@property (nonatomic, strong) NSString *cssText;

// Style declaration range in the enclosing stylesheet (if available).
@property (nonatomic, strong) PDCSSSourceRange *range;

// The effective "width" property value from this style.
// Type: string
@property (nonatomic, strong) NSString *width;

// The effective "height" property value from this style.
// Type: string
@property (nonatomic, strong) NSString *height;

@end


// CSS style effective visual dimensions and source offsets.
@interface PDCSSCSSProperty : PDObject

// The property name.
// Type: string
@property (nonatomic, strong) NSString *name;

// The property value.
// Type: string
@property (nonatomic, strong) NSString *value;

// The property priority (implies "" if absent).
// Type: string
@property (nonatomic, strong) NSString *priority;

// Whether the property is implicit (implies <code>false</code> if absent).
// Type: boolean
@property (nonatomic, strong) NSNumber *implicit;

// The full property text as specified in the style.
// Type: string
@property (nonatomic, strong) NSString *text;

// Whether the property is understood by the browser (implies <code>true</code> if absent).
// Type: boolean
@property (nonatomic, strong) NSNumber *parsedOk;

// The property status: "active" (implied if absent) if the property is effective in the style, "inactive" if the property is overridden by a same-named property in this style later on, "disabled" if the property is disabled by the user, "style" if the property is reported by the browser rather than by the CSS source parser.
// Type: string
@property (nonatomic, strong) NSString *status;

// The entire property range in the enclosing style declaration (if available).
@property (nonatomic, strong) PDCSSSourceRange *range;

@end


// CSS media query descriptor.
@interface PDCSSCSSMedia : PDObject

// Media query text.
// Type: string
@property (nonatomic, strong) NSString *text;

// Source of the media query: "mediaRule" if specified by a @media rule, "importRule" if specified by an @import rule, "linkedSheet" if specified by a "media" attribute in a linked stylesheet's LINK tag, "inlineSheet" if specified by a "media" attribute in an inline stylesheet's STYLE tag.
// Type: string
@property (nonatomic, strong) NSString *source;

// URL of the document containing the media query description.
// Type: string
@property (nonatomic, strong) NSString *sourceURL;

// Line in the document containing the media query (not defined for the "stylesheet" source).
// Type: integer
@property (nonatomic, strong) NSNumber *sourceLine;

@end


// CSS selector profile entry.
@interface PDCSSSelectorProfileEntry : PDObject

// CSS selector of the corresponding rule.
// Type: string
@property (nonatomic, strong) NSString *selector;

// URL of the resource containing the corresponding rule.
// Type: string
@property (nonatomic, strong) NSString *url;

// Selector line number in the resource for the corresponding rule.
// Type: integer
@property (nonatomic, strong) NSNumber *lineNumber;

// Total time this rule handling contributed to the browser running time during profiling (in milliseconds.)
// Type: number
@property (nonatomic, strong) NSNumber *time;

// Number of times this rule was considered a candidate for matching against DOM elements.
// Type: integer
@property (nonatomic, strong) NSNumber *hitCount;

// Number of times this rule actually matched a DOM element.
// Type: integer
@property (nonatomic, strong) NSNumber *matchCount;

@end


@interface PDCSSSelectorProfile : PDObject

// Total processing time for all selectors in the profile (in milliseconds.)
// Type: number
@property (nonatomic, strong) NSNumber *totalTime;

// CSS selector profile entries.
// Type: array
@property (nonatomic, strong) NSArray *data;

@end


// This object represents a region that flows from a Named Flow.
@interface PDCSSRegion : PDObject

// The "overset" attribute of a Named Flow.
// Type: string
@property (nonatomic, strong) NSString *regionOverset;

// The corresponding DOM node id.
@property (nonatomic, strong) NSNumber *nodeId;

@end


// This object represents a Named Flow.
@interface PDCSSNamedFlow : PDObject

// The document node id.
@property (nonatomic, strong) NSNumber *documentNodeId;

// Named Flow identifier.
// Type: string
@property (nonatomic, strong) NSString *name;

// The "overset" attribute of a Named Flow.
// Type: boolean
@property (nonatomic, strong) NSNumber *overset;

// An array of nodes that flow into the Named Flow.
// Type: array
@property (nonatomic, strong) NSArray *content;

// An array of regions associated with the Named Flow.
// Type: array
@property (nonatomic, strong) NSArray *regions;

@end


