<?php

namespace Drupal\ts_generator\ComponentGenerator\Field;

use Drupal\Core\Config\Entity\ConfigEntityTypeInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Field\FieldTypePluginManagerInterface;
use Drupal\ts_generator\ComponentResult;
use Drupal\ts_generator\Result;
use Drupal\ts_generator\Settings;
use Symfony\Component\DependencyInjection\Container;

class EntityReferenceFieldGenerator extends FieldGenerator {
  protected $supportedFieldType = ['entity_reference', 'entity_reference_revisions', 'image', 'file'];

  /**
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  public function __construct(FieldTypePluginManagerInterface $fieldTypePluginManager, EntityTypeManagerInterface $entityTypeManager) {
    parent::__construct($fieldTypePluginManager);

    $this->entityTypeManager = $entityTypeManager;
  }

  protected function getCoreName($object) {
    return Container::camelize($object->getType());
  }

  protected function getName($object, Settings $settings, Result $result, ComponentResult $component_result) {
    return $this->getCoreName($object) . Container::camelize($object->getSettings()['target_type']);
  }

  protected function getItemProperties($object, Settings $settings, Result $result, ComponentResult $component_result) {
    $properties = parent::getItemProperties($object, $settings, $result, $component_result);

    $properties['target_type'] = 'string';
    $properties['target_uuid'] = 'string';

    if ($this->hasUrl($object)) {
      $properties['url'] = 'string';
    }

    return $properties;
  }

  public function getItemMapping($object, $properties, Settings $settings, Result $result, ComponentResult $componentResult) {
    if (isset($properties['url'])) {
      return ['id' => 'target_id', 'url'];
    } else {
      return 'target_id';
    }
    // return parent::getItemMapping($object, $properties, $settings, $result, $componentResult); // TODO: Change the autogenerated stub
  }

  protected function hasUrl($object) {
    /** @var \Drupal\Core\Field\FieldDefinitionInterface $object */
    if ($object->getSettings()['target_type'] == 'file') {
      return TRUE;
    }

    $entity_type = $this->entityTypeManager->getDefinition($object->getSettings()['target_type']);
    return $entity_type->hasLinkTemplate('canonical');
  }

  public function generateType($object, Settings $settings, Result $result, ComponentResult $componentResult) {
    /** @var \Drupal\Core\Field\FieldDefinitionInterface $object */
    $type = parent::generateType($object, $settings, $result, $componentResult);

    $entity_type = $this->entityTypeManager->getDefinition($object->getSettings()['target_type']);
    $name = $this->getItemName($object, $settings, $result, $componentResult);
    if ($entity_type instanceof ConfigEntityTypeInterface) {
      $componentResult->setComponent('specific_item_type', $result->setComponent('types/' . $name . 'Specific', "type " . $name . "Specific<T> = " . $componentResult->getContext('item')->getComponent('type') . " & {\n  target_id: T,\n}"));
    }

    return $type;
  }
}