/*
 * Copyright 2012 ZXing authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import "EAN13BlackBox4TestCase.h"
#import "ZXMultiFormatReader.h"

@implementation EAN13BlackBox4TestCase

- (id)initWithInvocation:(NSInvocation *)anInvocation {
  self = [super initWithInvocation:anInvocation
                testBasePathSuffix:@"Resources/blackbox/ean13-4"
                     barcodeReader:[[[ZXMultiFormatReader alloc] init] autorelease]
                    expectedFormat:kBarcodeFormatEan13];

  if (self) {
    // NOTE (costa@scvngr.com) The java version of ZXing has 6 and 13
    [self addTest:5 tryHarderCount:12 maxMisreads:1 maxTryHarderMisreads:1 rotation:0.0f];

    // NOTE (costa@scvngr.com) The java version of ZXing has 7 and 13
    [self addTest:7 tryHarderCount:12 maxMisreads:1 maxTryHarderMisreads:1 rotation:180.0f];
  }

  return self;
}

- (void)testBlackBox {
  [super runTests];
}

@end
