package vulnerability

import (
	dbTypes "github.com/aquasecurity/trivy-db/pkg/types"
	"github.com/aquasecurity/trivy/pkg/types"
	"github.com/stretchr/testify/mock"
)

type MockVulnClient struct {
	mock.Mock
}

func NewMockVulnClient() *MockVulnClient {
	mockVulnClient := new(MockVulnClient)
	mockVulnClient.On("FillInfo", mock.Anything, mock.Anything)
	return mockVulnClient
}

func (_m *MockVulnClient) FillInfo(a []types.DetectedVulnerability, b bool) {
	_m.Called(a, b)
}

func (_m *MockVulnClient) Filter(a []types.DetectedVulnerability, b []dbTypes.Severity,
	c bool, d string) []types.DetectedVulnerability {
	ret := _m.Called(a, b, c, d)
	ret0 := ret.Get(0)
	if ret0 == nil {
		return nil
	}
	vulns, ok := ret0.([]types.DetectedVulnerability)
	if !ok {
		return nil
	}
	return vulns
}
