/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.uninstall;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.InstallerFactory;
import com.baidu.rasp.uninstall.Uninstaller;
import java.io.File;

public abstract class UninstallerFactory {
    protected static final String TOMCAT = "Tomcat";
    protected static final String JBOSS = "JBoss 4-6";
    protected static final String RESIN = "Resin";

    protected abstract Uninstaller getUninstaller(String var1, String var2);

    public Uninstaller getUninstaller(File serverRoot) throws RaspError {
        if (!serverRoot.exists()) {
            throw new RaspError(RaspError.E10002 + serverRoot.getPath());
        }
        String serverName = InstallerFactory.detectServerName(serverRoot.getAbsolutePath());
        if (serverName == null) {
            System.out.println("List of currently supported servers are:");
            System.out.println("- Tomcat");
            System.out.println("- Resin");
            System.out.println("- JBoss 4-6\n");
            throw new RaspError(RaspError.E10004 + serverRoot.getPath());
        }
        System.out.println("Detected application server type: " + serverName);
        return this.getUninstaller(serverName, serverRoot.getAbsolutePath());
    }
}

