/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.uninstall;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.BaseStandardInstaller;
import com.baidu.rasp.uninstall.Uninstaller;
import java.io.File;
import java.io.IOException;

public abstract class BaseStandardUninstaller
implements Uninstaller {
    private String serverRoot;
    private String serverName;
    public static String LINE_SEP = System.getProperty("line.separator");

    public BaseStandardUninstaller(String serverName, String serverRoot) {
        this.serverRoot = serverRoot;
        this.serverName = serverName;
    }

    @Override
    public void uninstall() throws RaspError, IOException {
        File installDir = new File(this.getInstallPath(this.serverRoot));
        BaseStandardInstaller.modifyFolerPermission(installDir.getCanonicalPath());
        this.delRaspFolder(this.getInstallPath(this.serverRoot));
        File script = new File(this.getScript(installDir.getPath()));
        if (!script.exists()) {
            throw new RaspError(RaspError.E10003 + script.getAbsolutePath());
        }
        System.out.println("Updating startup script\n- " + script.getCanonicalPath());
        String original = BaseStandardInstaller.read(script);
        String modified = this.recoverStartScript(original);
        BaseStandardInstaller.write(script, modified);
        System.out.println("\nUninstallation completed without errors.\nPlease restart application server to take effect.");
    }

    public void delAllFile(String path) throws RaspError {
        File file = new File(path);
        String[] tempList = file.list();
        File temp = null;
        for (String s : tempList) {
            temp = path.endsWith(File.separator) ? new File(path + s) : new File(path + File.separator + s);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + File.separator + s);
            this.delRaspFolder(path + File.separator + s);
        }
    }

    public void delRaspFolder(String folderPath) throws RaspError {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            throw new RaspError(RaspError.E10002 + folderPath);
        }
        this.delAllFile(folderPath);
        folder.delete();
    }

    protected abstract String getInstallPath(String var1);

    protected abstract String getScript(String var1);

    protected abstract String recoverStartScript(String var1) throws RaspError;
}

