/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.install.linux;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.BaseStandardInstaller;
import java.util.Scanner;
import java.util.regex.Pattern;

public class TomcatInstaller
extends BaseStandardInstaller {
    private static String OPENRASP_CONFIG = "### BEGIN OPENRASP - DO NOT MODIFY ###\n\tJAVA_OPTS=\"-javaagent:${CATALINA_HOME}/rasp/rasp.jar ${JAVA_OPTS}\"\n\tJAVA_OPTS=\"-Dlog4j.rasp.configuration=file://${CATALINA_HOME}/rasp/conf/rasp-log4j.xml ${JAVA_OPTS}\"\n### END OPENRASP ###\n";
    private static Pattern OPENRASP_REGEX = Pattern.compile(".*(\\s*OPENRASP\\s*|JAVA_OPTS.*/rasp/).*");

    TomcatInstaller(String serverName, String serverRoot) {
        super(serverName, serverRoot);
    }

    @Override
    protected String getInstallPath(String serverRoot) {
        return serverRoot + "/rasp/";
    }

    @Override
    protected String getScript(String installDir) {
        return installDir + "/../bin/catalina.sh";
    }

    @Override
    protected String modifyStartScript(String content) throws RaspError {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(content);
        int modifyConfigState = NOTFOUND;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (!line.startsWith("#") && (line.contains("\"$1\" = \"start\"") || line.contains("\"$1\" = \"run\""))) {
                modifyConfigState = FOUND;
                sb.append(line).append("\n");
                sb.append(OPENRASP_CONFIG);
                continue;
            }
            if (OPENRASP_REGEX.matcher(line).matches()) continue;
            sb.append(line).append("\n");
        }
        if (NOTFOUND == modifyConfigState) {
            throw new RaspError(RaspError.E10001 + "[\"$1\" = \"start\"] or [\"$1\" = \"run\"]");
        }
        return sb.toString();
    }
}

