/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.rasp.install.linux;

import com.baidu.rasp.RaspError;
import com.baidu.rasp.install.BaseStandardInstaller;
import java.util.Scanner;
import java.util.regex.Pattern;

public class Jboss4Installer
extends BaseStandardInstaller {
    private static String OPENRASP_CONFIG = "### BEGIN OPENRASP - DO NOT MODIFY ###\n\tJAVA_OPTS=\"-javaagent:${JBOSS_HOME}/rasp/rasp.jar ${JAVA_OPTS}\"\n\tJAVA_OPTS=\"-Dlog4j.rasp.configuration=file://${JBOSS_HOME}/rasp/conf/rasp-log4j.xml ${JAVA_OPTS}\"\n### END OPENRASP ###\n";
    private static Pattern OPENRASP_REGEX = Pattern.compile(".*(\\s*OPENRASP\\s*|JAVA_OPTS.*/rasp/).*");

    Jboss4Installer(String serverName, String serverRoot) {
        super(serverName, serverRoot);
    }

    @Override
    protected String getInstallPath(String serverRoot) {
        return serverRoot + "/rasp";
    }

    @Override
    protected String getScript(String installPath) {
        return installPath + "/../bin/run.sh";
    }

    @Override
    protected String modifyStartScript(String content) throws RaspError {
        int modifyConfigState = NOTFOUND;
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(content);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (FOUND == modifyConfigState) {
                sb.append(OPENRASP_CONFIG);
                modifyConfigState = DONE;
            }
            if (DONE == modifyConfigState && OPENRASP_REGEX.matcher(line).matches()) continue;
            if (line.startsWith("JAVA_OPTS=") && NOTFOUND == modifyConfigState) {
                modifyConfigState = FOUND;
            }
            sb.append(line).append(LINE_SEP);
        }
        if (NOTFOUND == modifyConfigState) {
            throw new RaspError(RaspError.E10001 + "\"JAVA_OPTS=\"");
        }
        return sb.toString();
    }
}

